/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.hugegraph.loader.progress.FileItemProgress;
import org.apache.hugegraph.loader.progress.InputItemProgress;
import org.apache.hugegraph.loader.progress.InputProgress;
import org.apache.hugegraph.loader.serializer.DeserializeException;
import org.apache.hugegraph.loader.source.SourceType;
import org.apache.hugegraph.loader.util.JsonUtil;
import org.apache.hugegraph.util.InsertionOrderUtil;

public class InputProgressDeser
extends JsonDeserializer<InputProgress> {
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_LOADED_ITEMS = "loaded_items";
    private static final String FIELD_LOADING_ITEM = "loading_items";

    public InputProgress deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        return InputProgressDeser.readInputProgress(node);
    }

    private static InputProgress readInputProgress(JsonNode node) {
        JsonNode typeNode = InputProgressDeser.getNode(node, FIELD_TYPE, JsonNodeType.STRING);
        String type = typeNode.asText().toUpperCase();
        SourceType sourceType = SourceType.valueOf(type);
        JsonNode loadedItemsNode = InputProgressDeser.getNode(node, FIELD_LOADED_ITEMS, JsonNodeType.OBJECT);
        JsonNode loadingItemsNode = InputProgressDeser.getNode(node, FIELD_LOADING_ITEM, JsonNodeType.OBJECT, JsonNodeType.NULL);
        Map<String, InputItemProgress> loadedItems = Collections.synchronizedMap(InsertionOrderUtil.newMap());
        Map<String, InputItemProgress> loadingItems = Collections.synchronizedMap(InsertionOrderUtil.newMap());
        switch (sourceType) {
            case FILE: 
            case HDFS: {
                Map<String, FileItemProgress> items = JsonUtil.convertMap(loadedItemsNode, String.class, FileItemProgress.class);
                loadedItems.putAll(items);
                items = JsonUtil.convertMap(loadingItemsNode, String.class, FileItemProgress.class);
                loadingItems.putAll(items);
                break;
            }
            case JDBC: {
                break;
            }
            case KAFKA: {
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unsupported input source '%s'", type));
            }
        }
        return new InputProgress(sourceType, loadedItems, loadingItems);
    }

    private static JsonNode getNode(JsonNode node, String name, JsonNodeType ... nodeTypes) {
        JsonNode subNode = node.get(name);
        if (subNode == null) {
            throw DeserializeException.expectField(name, node);
        }
        if (!ImmutableSet.copyOf((Object[])nodeTypes).contains((Object)subNode.getNodeType())) {
            throw DeserializeException.expectTypes(name, nodeTypes);
        }
        return subNode;
    }
}

