/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.MemoryEstimate;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.BytesBytesMultiHashMap;
import org.apache.hadoop.hive.ql.exec.persistence.HashMapWrapper;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerDirectAccess;
import org.apache.hadoop.hive.ql.exec.persistence.ReusableGetAdaptorDirectAccess;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapper;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapperBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.WriteBuffers;
import org.apache.hadoop.hive.serde2.binarysortable.BinarySortableSerDe;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryFactory;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryStruct;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryUtils;
import org.apache.hadoop.hive.serde2.lazybinary.objectinspector.LazyBinaryObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.lazybinary.objectinspector.LazyBinaryStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hive.common.util.HashCodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapJoinBytesTableContainer
implements MapJoinTableContainer,
MapJoinTableContainerDirectAccess {
    private static final Logger LOG = LoggerFactory.getLogger(MapJoinTableContainer.class);
    public static final long DEFAULT_OBJECT_INSPECTOR_MEMORY_SIZE = 16384L;
    private final BytesBytesMultiHashMap hashMap;
    private LazyBinaryStructObjectInspector internalValueOi;
    private boolean[] sortableSortOrders;
    private byte[] nullMarkers;
    private byte[] notNullMarkers;
    private KeyValueHelper writeHelper;
    private DirectKeyValueWriter directWriteHelper;
    private final List<Object> EMPTY_LIST = new ArrayList<Object>(0);

    public MapJoinBytesTableContainer(Configuration hconf, MapJoinObjectSerDeContext valCtx, long keyCount, long memUsage) throws SerDeException {
        this(HiveConf.getFloatVar(hconf, HiveConf.ConfVars.HIVEHASHTABLEKEYCOUNTADJUSTMENT), HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEHASHTABLETHRESHOLD), HiveConf.getFloatVar(hconf, HiveConf.ConfVars.HIVEHASHTABLELOADFACTOR), HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEHASHTABLEWBSIZE), valCtx, keyCount, memUsage);
    }

    private MapJoinBytesTableContainer(float keyCountAdj, int threshold, float loadFactor, int wbSize, MapJoinObjectSerDeContext valCtx, long keyCount, long memUsage) throws SerDeException {
        int newThreshold = HashMapWrapper.calculateTableSize(keyCountAdj, threshold, loadFactor, keyCount);
        this.hashMap = new BytesBytesMultiHashMap(newThreshold, loadFactor, wbSize, memUsage);
        this.directWriteHelper = new DirectKeyValueWriter();
    }

    public MapJoinBytesTableContainer(BytesBytesMultiHashMap hashMap) {
        this.hashMap = hashMap;
    }

    private LazyBinaryStructObjectInspector createInternalOi(MapJoinObjectSerDeContext valCtx) throws SerDeException {
        List<? extends StructField> fields = ((StructObjectInspector)valCtx.getSerDe().getObjectInspector()).getAllStructFieldRefs();
        ArrayList<String> colNames = new ArrayList<String>(fields.size());
        ArrayList<ObjectInspector> colOis = new ArrayList<ObjectInspector>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            StructField field = fields.get(i);
            colNames.add(field.getFieldName());
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString(field.getFieldObjectInspector().getTypeName());
            colOis.add(LazyBinaryUtils.getLazyBinaryObjectInspectorFromTypeInfo(typeInfo));
        }
        return LazyBinaryObjectInspectorFactory.getLazyBinaryStructObjectInspector(colNames, colOis);
    }

    public void setInternalValueOi(LazyBinaryStructObjectInspector internalValueOi) {
        this.internalValueOi = internalValueOi;
    }

    public void setSortableSortOrders(boolean[] sortableSortOrders) {
        this.sortableSortOrders = sortableSortOrders;
    }

    public void setNullMarkers(byte[] nullMarkers) {
        this.nullMarkers = nullMarkers;
    }

    public void setNotNullMarkers(byte[] notNullMarkers) {
        this.notNullMarkers = notNullMarkers;
    }

    @Override
    public void setSerde(MapJoinObjectSerDeContext keyContext, MapJoinObjectSerDeContext valueContext) throws SerDeException {
        AbstractSerDe keySerde = keyContext.getSerDe();
        AbstractSerDe valSerde = valueContext.getSerDe();
        if (this.writeHelper == null) {
            LOG.info("Initializing container with " + keySerde.getClass().getName() + " and " + valSerde.getClass().getName());
            if (keySerde instanceof BinarySortableSerDe && valSerde instanceof LazyBinarySerDe) {
                LazyBinaryStructObjectInspector valSoi = (LazyBinaryStructObjectInspector)valSerde.getObjectInspector();
                this.writeHelper = new LazyBinaryKvWriter(keySerde, valSoi, valueContext.hasFilterTag());
                this.internalValueOi = valSoi;
                this.sortableSortOrders = ((BinarySortableSerDe)keySerde).getSortOrders();
                this.nullMarkers = ((BinarySortableSerDe)keySerde).getNullMarkers();
                this.notNullMarkers = ((BinarySortableSerDe)keySerde).getNotNullMarkers();
            } else {
                this.writeHelper = new KeyValueWriter(keySerde, valSerde, valueContext.hasFilterTag());
                this.internalValueOi = this.createInternalOi(valueContext);
                this.sortableSortOrders = null;
                this.nullMarkers = null;
                this.notNullMarkers = null;
            }
        }
    }

    @Override
    public MapJoinKey putRow(Writable currentKey, Writable currentValue) throws SerDeException {
        this.writeHelper.setKeyValue(currentKey, currentValue);
        this.hashMap.put(this.writeHelper, -1);
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public MapJoinKey getAnyKey() {
        return null;
    }

    @Override
    public MapJoinTableContainer.ReusableGetAdaptor createGetter(MapJoinKey keyTypeFromLoader) {
        if (keyTypeFromLoader != null) {
            throw new AssertionError((Object)("No key expected from loader but got " + keyTypeFromLoader));
        }
        return new GetAdaptor();
    }

    @Override
    public void seal() {
        this.hashMap.seal();
    }

    @Override
    public void put(Writable currentKey, Writable currentValue) throws SerDeException {
        this.directWriteHelper.setKeyValue(currentKey, currentValue);
        this.hashMap.put(this.directWriteHelper, -1);
    }

    public static boolean hasComplexObjects(LazyBinaryStructObjectInspector lazyBinaryStructObjectInspector) {
        List<? extends StructField> fields = lazyBinaryStructObjectInspector.getAllStructFieldRefs();
        for (StructField structField : fields) {
            if (structField.getFieldObjectInspector().getCategory() == ObjectInspector.Category.PRIMITIVE) continue;
            return true;
        }
        return false;
    }

    public static List<Object> getComplexFieldsAsList(LazyBinaryStruct lazyBinaryStruct, ArrayList<Object> objectArrayBuffer, LazyBinaryStructObjectInspector lazyBinaryStructObjectInspector) {
        List<? extends StructField> fields = lazyBinaryStructObjectInspector.getAllStructFieldRefs();
        for (int i = 0; i < fields.size(); ++i) {
            StructField field = fields.get(i);
            ObjectInspector objectInspector = field.getFieldObjectInspector();
            ObjectInspector.Category category = objectInspector.getCategory();
            Object object = lazyBinaryStruct.getField(i);
            if (category == ObjectInspector.Category.PRIMITIVE) {
                objectArrayBuffer.set(i, object);
                continue;
            }
            objectArrayBuffer.set(i, ObjectInspectorUtils.copyToStandardObject(object, objectInspector, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE));
        }
        return objectArrayBuffer;
    }

    public static boolean isSupportedKey(ObjectInspector keyOi) {
        List<? extends StructField> keyFields = ((StructObjectInspector)keyOi).getAllStructFieldRefs();
        for (StructField structField : keyFields) {
            if (MapJoinKey.isSupportedField(structField.getFieldObjectInspector())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void dumpMetrics() {
        this.hashMap.debugDumpMetrics();
    }

    @Override
    public boolean hasSpill() {
        return false;
    }

    @Override
    public int size() {
        return this.hashMap.size();
    }

    @Override
    public long getEstimatedMemorySize() {
        JavaDataModel jdm = JavaDataModel.get();
        long size = 0L;
        size += this.hashMap.getEstimatedMemorySize();
        size += this.directWriteHelper == null ? 0L : this.directWriteHelper.getEstimatedMemorySize();
        size += this.writeHelper == null ? 0L : this.writeHelper.getEstimatedMemorySize();
        size += this.sortableSortOrders == null ? 0L : jdm.lengthForBooleanArrayOfSize(this.sortableSortOrders.length);
        size += this.nullMarkers == null ? 0L : jdm.lengthForByteArrayOfSize(this.nullMarkers.length);
        size += this.notNullMarkers == null ? 0L : jdm.lengthForByteArrayOfSize(this.notNullMarkers.length);
        size += (long)jdm.arrayList();
        return size += 16384L;
    }

    private class ReusableRowContainer
    implements MapJoinRowContainer,
    AbstractRowContainer.RowIterator<List<Object>> {
        private byte aliasFilter;
        private final BytesBytesMultiHashMap.Result hashMapResult;
        private List<Object> dummyRow = null;
        private final ByteArrayRef uselessIndirection;
        private final LazyBinaryStruct valueStruct;
        private final boolean needsComplexObjectFixup;
        private final ArrayList<Object> complexObjectArrayBuffer;

        public ReusableRowContainer() {
            if (MapJoinBytesTableContainer.this.internalValueOi != null) {
                this.valueStruct = (LazyBinaryStruct)LazyBinaryFactory.createLazyBinaryObject(MapJoinBytesTableContainer.this.internalValueOi);
                this.needsComplexObjectFixup = MapJoinBytesTableContainer.hasComplexObjects(MapJoinBytesTableContainer.this.internalValueOi);
                this.complexObjectArrayBuffer = this.needsComplexObjectFixup ? new ArrayList<Object>(Collections.nCopies(MapJoinBytesTableContainer.this.internalValueOi.getAllStructFieldRefs().size(), null)) : null;
            } else {
                this.valueStruct = null;
                this.needsComplexObjectFixup = false;
                this.complexObjectArrayBuffer = null;
            }
            this.uselessIndirection = new ByteArrayRef();
            this.hashMapResult = new BytesBytesMultiHashMap.Result();
            this.clearRows();
        }

        public JoinUtil.JoinResult setFromOutput(ByteStream.Output output) {
            this.aliasFilter = MapJoinBytesTableContainer.this.hashMap.getValueResult(output.getData(), 0, output.getLength(), this.hashMapResult);
            this.dummyRow = null;
            if (this.hashMapResult.hasRows()) {
                return JoinUtil.JoinResult.MATCH;
            }
            this.aliasFilter = (byte)-1;
            return JoinUtil.JoinResult.NOMATCH;
        }

        @Override
        public boolean hasRows() {
            return this.hashMapResult.hasRows() || this.dummyRow != null;
        }

        @Override
        public boolean isSingleRow() {
            if (!this.hashMapResult.hasRows()) {
                return this.dummyRow != null;
            }
            return this.hashMapResult.isSingleRow();
        }

        @Override
        public AbstractRowContainer.RowIterator<List<Object>> rowIter() throws HiveException {
            return this;
        }

        @Override
        public int rowCount() throws HiveException {
            throw new UnsupportedOperationException("Getting the row count not supported");
        }

        @Override
        public void clearRows() {
            this.hashMapResult.forget();
            this.dummyRow = null;
            this.aliasFilter = (byte)-1;
        }

        @Override
        public byte getAliasFilter() throws HiveException {
            return this.aliasFilter;
        }

        @Override
        public MapJoinRowContainer copy() throws HiveException {
            return this;
        }

        @Override
        public List<Object> first() throws HiveException {
            if (this.dummyRow != null) {
                List<Object> result = this.dummyRow;
                this.dummyRow = null;
                return result;
            }
            WriteBuffers.ByteSegmentRef byteSegmentRef = this.hashMapResult.first();
            if (byteSegmentRef == null) {
                return null;
            }
            return this.unpack(byteSegmentRef);
        }

        @Override
        public List<Object> next() throws HiveException {
            WriteBuffers.ByteSegmentRef byteSegmentRef = this.hashMapResult.next();
            if (byteSegmentRef == null) {
                return null;
            }
            return this.unpack(byteSegmentRef);
        }

        private List<Object> unpack(WriteBuffers.ByteSegmentRef ref) throws HiveException {
            if (ref.getLength() == 0) {
                return MapJoinBytesTableContainer.this.EMPTY_LIST;
            }
            this.uselessIndirection.setData(ref.getBytes());
            this.valueStruct.init(this.uselessIndirection, (int)ref.getOffset(), ref.getLength());
            List<Object> result = !this.needsComplexObjectFixup ? this.valueStruct.getFieldsAsList() : MapJoinBytesTableContainer.getComplexFieldsAsList(this.valueStruct, this.complexObjectArrayBuffer, MapJoinBytesTableContainer.this.internalValueOi);
            return result;
        }

        @Override
        public void addRow(List<Object> t) {
            if (this.dummyRow != null || this.hashMapResult.hasRows()) {
                throw new RuntimeException("Cannot add rows when not empty");
            }
            this.dummyRow = t;
        }

        @Override
        public void addRow(Object[] value) {
            throw new RuntimeException(this.getClass().getCanonicalName() + " cannot add arrays");
        }

        @Override
        public void write(MapJoinObjectSerDeContext valueContext, ObjectOutputStream out) {
            throw new RuntimeException(this.getClass().getCanonicalName() + " cannot be serialized");
        }

        public JoinUtil.JoinResult setDirect(byte[] bytes, int offset, int length, BytesBytesMultiHashMap.Result hashMapResult) {
            this.aliasFilter = MapJoinBytesTableContainer.this.hashMap.getValueResult(bytes, offset, length, hashMapResult);
            this.dummyRow = null;
            if (hashMapResult.hasRows()) {
                return JoinUtil.JoinResult.MATCH;
            }
            this.aliasFilter = (byte)-1;
            return JoinUtil.JoinResult.NOMATCH;
        }
    }

    private class GetAdaptor
    implements MapJoinTableContainer.ReusableGetAdaptor,
    ReusableGetAdaptorDirectAccess {
        private Object[] currentKey;
        private boolean[] nulls;
        private List<ObjectInspector> vectorKeyOIs;
        private final ReusableRowContainer currentValue;
        private final ByteStream.Output output;

        public GetAdaptor() {
            this.currentValue = new ReusableRowContainer();
            this.output = new ByteStream.Output();
        }

        @Override
        public JoinUtil.JoinResult setFromVector(VectorHashKeyWrapper kw, VectorExpressionWriter[] keyOutputWriters, VectorHashKeyWrapperBatch keyWrapperBatch) throws HiveException {
            int i;
            if (this.nulls == null) {
                this.nulls = new boolean[keyOutputWriters.length];
                this.currentKey = new Object[keyOutputWriters.length];
                this.vectorKeyOIs = new ArrayList<ObjectInspector>();
                for (i = 0; i < keyOutputWriters.length; ++i) {
                    this.vectorKeyOIs.add(keyOutputWriters[i].getObjectInspector());
                }
            } else assert (this.nulls.length == keyOutputWriters.length);
            for (i = 0; i < keyOutputWriters.length; ++i) {
                this.currentKey[i] = keyWrapperBatch.getWritableKeyValue(kw, i, keyOutputWriters[i]);
                this.nulls[i] = this.currentKey[i] == null;
            }
            return this.currentValue.setFromOutput(MapJoinKey.serializeRow(this.output, this.currentKey, this.vectorKeyOIs, MapJoinBytesTableContainer.this.sortableSortOrders, MapJoinBytesTableContainer.this.nullMarkers, MapJoinBytesTableContainer.this.notNullMarkers));
        }

        @Override
        public JoinUtil.JoinResult setFromRow(Object row, List<ExprNodeEvaluator> fields, List<ObjectInspector> ois) throws HiveException {
            if (this.nulls == null) {
                this.nulls = new boolean[fields.size()];
                this.currentKey = new Object[fields.size()];
            }
            for (int keyIndex = 0; keyIndex < fields.size(); ++keyIndex) {
                this.currentKey[keyIndex] = fields.get(keyIndex).evaluate(row);
                this.nulls[keyIndex] = this.currentKey[keyIndex] == null;
            }
            return this.currentValue.setFromOutput(MapJoinKey.serializeRow(this.output, this.currentKey, ois, MapJoinBytesTableContainer.this.sortableSortOrders, MapJoinBytesTableContainer.this.nullMarkers, MapJoinBytesTableContainer.this.notNullMarkers));
        }

        @Override
        public JoinUtil.JoinResult setFromOther(MapJoinTableContainer.ReusableGetAdaptor other) {
            assert (other instanceof GetAdaptor);
            GetAdaptor other2 = (GetAdaptor)other;
            this.nulls = other2.nulls;
            this.currentKey = other2.currentKey;
            return this.currentValue.setFromOutput(other2.output);
        }

        @Override
        public boolean hasAnyNulls(int fieldCount, boolean[] nullsafes) {
            if (this.nulls == null || this.nulls.length == 0) {
                return false;
            }
            for (int i = 0; i < this.nulls.length; ++i) {
                if (!this.nulls[i] || nullsafes != null && nullsafes[i]) continue;
                return true;
            }
            return false;
        }

        @Override
        public MapJoinRowContainer getCurrentRows() {
            return !this.currentValue.hasRows() ? null : this.currentValue;
        }

        @Override
        public Object[] getCurrentKey() {
            return this.currentKey;
        }

        @Override
        public JoinUtil.JoinResult setDirect(byte[] bytes, int offset, int length, BytesBytesMultiHashMap.Result hashMapResult) {
            return this.currentValue.setDirect(bytes, offset, length, hashMapResult);
        }

        @Override
        public int directSpillPartitionId() {
            throw new UnsupportedOperationException("Getting the spill hash partition not supported");
        }
    }

    protected static class DirectKeyValueWriter
    implements KeyValueHelper {
        private BytesWritable key;
        private BytesWritable val;

        protected DirectKeyValueWriter() {
        }

        @Override
        public void setKeyValue(Writable key, Writable val) throws SerDeException {
            this.key = (BytesWritable)key;
            this.val = (BytesWritable)val;
        }

        @Override
        public void writeKey(ByteStream.RandomAccessOutput dest) throws SerDeException {
            byte[] keyBytes = this.key.getBytes();
            int keyLength = this.key.getLength();
            dest.write(keyBytes, 0, keyLength);
        }

        @Override
        public void writeValue(ByteStream.RandomAccessOutput dest) throws SerDeException {
            byte[] valueBytes = this.val.getBytes();
            int valueLength = this.val.getLength();
            dest.write(valueBytes, 0, valueLength);
        }

        @Override
        public byte updateStateByte(Byte previousValue) {
            throw new UnsupportedOperationException("Updating the state by not supported");
        }

        @Override
        public int getHashFromKey() throws SerDeException {
            byte[] keyBytes = this.key.getBytes();
            int keyLength = this.key.getLength();
            return HashCodeUtil.murmurHash(keyBytes, 0, keyLength);
        }

        @Override
        public long getEstimatedMemorySize() {
            JavaDataModel jdm = JavaDataModel.get();
            long size = 0L;
            size += (long)(jdm.object() + (this.key == null ? 0 : this.key.getCapacity()));
            return size += (long)(jdm.object() + (this.val == null ? 0 : this.val.getCapacity()));
        }
    }

    static class LazyBinaryKvWriter
    implements KeyValueHelper {
        private final LazyBinaryStruct.SingleFieldGetter filterGetter;
        private Writable key;
        private Writable value;
        private final AbstractSerDe keySerDe;
        private Boolean hasTag = null;

        public LazyBinaryKvWriter(AbstractSerDe keySerDe, LazyBinaryStructObjectInspector valSoi, boolean hasFilterTag) throws SerDeException {
            this.keySerDe = keySerDe;
            if (hasFilterTag) {
                int ix;
                List<? extends StructField> fields = valSoi.getAllStructFieldRefs();
                if (!(fields.get(ix = fields.size() - 1).getFieldObjectInspector() instanceof ShortObjectInspector)) {
                    throw new SerDeException("Has filter tag, but corresponding OI is " + fields.get(ix).getFieldObjectInspector());
                }
                this.filterGetter = new LazyBinaryStruct.SingleFieldGetter(valSoi, fields.size() - 1);
            } else {
                this.filterGetter = null;
            }
        }

        @Override
        public void writeKey(ByteStream.RandomAccessOutput dest) throws SerDeException {
            if (!(this.key instanceof BinaryComparable)) {
                throw new SerDeException("Unexpected type " + this.key.getClass().getCanonicalName());
            }
            this.sanityCheckKeyForTag();
            BinaryComparable b = (BinaryComparable)this.key;
            dest.write(b.getBytes(), 0, b.getLength() - (this.hasTag != false ? 1 : 0));
        }

        @Override
        public int getHashFromKey() throws SerDeException {
            if (!(this.key instanceof BinaryComparable)) {
                throw new SerDeException("Unexpected type " + this.key.getClass().getCanonicalName());
            }
            this.sanityCheckKeyForTag();
            BinaryComparable b = (BinaryComparable)this.key;
            return HashCodeUtil.murmurHash(b.getBytes(), 0, b.getLength() - (this.hasTag != false ? 1 : 0));
        }

        private void sanityCheckKeyForTag() throws SerDeException {
            if (this.hasTag != null) {
                return;
            }
            BinaryComparable b = (BinaryComparable)this.key;
            Object o = this.keySerDe.deserialize(this.key);
            StructObjectInspector soi = (StructObjectInspector)this.keySerDe.getObjectInspector();
            List<? extends StructField> fields = soi.getAllStructFieldRefs();
            Object[] data = new Object[fields.size()];
            ArrayList<ObjectInspector> fois = new ArrayList<ObjectInspector>(fields.size());
            for (int i = 0; i < fields.size(); ++i) {
                data[i] = soi.getStructFieldData(o, fields.get(i));
                fois.add(fields.get(i).getFieldObjectInspector());
            }
            ByteStream.Output output = new ByteStream.Output();
            boolean[] sortableSortOrders = new boolean[fields.size()];
            Arrays.fill(sortableSortOrders, false);
            byte[] columnNullMarker = new byte[fields.size()];
            Arrays.fill(columnNullMarker, (byte)0);
            byte[] columnNotNullMarker = new byte[fields.size()];
            Arrays.fill(columnNotNullMarker, (byte)1);
            BinarySortableSerDe.serializeStruct(output, data, fois, sortableSortOrders, columnNullMarker, columnNotNullMarker);
            this.hasTag = output.getLength() != b.getLength();
            if (this.hasTag.booleanValue()) {
                LOG.error("Tag found in keys and will be removed. This should not happen.");
                if (output.getLength() != b.getLength() - 1) {
                    throw new SerDeException("Unexpected tag: " + b.getLength() + " reserialized to " + output.getLength());
                }
            }
        }

        @Override
        public void writeValue(ByteStream.RandomAccessOutput dest) throws SerDeException {
            if (!(this.value instanceof BinaryComparable)) {
                throw new SerDeException("Unexpected type " + this.value.getClass().getCanonicalName());
            }
            BinaryComparable b = (BinaryComparable)this.value;
            dest.write(b.getBytes(), 0, b.getLength());
        }

        @Override
        public void setKeyValue(Writable key, Writable val) {
            this.key = key;
            this.value = val;
        }

        @Override
        public byte updateStateByte(Byte previousValue) {
            if (this.filterGetter == null) {
                return -1;
            }
            byte aliasFilter = previousValue == null ? (byte)-1 : (byte)previousValue;
            this.filterGetter.init((BinaryComparable)this.value);
            aliasFilter = (byte)(aliasFilter & this.filterGetter.getShort());
            return aliasFilter;
        }

        @Override
        public long getEstimatedMemorySize() {
            JavaDataModel jdm = JavaDataModel.get();
            long size = 0L;
            size += (long)(4 * jdm.object());
            return size += (long)jdm.primitive1();
        }
    }

    private static class KeyValueWriter
    implements KeyValueHelper {
        private final AbstractSerDe keySerDe;
        private final AbstractSerDe valSerDe;
        private final StructObjectInspector keySoi;
        private final StructObjectInspector valSoi;
        private final List<ObjectInspector> keyOis;
        private final List<ObjectInspector> valOis;
        private final Object[] keyObjs;
        private final Object[] valObjs;
        private final boolean hasFilterTag;

        public KeyValueWriter(AbstractSerDe keySerDe, AbstractSerDe valSerDe, boolean hasFilterTag) throws SerDeException {
            int i;
            this.keySerDe = keySerDe;
            this.valSerDe = valSerDe;
            this.keySoi = (StructObjectInspector)keySerDe.getObjectInspector();
            this.valSoi = (StructObjectInspector)valSerDe.getObjectInspector();
            List<? extends StructField> keyFields = this.keySoi.getAllStructFieldRefs();
            List<? extends StructField> valFields = this.valSoi.getAllStructFieldRefs();
            this.keyOis = new ArrayList<ObjectInspector>(keyFields.size());
            this.valOis = new ArrayList<ObjectInspector>(valFields.size());
            for (i = 0; i < keyFields.size(); ++i) {
                this.keyOis.add(keyFields.get(i).getFieldObjectInspector());
            }
            for (i = 0; i < valFields.size(); ++i) {
                this.valOis.add(valFields.get(i).getFieldObjectInspector());
            }
            this.keyObjs = new Object[this.keyOis.size()];
            this.valObjs = new Object[this.valOis.size()];
            this.hasFilterTag = hasFilterTag;
        }

        @Override
        public void writeKey(ByteStream.RandomAccessOutput dest) throws SerDeException {
            LazyBinarySerDe.serializeStruct(dest, this.keyObjs, this.keyOis);
        }

        @Override
        public void writeValue(ByteStream.RandomAccessOutput dest) throws SerDeException {
            LazyBinarySerDe.serializeStruct(dest, this.valObjs, this.valOis);
        }

        @Override
        public void setKeyValue(Writable key, Writable val) throws SerDeException {
            int i;
            Object keyObj = this.keySerDe.deserialize(key);
            Object valObj = this.valSerDe.deserialize(val);
            List<? extends StructField> keyFields = this.keySoi.getAllStructFieldRefs();
            List<? extends StructField> valFields = this.valSoi.getAllStructFieldRefs();
            for (i = 0; i < keyFields.size(); ++i) {
                this.keyObjs[i] = this.keySoi.getStructFieldData(keyObj, keyFields.get(i));
            }
            for (i = 0; i < valFields.size(); ++i) {
                this.valObjs[i] = this.valSoi.getStructFieldData(valObj, valFields.get(i));
            }
        }

        @Override
        public byte updateStateByte(Byte previousValue) {
            if (!this.hasFilterTag) {
                return -1;
            }
            byte aliasFilter = previousValue == null ? (byte)-1 : (byte)previousValue;
            aliasFilter = (byte)(aliasFilter & ((ShortWritable)this.valObjs[this.valObjs.length - 1]).get());
            return aliasFilter;
        }

        @Override
        public int getHashFromKey() throws SerDeException {
            throw new UnsupportedOperationException("Not supported for MapJoinBytesTableContainer");
        }

        @Override
        public long getEstimatedMemorySize() {
            JavaDataModel jdm = JavaDataModel.get();
            long size = 0L;
            size += this.keySerDe == null ? 0L : (long)jdm.object();
            size += this.valSerDe == null ? 0L : (long)jdm.object();
            size += this.keySoi == null ? 0L : 16384L;
            size += this.valSoi == null ? 0L : 16384L;
            size += this.keyOis == null ? 0L : (long)jdm.arrayList() + (long)this.keyOis.size() * 16384L;
            size += this.valOis == null ? 0L : (long)jdm.arrayList() + (long)this.valOis.size() * 16384L;
            size += this.keyObjs == null ? 0L : (long)(jdm.array() + this.keyObjs.length * jdm.object());
            size += this.valObjs == null ? 0L : (long)(jdm.array() + this.valObjs.length * jdm.object());
            return size += (long)jdm.primitive1();
        }
    }

    public static interface KeyValueHelper
    extends BytesBytesMultiHashMap.KvSource,
    MemoryEstimate {
        public void setKeyValue(Writable var1, Writable var2) throws SerDeException;

        public int getHashFromKey() throws SerDeException;
    }
}

