/*
 * Decompiled with CFR 0.152.
 */
package jodd.io.findfile;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jodd.io.FileNameUtil;
import jodd.io.FileUtil;
import jodd.io.findfile.FindFileException;
import jodd.util.MultiComparator;
import jodd.util.NaturalOrderComparator;
import jodd.util.StringUtil;
import jodd.util.collection.JoddArrayList;
import jodd.util.sort.FastSort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindFile<T extends FindFile> {
    protected boolean recursive;
    protected boolean includeDirs = true;
    protected boolean includeFiles = true;
    protected boolean walking = true;
    protected Match matchType = Match.FULL_PATH;
    protected ArrayList<String> includes;
    protected ArrayList<String> excludes;
    protected JoddArrayList<File> pathList;
    protected JoddArrayList<File> pathListOriginal;
    protected JoddArrayList<File> todoFolders;
    protected JoddArrayList<FilesIterator> todoFiles;
    protected File lastFile;
    protected File rootFile;
    protected String rootPath;
    protected List<Comparator<File>> sortComparators;

    public boolean isRecursive() {
        return this.recursive;
    }

    public T setRecursive(boolean recursive) {
        this.recursive = recursive;
        return (T)this;
    }

    public boolean isIncludeDirs() {
        return this.includeDirs;
    }

    public T setIncludeDirs(boolean includeDirs) {
        this.includeDirs = includeDirs;
        return (T)this;
    }

    public boolean isIncludeFiles() {
        return this.includeFiles;
    }

    public T setIncludeFiles(boolean includeFiles) {
        this.includeFiles = includeFiles;
        return (T)this;
    }

    public boolean isWalking() {
        return this.walking;
    }

    public T setWalking(boolean walking) {
        this.walking = walking;
        return (T)this;
    }

    public Match getMatchType() {
        return this.matchType;
    }

    public T setMatchType(Match match) {
        this.matchType = match;
        return (T)this;
    }

    public T searchPath(File searchPath) {
        this.addPath(searchPath);
        return (T)this;
    }

    public T searchPath(File ... searchPath) {
        for (File file : searchPath) {
            this.addPath(file);
        }
        return (T)this;
    }

    public T searchPath(String searchPath) {
        if (searchPath.indexOf(File.pathSeparatorChar) != -1) {
            String[] paths;
            for (String path : paths = StringUtil.split(searchPath, File.pathSeparator)) {
                this.addPath(new File(path));
            }
        } else {
            this.addPath(new File(searchPath));
        }
        return (T)this;
    }

    public T searchPath(String ... searchPaths) {
        for (String searchPath : searchPaths) {
            this.searchPath(searchPath);
        }
        return (T)this;
    }

    public T searchPath(URI searchPath) {
        File file;
        try {
            file = new File(searchPath);
        }
        catch (Exception ex) {
            throw new FindFileException("URI error: " + searchPath, ex);
        }
        this.addPath(file);
        return (T)this;
    }

    public T searchPath(URI ... searchPath) {
        for (URI uri : searchPath) {
            this.searchPath(uri);
        }
        return (T)this;
    }

    public T searchPath(URL searchPath) {
        File file = FileUtil.toFile(searchPath);
        if (file == null) {
            throw new FindFileException("URL error: " + searchPath);
        }
        this.addPath(file);
        return (T)this;
    }

    public T searchPath(URL ... searchPath) {
        for (URL url : searchPath) {
            this.searchPath(url);
        }
        return (T)this;
    }

    public T include(String pattern) {
        if (this.includes == null) {
            this.includes = new ArrayList();
        }
        this.includes.add(pattern);
        return (T)this;
    }

    public T include(String ... patterns) {
        if (this.includes == null) {
            this.includes = new ArrayList();
        }
        Collections.addAll(this.includes, patterns);
        return (T)this;
    }

    public T exclude(String pattern) {
        if (this.excludes == null) {
            this.excludes = new ArrayList();
        }
        this.excludes.add(pattern);
        return (T)this;
    }

    public T exclude(String ... patterns) {
        if (this.excludes == null) {
            this.excludes = new ArrayList();
        }
        Collections.addAll(this.excludes, patterns);
        return (T)this;
    }

    protected boolean acceptFile(File file) {
        String matchingFilePath = this.getMatchingFilePath(file);
        if (this.excludes != null) {
            for (String pattern : this.excludes) {
                if (!this.match(matchingFilePath, pattern)) continue;
                return false;
            }
        }
        if (this.includes != null) {
            for (String pattern : this.includes) {
                if (!this.match(matchingFilePath, pattern)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean match(String path, String pattern) {
        return path.equals(pattern);
    }

    protected String getMatchingFilePath(File file) {
        String path = null;
        switch (this.matchType) {
            case FULL_PATH: {
                path = file.getAbsolutePath();
                break;
            }
            case RELATIVE_PATH: {
                path = file.getAbsolutePath();
                path = path.substring(this.rootPath.length());
                break;
            }
            case NAME: {
                path = file.getName();
            }
        }
        path = FileNameUtil.separatorsToUnix(path);
        return path;
    }

    public File lastFile() {
        return this.lastFile;
    }

    protected void addPath(File path) {
        if (!path.exists()) {
            return;
        }
        if (this.pathList == null) {
            this.pathList = new JoddArrayList();
        }
        this.pathList.add(path);
    }

    public void reset() {
        this.pathList = this.pathListOriginal;
        this.pathListOriginal = null;
        this.todoFiles = null;
        this.lastFile = null;
        this.includes = null;
        this.excludes = null;
    }

    public File nextFile() {
        File folder;
        if (this.todoFiles == null) {
            this.init();
        }
        while (true) {
            if (!this.todoFiles.isEmpty()) {
                FilesIterator filesIterator = this.todoFiles.getLast();
                File nextFile = filesIterator.next();
                if (nextFile == null) {
                    this.todoFiles.removeLast();
                    continue;
                }
                if (nextFile.isDirectory()) {
                    if (!this.walking) {
                        this.todoFolders.add(nextFile);
                        continue;
                    }
                    if (this.recursive) {
                        this.todoFiles.add(new FilesIterator(nextFile));
                    }
                    if (!this.includeDirs || !this.acceptFile(nextFile)) continue;
                    this.lastFile = nextFile;
                    return nextFile;
                }
                this.lastFile = nextFile;
                return nextFile;
            }
            boolean initialDir = false;
            if (this.todoFolders.isEmpty()) {
                if (this.pathList.isEmpty()) {
                    return null;
                }
                this.rootFile = folder = this.pathList.removeFirst();
                this.rootPath = this.rootFile.getAbsolutePath();
                initialDir = true;
            } else {
                folder = this.todoFolders.removeFirst();
            }
            if (initialDir || this.recursive) {
                this.todoFiles.add(new FilesIterator(folder));
            }
            if (!initialDir && this.includeDirs && this.acceptFile(folder)) break;
        }
        this.lastFile = folder;
        return folder;
    }

    public void scan() {
        while (this.nextFile() != null) {
        }
    }

    protected void init() {
        this.todoFiles = new JoddArrayList();
        this.todoFolders = new JoddArrayList();
        if (this.pathList == null) {
            this.pathList = new JoddArrayList();
            return;
        }
        if (this.pathListOriginal == null) {
            this.pathListOriginal = (JoddArrayList)this.pathList.clone();
        }
        String[] files = new String[this.pathList.size()];
        int index = 0;
        Iterator<File> iterator = this.pathList.iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (!file.isFile()) continue;
            files[index++] = file.getAbsolutePath();
            iterator.remove();
        }
        if (index != 0) {
            FilesIterator filesIterator = new FilesIterator(files);
            this.todoFiles.add(filesIterator);
        }
    }

    public Iterator<File> iterator() {
        return new Iterator<File>(){
            private File nextFile;

            @Override
            public boolean hasNext() {
                this.nextFile = FindFile.this.nextFile();
                return this.nextFile != null;
            }

            @Override
            public File next() {
                if (this.nextFile == null) {
                    throw new NoSuchElementException();
                }
                return this.nextFile;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected void addComparator(Comparator<File> comparator) {
        if (this.sortComparators == null) {
            this.sortComparators = new ArrayList<Comparator<File>>(4);
        }
        this.sortComparators.add(comparator);
    }

    public T sortNone() {
        this.sortComparators = null;
        return (T)this;
    }

    public T sortWith(Comparator<File> fileComparator) {
        this.addComparator(fileComparator);
        return (T)this;
    }

    public T sortFoldersFirst() {
        this.addComparator(new FolderFirstComparator(true));
        return (T)this;
    }

    public T sortFoldersLast() {
        this.addComparator(new FolderFirstComparator(false));
        return (T)this;
    }

    public T sortByName() {
        this.addComparator(new FileNameComparator(true));
        return (T)this;
    }

    public T sortByNameDesc() {
        this.addComparator(new FileNameComparator(false));
        return (T)this;
    }

    public T sortByExtension() {
        this.addComparator(new FileExtensionComparator(true));
        return (T)this;
    }

    public T sortByExtensionDesc() {
        this.addComparator(new FileExtensionComparator(false));
        return (T)this;
    }

    public T sortByTime() {
        this.addComparator(new FileLastModifiedTimeComparator(true));
        return (T)this;
    }

    public T sortByTimeDesc() {
        this.addComparator(new FileLastModifiedTimeComparator(false));
        return (T)this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileLastModifiedTimeComparator
    implements Comparator<File> {
        protected final int order;

        public FileLastModifiedTimeComparator(boolean ascending) {
            this.order = ascending ? 1 : -1;
        }

        @Override
        public int compare(File file1, File file2) {
            long diff = file1.lastModified() - file2.lastModified();
            if (diff == 0L) {
                return 0;
            }
            if (diff > 0L) {
                return this.order;
            }
            return -this.order;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileExtensionComparator
    implements Comparator<File> {
        protected final int order;

        public FileExtensionComparator(boolean ascending) {
            this.order = ascending ? 1 : -1;
        }

        @Override
        public int compare(File file1, File file2) {
            String ext2;
            String ext1 = FileNameUtil.getExtension(file1.getName());
            long diff = ext1.compareToIgnoreCase(ext2 = FileNameUtil.getExtension(file2.getName()));
            if (diff == 0L) {
                return 0;
            }
            if (diff > 0L) {
                return this.order;
            }
            return -this.order;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileNameComparator
    implements Comparator<File> {
        protected final int order;
        protected NaturalOrderComparator<String> naturalOrderComparator = new NaturalOrderComparator(true);

        public FileNameComparator(boolean ascending) {
            this.order = ascending ? 1 : -1;
        }

        @Override
        public int compare(File file1, File file2) {
            int result = this.naturalOrderComparator.compare(file1.getName(), file2.getName());
            if (result == 0) {
                return result;
            }
            if (result > 0) {
                return this.order;
            }
            return -this.order;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FolderFirstComparator
    implements Comparator<File> {
        protected final int order;

        public FolderFirstComparator(boolean foldersFirst) {
            this.order = foldersFirst ? 1 : -1;
        }

        @Override
        public int compare(File file1, File file2) {
            if (file1.isFile() && file2.isDirectory()) {
                return this.order;
            }
            if (file1.isDirectory() && file2.isFile()) {
                return -this.order;
            }
            return 0;
        }
    }

    protected class FilesIterator {
        protected final File folder;
        protected final String[] fileNames;
        protected final File[] files;
        protected int index;

        public FilesIterator(File folder) {
            this.folder = folder;
            if (FindFile.this.sortComparators != null) {
                this.files = folder.listFiles();
                if (this.files != null) {
                    FastSort.sort(this.files, new MultiComparator(FindFile.this.sortComparators));
                }
                this.fileNames = null;
            } else {
                this.files = null;
                this.fileNames = folder.list();
            }
        }

        public FilesIterator(String[] fileNames) {
            this.folder = null;
            if (FindFile.this.sortComparators != null) {
                int fileNamesLength = fileNames.length;
                this.files = new File[fileNamesLength];
                for (int i = 0; i < fileNamesLength; ++i) {
                    String fileName = fileNames[i];
                    if (fileName == null) continue;
                    this.files[i] = new File(fileName);
                }
                this.fileNames = null;
            } else {
                this.files = null;
                this.fileNames = fileNames;
            }
        }

        public File next() {
            if (this.files != null) {
                return this.nextFile();
            }
            if (this.fileNames != null) {
                return this.nextFileName();
            }
            return null;
        }

        protected File nextFileName() {
            while (this.index < this.fileNames.length) {
                String fileName = this.fileNames[this.index];
                if (fileName == null) {
                    ++this.index;
                    continue;
                }
                this.fileNames[this.index] = null;
                ++this.index;
                File file = this.folder == null ? new File(fileName) : new File(this.folder, fileName);
                if (file.isFile() && (!FindFile.this.includeFiles || !FindFile.this.acceptFile(file))) continue;
                return file;
            }
            return null;
        }

        protected File nextFile() {
            while (this.index < this.files.length) {
                File file = this.files[this.index];
                if (file == null) {
                    ++this.index;
                    continue;
                }
                this.files[this.index] = null;
                ++this.index;
                if (file.isFile() && (!FindFile.this.includeFiles || !FindFile.this.acceptFile(file))) continue;
                return file;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Match {
        FULL_PATH,
        RELATIVE_PATH,
        NAME;

    }
}

