/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.aliasmap;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ProvidedStorageLocation;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.server.aliasmap.InMemoryAliasMapProtocol;
import org.apache.hadoop.hdfs.server.common.FileRegion;
import org.apache.hadoop.hdfs.server.namenode.ImageServlet;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.thirdparty.protobuf.InvalidProtocolBufferException;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.Snapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class InMemoryAliasMap
implements InMemoryAliasMapProtocol,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryAliasMap.class);
    private static final String SNAPSHOT_COPY_DIR = "aliasmap_snapshot";
    private static final String TAR_NAME = "aliasmap.tar.gz";
    private final URI aliasMapURI;
    private final DB levelDb;
    private Configuration conf;
    private String blockPoolID;

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Nonnull
    public static InMemoryAliasMap init(Configuration conf, String blockPoolID) throws IOException {
        Options options = new Options();
        options.createIfMissing(true);
        String directory = conf.get("dfs.provided.aliasmap.inmemory.leveldb.dir");
        if (directory == null) {
            throw new IOException("InMemoryAliasMap location is null");
        }
        File levelDBpath = blockPoolID != null ? new File(directory, blockPoolID) : new File(directory);
        if (!levelDBpath.exists()) {
            LOG.warn("InMemoryAliasMap location {} is missing. Creating it.", (Object)levelDBpath);
            if (!levelDBpath.mkdirs()) {
                throw new IOException("Unable to create missing aliasmap location: " + levelDBpath);
            }
        }
        DB levelDb = JniDBFactory.factory.open(levelDBpath, options);
        InMemoryAliasMap aliasMap = new InMemoryAliasMap(levelDBpath.toURI(), levelDb, blockPoolID);
        aliasMap.setConf(conf);
        return aliasMap;
    }

    @VisibleForTesting
    InMemoryAliasMap(URI aliasMapURI, DB levelDb, String blockPoolID) {
        this.aliasMapURI = aliasMapURI;
        this.levelDb = levelDb;
        this.blockPoolID = blockPoolID;
    }

    @Override
    public InMemoryAliasMapProtocol.IterationResult list(Optional<Block> marker) throws IOException {
        try (DBIterator iterator = this.levelDb.iterator();){
            Integer batchSize = this.conf.getInt("dfs.provided.aliasmap.inmemory.batch-size", 500);
            if (marker.isPresent()) {
                iterator.seek(InMemoryAliasMap.toProtoBufBytes(marker.get()));
            } else {
                iterator.seekToFirst();
            }
            ArrayList batch = Lists.newArrayListWithExpectedSize((int)batchSize);
            for (int i = 0; iterator.hasNext() && i < batchSize; ++i) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Block block = InMemoryAliasMap.fromBlockBytes((byte[])entry.getKey());
                ProvidedStorageLocation providedStorageLocation = InMemoryAliasMap.fromProvidedStorageLocationBytes((byte[])entry.getValue());
                batch.add(new FileRegion(block, providedStorageLocation));
            }
            if (iterator.hasNext()) {
                Block nextMarker = InMemoryAliasMap.fromBlockBytes((byte[])((Map.Entry)iterator.next()).getKey());
                InMemoryAliasMapProtocol.IterationResult iterationResult = new InMemoryAliasMapProtocol.IterationResult(batch, Optional.of(nextMarker));
                return iterationResult;
            }
            InMemoryAliasMapProtocol.IterationResult iterationResult = new InMemoryAliasMapProtocol.IterationResult(batch, Optional.empty());
            return iterationResult;
        }
    }

    @Override
    @Nonnull
    public Optional<ProvidedStorageLocation> read(@Nonnull Block block) throws IOException {
        byte[] extendedBlockDbFormat = InMemoryAliasMap.toProtoBufBytes(block);
        byte[] providedStorageLocationDbFormat = this.levelDb.get(extendedBlockDbFormat);
        if (providedStorageLocationDbFormat == null) {
            return Optional.empty();
        }
        ProvidedStorageLocation providedStorageLocation = InMemoryAliasMap.fromProvidedStorageLocationBytes(providedStorageLocationDbFormat);
        return Optional.of(providedStorageLocation);
    }

    @Override
    public void write(@Nonnull Block block, @Nonnull ProvidedStorageLocation providedStorageLocation) throws IOException {
        byte[] extendedBlockDbFormat = InMemoryAliasMap.toProtoBufBytes(block);
        byte[] providedStorageLocationDbFormat = InMemoryAliasMap.toProtoBufBytes(providedStorageLocation);
        this.levelDb.put(extendedBlockDbFormat, providedStorageLocationDbFormat);
    }

    @Override
    public String getBlockPoolId() {
        return this.blockPoolID;
    }

    public void close() throws IOException {
        this.levelDb.close();
    }

    @Nonnull
    public static ProvidedStorageLocation fromProvidedStorageLocationBytes(@Nonnull byte[] providedStorageLocationDbFormat) throws InvalidProtocolBufferException {
        HdfsProtos.ProvidedStorageLocationProto providedStorageLocationProto = HdfsProtos.ProvidedStorageLocationProto.parseFrom((byte[])providedStorageLocationDbFormat);
        return PBHelperClient.convert((HdfsProtos.ProvidedStorageLocationProto)providedStorageLocationProto);
    }

    @Nonnull
    public static Block fromBlockBytes(@Nonnull byte[] blockDbFormat) throws InvalidProtocolBufferException {
        HdfsProtos.BlockProto blockProto = HdfsProtos.BlockProto.parseFrom((byte[])blockDbFormat);
        return PBHelperClient.convert((HdfsProtos.BlockProto)blockProto);
    }

    public static byte[] toProtoBufBytes(@Nonnull ProvidedStorageLocation providedStorageLocation) throws IOException {
        HdfsProtos.ProvidedStorageLocationProto providedStorageLocationProto = PBHelperClient.convert((ProvidedStorageLocation)providedStorageLocation);
        ByteArrayOutputStream providedStorageLocationOutputStream = new ByteArrayOutputStream();
        providedStorageLocationProto.writeTo((OutputStream)providedStorageLocationOutputStream);
        return providedStorageLocationOutputStream.toByteArray();
    }

    public static byte[] toProtoBufBytes(@Nonnull Block block) throws IOException {
        HdfsProtos.BlockProto blockProto = PBHelperClient.convert((Block)block);
        ByteArrayOutputStream blockOutputStream = new ByteArrayOutputStream();
        blockProto.writeTo((OutputStream)blockOutputStream);
        return blockOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transferForBootstrap(HttpServletResponse response, Configuration conf, InMemoryAliasMap aliasMap) throws IOException {
        File aliasMapSnapshot = null;
        File compressedAliasMap = null;
        try {
            aliasMapSnapshot = InMemoryAliasMap.createSnapshot(aliasMap);
            compressedAliasMap = InMemoryAliasMap.getCompressedAliasMap(new File(aliasMapSnapshot, aliasMap.blockPoolID));
            try (FileInputStream fis = new FileInputStream(compressedAliasMap);){
                ImageServlet.setVerificationHeadersForGet(response, compressedAliasMap);
                ImageServlet.setFileNameHeaders(response, compressedAliasMap);
                DataTransferThrottler throttler = ImageServlet.getThrottlerForBootstrapStandby(conf);
                TransferFsImage.copyFileToStream((OutputStream)response.getOutputStream(), compressedAliasMap, fis, throttler);
            }
        }
        finally {
            StringBuilder errMessage = new StringBuilder();
            if (compressedAliasMap != null && !FileUtil.fullyDelete((File)compressedAliasMap)) {
                errMessage.append("Failed to fully delete compressed aliasmap ").append(compressedAliasMap.getAbsolutePath()).append("\n");
            }
            if (aliasMapSnapshot != null && !FileUtil.fullyDelete((File)aliasMapSnapshot)) {
                errMessage.append("Failed to fully delete the aliasmap snapshot ").append(aliasMapSnapshot.getAbsolutePath()).append("\n");
            }
            if (errMessage.length() > 0) {
                throw new IOException(errMessage.toString());
            }
        }
    }

    static File createSnapshot(InMemoryAliasMap aliasMap) throws IOException {
        File originalAliasMapDir = new File(aliasMap.aliasMapURI);
        String bpid = originalAliasMapDir.getName();
        File snapshotDir = new File(originalAliasMapDir.getParent(), SNAPSHOT_COPY_DIR);
        File newLevelDBDir = new File(snapshotDir, bpid);
        if (!newLevelDBDir.mkdirs()) {
            throw new IOException("Unable to create aliasmap snapshot directory " + newLevelDBDir);
        }
        DB originalDB = aliasMap.levelDb;
        try (Snapshot snapshot = originalDB.getSnapshot();){
            Options options = new Options();
            options.createIfMissing(true);
            try (DB snapshotDB = JniDBFactory.factory.open(newLevelDBDir, options);
                 DBIterator iterator = originalDB.iterator(new ReadOptions().snapshot(snapshot));){
                iterator.seekToFirst();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    snapshotDB.put((byte[])entry.getKey(), (byte[])entry.getValue());
                }
            }
        }
        return snapshotDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File getCompressedAliasMap(File aliasMapDir) throws IOException {
        TarArchiveOutputStream tOut;
        GzipCompressorOutputStream gzOut;
        BufferedOutputStream bOut;
        File outCompressedFile;
        block3: {
            outCompressedFile = new File(aliasMapDir.getParent(), TAR_NAME);
            bOut = null;
            gzOut = null;
            tOut = null;
            try {
                bOut = new BufferedOutputStream(Files.newOutputStream(outCompressedFile.toPath(), new OpenOption[0]));
                gzOut = new GzipCompressorOutputStream((OutputStream)bOut);
                tOut = new TarArchiveOutputStream((OutputStream)gzOut);
                InMemoryAliasMap.addFileToTarGzRecursively(tOut, aliasMapDir, "", new Configuration());
                if (tOut == null) break block3;
            }
            catch (Throwable throwable) {
                if (tOut != null) {
                    tOut.finish();
                }
                IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{tOut, gzOut, bOut});
                throw throwable;
            }
            tOut.finish();
        }
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{tOut, gzOut, bOut});
        return outCompressedFile;
    }

    private static void addFileToTarGzRecursively(TarArchiveOutputStream tOut, File file, String prefix, Configuration conf) throws IOException {
        String entryName = prefix + file.getName();
        TarArchiveEntry tarEntry = new TarArchiveEntry(file, entryName);
        tOut.putArchiveEntry((ArchiveEntry)tarEntry);
        LOG.debug("Adding entry {} to alias map archive", (Object)entryName);
        if (file.isFile()) {
            try (FileInputStream in = new FileInputStream(file);){
                IOUtils.copyBytes((InputStream)in, (OutputStream)tOut, (Configuration)conf, (boolean)false);
            }
            tOut.closeArchiveEntry();
        } else {
            tOut.closeArchiveEntry();
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    if (child.getName().equals("LOCK")) continue;
                    InMemoryAliasMap.addFileToTarGzRecursively(tOut, child, entryName + "/", conf);
                }
            }
        }
    }

    public static void completeBootstrapTransfer(File aliasMap) throws IOException {
        File tarname = new File(aliasMap, TAR_NAME);
        if (!tarname.exists()) {
            throw new IOException("Aliasmap archive (" + tarname + ") does not exist");
        }
        try {
            FileUtil.unTar((File)tarname, (File)aliasMap);
        }
        finally {
            if (!FileUtil.fullyDelete((File)tarname)) {
                LOG.warn("Failed to fully delete aliasmap archive: " + tarname);
            }
        }
    }

    @FunctionalInterface
    public static interface CheckedFunction2<T1, T2, R> {
        public R apply(T1 var1, T2 var2) throws IOException;
    }
}

