/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.web.reactive.client;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.actuate.metrics.web.reactive.client.WebClientExchangeTagsProvider;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public class MetricsWebClientFilterFunction
implements ExchangeFilterFunction {
    private static final String METRICS_WEBCLIENT_START_TIME = MetricsWebClientFilterFunction.class.getName() + ".START_TIME";
    private final MeterRegistry meterRegistry;
    private final WebClientExchangeTagsProvider tagProvider;
    private final String metricName;

    public MetricsWebClientFilterFunction(MeterRegistry meterRegistry, WebClientExchangeTagsProvider tagProvider, String metricName) {
        this.meterRegistry = meterRegistry;
        this.tagProvider = tagProvider;
        this.metricName = metricName;
    }

    public Mono<ClientResponse> filter(ClientRequest clientRequest, ExchangeFunction exchangeFunction) {
        return exchangeFunction.exchange(clientRequest).doOnEach(signal -> {
            if (!signal.isOnComplete()) {
                Long startTime = (Long)signal.getContext().get((Object)METRICS_WEBCLIENT_START_TIME);
                ClientResponse clientResponse = (ClientResponse)signal.get();
                Throwable throwable = signal.getThrowable();
                Iterable<Tag> tags = this.tagProvider.tags(clientRequest, clientResponse, throwable);
                Timer.builder((String)this.metricName).tags(tags).description("Timer of WebClient operation").register(this.meterRegistry).record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
            }
        }).subscriberContext(context -> context.put((Object)METRICS_WEBCLIENT_START_TIME, (Object)System.nanoTime()));
    }
}

