/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.kvstore;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.store.Shard;
import org.apache.hugegraph.kvstore.KvStore;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.variables.HugeVariables;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class KvStoreImpl
implements KvStore {
    private final HugeGraph g;
    private HugeVariables variables;

    public KvStoreImpl(HugeGraph graph) {
        assert (graph != null) : "graph can't be null";
        this.g = graph;
        this.variables = (HugeVariables)graph.variables();
    }

    public void set(String key, String value) {
        try {
            this.variables.set(key, (Object)value);
            this.g.tx().commit();
        }
        catch (Throwable e) {
            this.g.tx().rollback();
            throw new HugeException("Failed to commit set kv", e);
        }
    }

    public String get(String key) {
        Optional value = this.variables.get(key);
        if (value.isEmpty()) {
            return null;
        }
        return (String)value.get();
    }

    public List<String> mget(String ... keys) {
        List values = this.variables.mget(keys);
        ArrayList<String> list = new ArrayList<String>();
        for (Optional value : values) {
            if (value.isEmpty()) {
                list.add(null);
                continue;
            }
            list.add((String)value.get());
        }
        return list;
    }

    public void remove(String key) {
        try {
            this.variables.remove(key);
            this.g.tx().commit();
        }
        catch (Throwable e) {
            this.g.tx().rollback();
            throw new HugeException("Failed to commit remove kv", e);
        }
    }

    public Boolean contains(String key) {
        Optional value = this.variables.get(key);
        return value.isPresent();
    }

    public Number count() {
        return this.variables.count();
    }

    public void clearAll() {
        this.g.truncateBackend();
        this.variables = (HugeVariables)this.g.variables();
    }

    public List<Shard> shards(long splitSize) {
        List shards = (List)this.g.metadata(HugeType.TASK, "splits", new Object[]{splitSize});
        return shards;
    }

    public Iterator<Vertex> queryVariablesByShard(String start, String end, String page, long pageLimit) {
        return this.variables.queryVariablesByShard(start, end, page, pageLimit);
    }

    public Map<String, Object> batchSet(Map<String, Object> params) {
        try {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                this.variables.set(entry.getKey(), entry.getValue());
            }
            this.g.tx().commit();
        }
        catch (Throwable e) {
            this.g.tx().rollback();
            throw new HugeException("Failed to commit batch set kv", e);
        }
        return params;
    }
}

