/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.space;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.SecurityContext;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.filter.StatusFilter;
import org.apache.hugegraph.auth.HugeGraphAuthProxy;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.define.Checkable;
import org.apache.hugegraph.exception.NotFoundException;
import org.apache.hugegraph.space.GraphSpace;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.hugegraph.util.Log;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;

@Path(value="graphspaces")
@Singleton
@Tag(name="GraphSpaceAPI")
public class GraphSpaceAPI
extends API {
    private static final Logger LOG = Log.logger(GraphSpaceAPI.class);
    private static final String GRAPH_SPACE_ACTION = "action";
    private static final String UPDATE = "update";
    private static final String GRAPH_SPACE_ACTION_CLEAR = "clear";

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public Object list(@Context GraphManager manager, @Context SecurityContext sc) {
        Set<String> spaces = manager.graphSpaces();
        return ImmutableMap.of((Object)"graphSpaces", spaces);
    }

    @GET
    @Timed
    @Path(value="{graphspace}")
    @Produces(value={"application/json;charset=UTF-8"})
    public Object get(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace) {
        manager.getSpaceStorage(graphSpace);
        GraphSpace gs = GraphSpaceAPI.space(manager, graphSpace);
        String json = JsonUtil.toJson((Object)gs);
        Map gsInfo = (Map)JsonUtil.fromJson((String)json, Map.class);
        String dpUserName = this.getDpUserName(graphSpace);
        gsInfo.put("dp_username", dpUserName);
        gsInfo.put("dp_password", this.getDpPassWord(dpUserName));
        return gsInfo;
    }

    @POST
    @Timed
    @StatusFilter.Status(value=201)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin"})
    public String create(@Context GraphManager manager, JsonGraphSpace jsonGraphSpace) {
        jsonGraphSpace.checkCreate(false);
        String creator = HugeGraphAuthProxy.getContext().user().username();
        GraphSpace exist = manager.graphSpace(jsonGraphSpace.name);
        E.checkArgument((exist == null ? 1 : 0) != 0, (String)"The graph space '%s' has existed", (Object[])new Object[]{jsonGraphSpace.name});
        GraphSpace space = manager.createGraphSpace(jsonGraphSpace.toGraphSpace(creator));
        return manager.serializer().writeGraphSpace(space);
    }

    public boolean isPrefix(Map<String, Object> profile, String prefix) {
        if (StringUtils.isEmpty((String)prefix)) {
            return true;
        }
        String name = profile.get("name").toString();
        String nickname = profile.get("nickname").toString();
        return name.startsWith(prefix) || nickname.startsWith(prefix);
    }

    @PUT
    @Timed
    @Path(value="{name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin"})
    public Map<String, Object> manage(@Context GraphManager manager, @PathParam(value="name") String name, Map<String, Object> actionMap) {
        String action;
        E.checkArgument((actionMap != null && actionMap.size() == 2 && actionMap.containsKey(GRAPH_SPACE_ACTION) ? 1 : 0) != 0, (String)"Invalid request body '%s'", (Object[])new Object[]{actionMap});
        Object value = actionMap.get(GRAPH_SPACE_ACTION);
        E.checkArgument((boolean)(value instanceof String), (String)"Invalid action type '%s', must be string", (Object[])new Object[]{value.getClass()});
        switch (action = (String)value) {
            case "update": {
                Map configs;
                String internalAlgorithmImageUrl;
                String operatorImagePath;
                String storageNamespace;
                String olapNamespace;
                String oltpNamespace;
                int computeMemoryLimit;
                int computeCpuLimit;
                int storageLimit;
                int memoryLimit;
                int cpuLimit;
                int maxRoleNumber;
                int maxGraphNumber;
                String description;
                E.checkArgument((boolean)actionMap.containsKey(UPDATE), (String)"Please pass '%s' for graph space update", (Object[])new Object[]{UPDATE});
                value = actionMap.get(UPDATE);
                E.checkArgument((boolean)(value instanceof Map), (String)"The '%s' must be map, but got %s", (Object[])new Object[]{UPDATE, value.getClass()});
                Map graphSpaceMap = (Map)value;
                String gsName = (String)graphSpaceMap.get("name");
                E.checkArgument((boolean)gsName.equals(name), (String)"Different name in update body with in path", (Object[])new Object[0]);
                GraphSpace exist = manager.graphSpace(name);
                if (exist == null) {
                    throw new NotFoundException("Can't find graph space with name '%s'", new Object[]{gsName});
                }
                String nickname = (String)graphSpaceMap.get("nickname");
                if (!Strings.isEmpty((CharSequence)nickname)) {
                    GraphManager.checkNickname(nickname);
                    exist.nickname(nickname);
                }
                if (!Strings.isEmpty((CharSequence)(description = (String)graphSpaceMap.get("description")))) {
                    exist.description(description);
                }
                if ((maxGraphNumber = ((Integer)graphSpaceMap.get("max_graph_number")).intValue()) != 0) {
                    exist.maxGraphNumber(maxGraphNumber);
                }
                if ((maxRoleNumber = ((Integer)graphSpaceMap.get("max_role_number")).intValue()) != 0) {
                    exist.maxRoleNumber(maxRoleNumber);
                }
                if ((cpuLimit = ((Integer)graphSpaceMap.get("cpu_limit")).intValue()) != 0) {
                    exist.cpuLimit(cpuLimit);
                }
                if ((memoryLimit = ((Integer)graphSpaceMap.get("memory_limit")).intValue()) != 0) {
                    exist.memoryLimit(memoryLimit);
                }
                if ((storageLimit = ((Integer)graphSpaceMap.get("storage_limit")).intValue()) != 0) {
                    exist.storageLimit = storageLimit;
                }
                if ((computeCpuLimit = graphSpaceMap.getOrDefault("compute_cpu_limit", 0).intValue()) != 0) {
                    exist.computeCpuLimit(computeCpuLimit);
                }
                if ((computeMemoryLimit = graphSpaceMap.getOrDefault("compute_memory_limit", 0).intValue()) != 0) {
                    exist.computeMemoryLimit(computeMemoryLimit);
                }
                if ((oltpNamespace = (String)graphSpaceMap.get("oltp_namespace")) != null && !Strings.isEmpty((CharSequence)oltpNamespace)) {
                    exist.oltpNamespace(oltpNamespace);
                }
                if ((olapNamespace = (String)graphSpaceMap.get("olap_namespace")) != null && !Strings.isEmpty((CharSequence)olapNamespace)) {
                    exist.olapNamespace(olapNamespace);
                }
                if ((storageNamespace = (String)graphSpaceMap.get("storage_namespace")) != null && !Strings.isEmpty((CharSequence)storageNamespace)) {
                    exist.storageNamespace(storageNamespace);
                }
                if (!Strings.isEmpty((CharSequence)(operatorImagePath = graphSpaceMap.getOrDefault("operator_image_path", "")))) {
                    exist.operatorImagePath(operatorImagePath);
                }
                if (!Strings.isEmpty((CharSequence)(internalAlgorithmImageUrl = graphSpaceMap.getOrDefault("internal_algorithm_image_url", "")))) {
                    exist.internalAlgorithmImageUrl(internalAlgorithmImageUrl);
                }
                if ((configs = (Map)graphSpaceMap.get("configs")) != null && !configs.isEmpty()) {
                    exist.configs(configs);
                }
                exist.refreshUpdate();
                GraphSpace space = manager.createGraphSpace(exist);
                return space.info();
            }
            case "clear": {
                return ImmutableMap.of((Object)name, (Object)"cleared");
            }
        }
        throw new AssertionError((Object)String.format("Invalid action: '%s'", action));
    }

    @DELETE
    @Timed
    @Path(value="{name}")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin"})
    public void delete(@Context GraphManager manager, @PathParam(value="name") String name) {
        manager.dropGraphSpace(name);
    }

    private String getDpPassWord(String userName) {
        return DigestUtils.md5Hex((String)("a1p" + DigestUtils.md5Hex((String)userName).substring(5, 15) + "ck0")).substring(1, 17);
    }

    private String getDpUserName(String graphSpace) {
        return graphSpace.endsWith("gs") ? graphSpace.toLowerCase().substring(0, graphSpace.length() - 2) + "_dp" : graphSpace.toLowerCase() + "_dp";
    }

    private static class JsonDefaultRole
    implements Checkable {
        @JsonProperty(value="user")
        private String user;
        @JsonProperty(value="role")
        private String role;
        @JsonProperty(value="graph")
        private String graph;

        private JsonDefaultRole() {
        }

        @Override
        public void checkCreate(boolean isBatch) {
        }

        @Override
        public void checkUpdate() {
        }
    }

    private static class JsonGraphSpace
    implements Checkable {
        @JsonProperty(value="name")
        public String name;
        @JsonProperty(value="nickname")
        public String nickname;
        @JsonProperty(value="description")
        public String description;
        @JsonProperty(value="cpu_limit")
        public int cpuLimit;
        @JsonProperty(value="memory_limit")
        public int memoryLimit;
        @JsonProperty(value="storage_limit")
        public int storageLimit;
        @JsonProperty(value="compute_cpu_limit")
        public int computeCpuLimit = 0;
        @JsonProperty(value="compute_memory_limit")
        public int computeMemoryLimit = 0;
        @JsonProperty(value="oltp_namespace")
        public String oltpNamespace = "";
        @JsonProperty(value="olap_namespace")
        public String olapNamespace = "";
        @JsonProperty(value="storage_namespace")
        public String storageNamespace = "";
        @JsonProperty(value="max_graph_number")
        public int maxGraphNumber;
        @JsonProperty(value="max_role_number")
        public int maxRoleNumber;
        @JsonProperty(value="dp_username")
        public String dpUserName;
        @JsonProperty(value="dp_password")
        public String dpPassWord;
        @JsonProperty(value="auth")
        public boolean auth = false;
        @JsonProperty(value="configs")
        public Map<String, Object> configs;
        @JsonProperty(value="operator_image_path")
        public String operatorImagePath = "";
        @JsonProperty(value="internal_algorithm_image_url")
        public String internalAlgorithmImageUrl = "";

        private JsonGraphSpace() {
        }

        @Override
        public void checkCreate(boolean isBatch) {
            E.checkArgument((!StringUtils.isEmpty((String)this.name) ? 1 : 0) != 0, (String)"The name of graph space can't be null or empty", (Object[])new Object[0]);
            E.checkArgument((this.maxGraphNumber > 0 ? 1 : 0) != 0, (String)"The max graph number must > 0", (Object[])new Object[0]);
            E.checkArgument((this.cpuLimit > 0 ? 1 : 0) != 0, (String)"The cpu limit must be > 0, but got: %s", (Object[])new Object[]{this.cpuLimit});
            E.checkArgument((this.memoryLimit > 0 ? 1 : 0) != 0, (String)"The memory limit must be > 0, but got: %s", (Object[])new Object[]{this.memoryLimit});
            E.checkArgument((this.storageLimit > 0 ? 1 : 0) != 0, (String)"The storage limit must be > 0, but got: %s", (Object[])new Object[]{this.storageLimit});
            if (this.oltpNamespace == null) {
                this.oltpNamespace = "";
            }
            if (this.olapNamespace == null) {
                this.olapNamespace = "";
            }
            if (this.storageNamespace == null) {
                this.storageNamespace = "";
            }
        }

        public GraphSpace toGraphSpace(String creator) {
            GraphSpace graphSpace = new GraphSpace(this.name, this.nickname, this.description, this.cpuLimit, this.memoryLimit, this.storageLimit, this.maxGraphNumber, this.maxRoleNumber, this.auth, creator, this.configs);
            graphSpace.oltpNamespace(this.oltpNamespace);
            graphSpace.olapNamespace(this.olapNamespace);
            graphSpace.storageNamespace(this.storageNamespace);
            graphSpace.computeCpuLimit(this.computeCpuLimit);
            graphSpace.computeMemoryLimit(this.computeMemoryLimit);
            graphSpace.operatorImagePath(this.operatorImagePath);
            graphSpace.internalAlgorithmImageUrl(this.internalAlgorithmImageUrl);
            if (this.configs != null) {
                graphSpace.configs(this.configs);
            }
            return graphSpace;
        }

        public String toString() {
            return String.format("JsonGraphSpace{name=%s, description=%s, cpuLimit=%s, memoryLimit=%s, storageLimit=%s, oltpNamespace=%s,olapNamespace=%s, storageNamespace=%s,maxGraphNumber=%s, maxRoleNumber=%s, configs=%s, operatorImagePath=%s, internalAlgorithmImageUrl=%s}", this.name, this.description, this.cpuLimit, this.memoryLimit, this.storageLimit, this.oltpNamespace, this.olapNamespace, this.storageLimit, this.maxGraphNumber, this.maxRoleNumber, this.configs, this.operatorImagePath, this.internalAlgorithmImageUrl);
        }
    }
}

