/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.server.triple;

import com.alipay.sofa.rpc.base.Destroyable;
import com.alipay.sofa.rpc.common.struct.NamedThreadFactory;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.constant.TripleConstant;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.event.ServerStartedEvent;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.interceptor.ServerReqHeaderInterceptor;
import com.alipay.sofa.rpc.interceptor.TripleServerInterceptor;
import com.alipay.sofa.rpc.invoke.Invoker;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.proxy.ProxyFactory;
import com.alipay.sofa.rpc.server.BusinessPool;
import com.alipay.sofa.rpc.server.Server;
import com.alipay.sofa.rpc.server.SofaRejectedExecutionHandler;
import com.alipay.sofa.rpc.server.triple.GenericServiceImpl;
import com.alipay.sofa.rpc.utils.SofaProtoUtils;
import com.google.protobuf.Message;
import io.grpc.BindableService;
import io.grpc.HandlerRegistry;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptors;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.ServerChannel;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.util.MutableHandlerRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import triple.Request;
import triple.Response;

@Extension(value="tri")
public class TripleServer
implements Server {
    private static final Logger LOGGER = LoggerFactory.getLogger(TripleServer.class);
    protected ConcurrentHashMap<ProviderConfig, ServerServiceDefinition> oldServiceInfo = new ConcurrentHashMap();
    protected ServerConfig serverConfig;
    protected volatile boolean started;
    protected io.grpc.Server server;
    protected MutableHandlerRegistry handlerRegistry = new MutableHandlerRegistry();
    protected ConcurrentHashMap<ProviderConfig, ServerServiceDefinition> serviceInfo = new ConcurrentHashMap();
    protected AtomicInteger invokerCnt = new AtomicInteger();
    private ThreadPoolExecutor bizThreadPool;

    @Override
    public void init(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        this.bizThreadPool = this.initThreadPool(serverConfig);
        this.server = ((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forPort((int)serverConfig.getPort()).fallbackHandlerRegistry((HandlerRegistry)this.handlerRegistry)).bossEventLoopGroup(this.constructBossEventLoopGroup()).workerEventLoopGroup(this.constructWorkerEventLoopGroup()).executor((Executor)this.bizThreadPool)).channelType(this.constructChannel()).build();
    }

    private Class<? extends ServerChannel> constructChannel() {
        return this.serverConfig.isEpoll() ? EpollServerSocketChannel.class : NioServerSocketChannel.class;
    }

    private EventLoopGroup constructWorkerEventLoopGroup() {
        int workerThreads = this.serverConfig.getIoThreads();
        workerThreads = workerThreads <= 0 ? Runtime.getRuntime().availableProcessors() * 2 : workerThreads;
        NamedThreadFactory threadName = new NamedThreadFactory("SEV-WORKER-" + this.serverConfig.getPort(), this.serverConfig.isDaemon());
        EpollEventLoopGroup workerGroup = this.serverConfig.isEpoll() ? new EpollEventLoopGroup(workerThreads, (ThreadFactory)threadName) : new NioEventLoopGroup(workerThreads, (ThreadFactory)threadName);
        return workerGroup;
    }

    private EventLoopGroup constructBossEventLoopGroup() {
        NamedThreadFactory threadName = new NamedThreadFactory("SEV-BOSS-" + this.serverConfig.getPort(), this.serverConfig.isDaemon());
        EpollEventLoopGroup bossGroup = this.serverConfig.isEpoll() ? new EpollEventLoopGroup(1, (ThreadFactory)threadName) : new NioEventLoopGroup(1, (ThreadFactory)threadName);
        return bossGroup;
    }

    protected ThreadPoolExecutor initThreadPool(ServerConfig serverConfig) {
        ThreadPoolExecutor threadPool = BusinessPool.initPool(serverConfig);
        threadPool.setThreadFactory(new NamedThreadFactory("SEV-TRIPLE-BIZ-" + serverConfig.getPort(), serverConfig.isDaemon()));
        threadPool.setRejectedExecutionHandler(new SofaRejectedExecutionHandler());
        if (serverConfig.isPreStartCore()) {
            threadPool.prestartAllCoreThreads();
        }
        return threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.started) {
            return;
        }
        TripleServer tripleServer = this;
        synchronized (tripleServer) {
            if (this.started) {
                return;
            }
            try {
                this.server.start();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Start the triple server at port {}", this.serverConfig.getPort());
                }
                if (EventBus.isEnable(ServerStartedEvent.class)) {
                    EventBus.post(new ServerStartedEvent(this.serverConfig, this.bizThreadPool));
                }
            }
            catch (SofaRpcRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SofaRpcRuntimeException(LogCodes.getLog("010000028", "grpc", this.serverConfig.getPort()), e);
            }
            this.started = true;
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean hasNoEntry() {
        return false;
    }

    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Stop the triple server at port {}", this.serverConfig.getPort());
            }
            this.server.shutdown();
        }
        catch (Exception e) {
            LOGGER.error("Stop the triple server at port " + this.serverConfig.getPort() + " error !", e);
        }
        this.started = false;
    }

    @Override
    public void registerProcessor(ProviderConfig providerConfig, Invoker instance) {
        Object ref = providerConfig.getRef();
        try {
            ServerServiceDefinition ssd;
            ServerServiceDefinition serviceDefinition;
            List<TripleServerInterceptor> interceptorList;
            ServerServiceDefinition serviceDef;
            if (SofaProtoUtils.isProtoClass(ref)) {
                BindableService bindableService = (BindableService)providerConfig.getRef();
                serviceDef = bindableService.bindService();
            } else {
                Object obj = ProxyFactory.buildProxy(providerConfig.getProxy(), providerConfig.getProxyClass(), instance);
                GenericServiceImpl genericService = new GenericServiceImpl(obj, providerConfig.getProxyClass());
                genericService.setProxiedImpl(genericService);
                serviceDef = this.buildSofaServiceDef(genericService, providerConfig);
            }
            ServerServiceDefinition oldServiceDef = serviceDef;
            if (StringUtils.isNotBlank(providerConfig.getUniqueId())) {
                serviceDef = this.appendUniqueIdToServiceDef(providerConfig.getUniqueId(), serviceDef);
                if (this.exposeOldUniqueIdService(providerConfig)) {
                    interceptorList = this.buildInterceptorChain(oldServiceDef);
                    serviceDefinition = ServerInterceptors.intercept((ServerServiceDefinition)oldServiceDef, interceptorList);
                    this.oldServiceInfo.put(providerConfig, serviceDefinition);
                    ssd = this.handlerRegistry.addService(serviceDefinition);
                    if (ssd != null) {
                        throw new IllegalStateException("Can not expose service with same name:" + serviceDefinition.getServiceDescriptor().getName());
                    }
                }
            }
            interceptorList = this.buildInterceptorChain(serviceDef);
            serviceDefinition = ServerInterceptors.intercept((ServerServiceDefinition)serviceDef, interceptorList);
            this.serviceInfo.put(providerConfig, serviceDefinition);
            ssd = this.handlerRegistry.addService(serviceDefinition);
            if (ssd != null) {
                throw new IllegalStateException("Can not expose service with same name:" + serviceDefinition.getServiceDescriptor().getName());
            }
            this.invokerCnt.incrementAndGet();
        }
        catch (Exception e) {
            String msg = "Register triple service error";
            LOGGER.error(msg, e);
            this.serviceInfo.remove(providerConfig);
            throw new SofaRpcRuntimeException(msg, e);
        }
    }

    private boolean exposeOldUniqueIdService(ProviderConfig providerConfig) {
        String exposeOld = providerConfig.getParameter("triple.use.old.path");
        if (StringUtils.isBlank(exposeOld)) {
            return TripleConstant.EXPOSE_OLD_UNIQUE_ID_SERVICE;
        }
        return Boolean.parseBoolean(exposeOld);
    }

    private ServerServiceDefinition appendUniqueIdToServiceDef(String uniqueId, ServerServiceDefinition serviceDef) {
        String newServiceName = serviceDef.getServiceDescriptor().getName() + "." + uniqueId;
        ServerServiceDefinition.Builder builder = ServerServiceDefinition.builder((String)newServiceName);
        Collection methods = serviceDef.getMethods();
        for (ServerMethodDefinition method : methods) {
            MethodDescriptor methodDescriptor = method.getMethodDescriptor();
            String fullMethodName = methodDescriptor.getFullMethodName();
            MethodDescriptor methodDescriptorWithUniqueId = methodDescriptor.toBuilder().setFullMethodName(SofaProtoUtils.getFullNameWithUniqueId(fullMethodName, uniqueId)).build();
            ServerMethodDefinition newServerMethodDefinition = ServerMethodDefinition.create((MethodDescriptor)methodDescriptorWithUniqueId, (ServerCallHandler)method.getServerCallHandler());
            builder.addMethod(newServerMethodDefinition);
        }
        serviceDef = builder.build();
        return serviceDef;
    }

    private ServerServiceDefinition buildSofaServiceDef(GenericServiceImpl genericService, ProviderConfig providerConfig) {
        ServerServiceDefinition templateDefinition = genericService.bindService();
        ServerCallHandler templateHandler = ((ServerMethodDefinition)templateDefinition.getMethods().iterator().next()).getServerCallHandler();
        List<MethodDescriptor<Request, Response>> methodDescriptor = this.getMethodDescriptor(providerConfig);
        List<ServerMethodDefinition<Request, Response>> methodDefs = this.getMethodDefinitions((ServerCallHandler<Request, Response>)templateHandler, methodDescriptor);
        ServerServiceDefinition.Builder builder = ServerServiceDefinition.builder((ServiceDescriptor)this.getServiceDescriptor(templateDefinition, providerConfig, methodDescriptor));
        for (ServerMethodDefinition<Request, Response> methodDef : methodDefs) {
            builder.addMethod(methodDef);
        }
        return builder.build();
    }

    private List<ServerMethodDefinition<Request, Response>> getMethodDefinitions(ServerCallHandler<Request, Response> templateHandler, List<MethodDescriptor<Request, Response>> methodDescriptors) {
        ArrayList<ServerMethodDefinition<Request, Response>> result = new ArrayList<ServerMethodDefinition<Request, Response>>();
        for (MethodDescriptor<Request, Response> methodDescriptor : methodDescriptors) {
            ServerMethodDefinition serverMethodDefinition = ServerMethodDefinition.create(methodDescriptor, templateHandler);
            result.add((ServerMethodDefinition<Request, Response>)serverMethodDefinition);
        }
        return result;
    }

    private ServiceDescriptor getServiceDescriptor(ServerServiceDefinition template, ProviderConfig providerConfig, List<MethodDescriptor<Request, Response>> methodDescriptors) {
        String serviceName = providerConfig.getInterfaceId();
        ServiceDescriptor.Builder builder = ServiceDescriptor.newBuilder((String)serviceName).setSchemaDescriptor(template.getServiceDescriptor().getSchemaDescriptor());
        for (MethodDescriptor<Request, Response> methodDescriptor : methodDescriptors) {
            builder.addMethod(methodDescriptor);
        }
        return builder.build();
    }

    private List<MethodDescriptor<Request, Response>> getMethodDescriptor(ProviderConfig providerConfig) {
        ArrayList<MethodDescriptor<Request, Response>> result = new ArrayList<MethodDescriptor<Request, Response>>();
        Set<String> methodNames = SofaProtoUtils.getMethodNames(providerConfig.getInterfaceId());
        for (String name : methodNames) {
            MethodDescriptor methodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName((String)providerConfig.getInterfaceId(), (String)name)).setSampledToLocalTracing(true).setRequestMarshaller(ProtoUtils.marshaller((Message)Request.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Response.getDefaultInstance())).build();
            result.add((MethodDescriptor<Request, Response>)methodDescriptor);
        }
        return result;
    }

    protected List<TripleServerInterceptor> buildInterceptorChain(ServerServiceDefinition serviceDef) {
        ArrayList<TripleServerInterceptor> interceptorList = new ArrayList<TripleServerInterceptor>();
        interceptorList.add(new ServerReqHeaderInterceptor(serviceDef));
        return interceptorList;
    }

    @Override
    public void unRegisterProcessor(ProviderConfig providerConfig, boolean closeIfNoEntry) {
        try {
            ServerServiceDefinition oldServiceDef;
            ServerServiceDefinition serverServiceDefinition = this.serviceInfo.get(providerConfig);
            if (this.exposeOldUniqueIdService(providerConfig) && (oldServiceDef = this.oldServiceInfo.get(providerConfig)) != null) {
                this.handlerRegistry.removeService(oldServiceDef);
            }
            this.handlerRegistry.removeService(serverServiceDefinition);
            this.invokerCnt.decrementAndGet();
        }
        catch (Exception e) {
            LOGGER.error("Unregister triple service error", e);
        }
        if (closeIfNoEntry && this.invokerCnt.get() == 0) {
            this.stop();
        }
    }

    @Override
    public void destroy() {
        this.stop();
        this.server = null;
    }

    @Override
    public void destroy(Destroyable.DestroyHook hook) {
        if (hook != null) {
            hook.preDestroy();
        }
        this.destroy();
        if (hook != null) {
            hook.postDestroy();
        }
    }

    public ThreadPoolExecutor getBizThreadPool() {
        return this.bizThreadPool;
    }
}

