/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.query;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hugegraph.store.HgKvIterator;
import org.apache.hugegraph.store.query.func.AggregationFunction;
import org.apache.hugegraph.store.query.func.AggregationFunctionParam;
import org.apache.hugegraph.store.query.func.AggregationFunctions;
import org.apache.hugegraph.structure.KvElement;

public class StreamFinalAggregationIterator<E>
implements HgKvIterator<E> {
    private final HgKvIterator iterator;
    private final List<AggregationFunctionParam> aggregationParams;
    private List<AggregationFunction> functions;
    private KvElement prev = null;
    private KvElement data = null;

    public StreamFinalAggregationIterator(HgKvIterator iterator, List<AggregationFunctionParam> aggregations) {
        this.iterator = iterator;
        this.aggregationParams = aggregations;
    }

    @Override
    public byte[] key() {
        return this.iterator.key();
    }

    @Override
    public byte[] value() {
        return this.iterator.value();
    }

    @Override
    public void close() {
        this.iterator.close();
    }

    @Override
    public byte[] position() {
        return this.iterator.position();
    }

    @Override
    public void seek(byte[] position) {
        this.iterator.seek(position);
    }

    @Override
    public boolean hasNext() {
        while (this.iterator.hasNext()) {
            KvElement next = (KvElement)this.iterator.next();
            if (this.prev == null) {
                this.prev = next;
                this.functions = this.getAggregationList();
                this.merge(this.prev.getValues());
                continue;
            }
            if (this.keyEquals(next.getKeys(), this.prev.getKeys())) {
                this.merge(next.getValues());
                continue;
            }
            this.data = KvElement.of((List)this.prev.getKeys(), this.term());
            this.prev = next;
            this.functions = this.getAggregationList();
            this.merge(this.prev.getValues());
            break;
        }
        if (!this.iterator.hasNext() && this.prev != null && this.data == null) {
            this.data = KvElement.of((List)this.prev.getKeys(), this.term());
            this.prev = null;
        }
        return this.data != null;
    }

    private void merge(List<Object> values) {
        for (int i = 0; i < this.functions.size(); ++i) {
            this.functions.get(i).merge(values.get(i));
        }
    }

    private List<Object> term() {
        List<Object> values = this.functions.stream().map(f -> f.reduce()).collect(Collectors.toList());
        this.functions.clear();
        return values;
    }

    @Override
    public E next() {
        KvElement rst = this.data;
        this.data = null;
        return (E)rst;
    }

    private boolean keyEquals(List l1, List l2) {
        if (l1 == null && l2 == null) {
            return true;
        }
        if (l1 != null && l2 == null || l1 == null || l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (l1.get(i).equals(l2.get(i))) continue;
            return false;
        }
        return true;
    }

    private List<AggregationFunction> getAggregationList() {
        return this.aggregationParams.stream().map(param -> {
            String filedType = param.getFieldType().getGenericType();
            switch (param.getFunctionType()) {
                case SUM: {
                    return new AggregationFunctions.SumFunction(param.getField(), this.getSupplier(filedType));
                }
                case MIN: {
                    return new AggregationFunctions.MinFunction(param.getField(), this.getSupplier(filedType));
                }
                case MAX: {
                    return new AggregationFunctions.MaxFunction(param.getField(), this.getSupplier(filedType));
                }
                case AVG: {
                    return new AggregationFunctions.AvgFunction(this.getSupplier(filedType));
                }
                case COUNT: {
                    return new AggregationFunctions.CountFunction();
                }
            }
            throw new RuntimeException("unsupported function type: " + String.valueOf(param.getFunctionType()));
        }).collect(Collectors.toList());
    }

    private Supplier getSupplier(String type) {
        return AggregationFunctions.getAggregationBufferSupplier((String)type);
    }
}

