/*
 * Decompiled with CFR 0.152.
 */
package contribs.mx;

import contribs.mx.S3BucketMx;
import contribs.mx.S3ObjectMx;
import contribs.mx.S3ServiceExceptionMx;
import contribs.mx.S3ServiceMx;
import org.apache.fluss.shaded.org.apache.commons.logging.Log;
import org.apache.fluss.shaded.org.apache.commons.logging.LogFactory;
import org.jets3t.service.model.StorageBucket;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.mx.MxDelegate;
import org.jets3t.service.mx.MxInterface;

public class MxImpl
implements MxInterface {
    private static final Log log = LogFactory.getLog(MxDelegate.class);

    public MxImpl() {
        log.debug("JMX instrumentation implementation started. S3BucketMx enabled? " + S3BucketMx.isEnabled + ", S3ObjectMx enabled? " + S3ObjectMx.isEnabled);
    }

    public void registerS3ServiceMBean() {
        S3ServiceMx.registerMBean();
    }

    public void registerS3ServiceExceptionMBean() {
        S3ServiceExceptionMx.registerMBean();
    }

    public void registerS3ServiceExceptionEvent() {
        S3ServiceExceptionMx.increment();
    }

    public void registerS3ServiceExceptionEvent(String s3ErrorCode) {
        S3ServiceExceptionMx.increment(s3ErrorCode);
    }

    public void registerStorageBucketMBeans(StorageBucket[] buckets) {
        S3BucketMx.registerMBeans(buckets);
    }

    public void registerStorageBucketListEvent(String bucketName) {
        S3BucketMx.list(bucketName);
    }

    public void registerStorageObjectMBean(String bucketName, StorageObject[] objects) {
        S3ObjectMx.registerMBeans(bucketName, objects);
    }

    public void registerStorageObjectPutEvent(String bucketName, String key) {
        S3ObjectMx.put(bucketName, key);
    }

    public void registerStorageObjectGetEvent(String bucketName, String key) {
        S3ObjectMx.get(bucketName, key);
    }

    public void registerStorageObjectHeadEvent(String bucketName, String key) {
        S3ObjectMx.head(bucketName, key);
    }

    public void registerStorageObjectDeleteEvent(String bucketName, String key) {
        S3ObjectMx.delete(bucketName, key);
    }

    public void registerStorageObjectCopyEvent(String bucketName, String key) {
        S3ObjectMx.copy(bucketName, key);
    }
}

