/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ResourcePBImpl
extends Resource {
    YarnProtos.ResourceProto proto = YarnProtos.ResourceProto.getDefaultInstance();
    YarnProtos.ResourceProto.Builder builder = null;
    boolean viaProto = false;

    public ResourcePBImpl() {
        this.builder = YarnProtos.ResourceProto.newBuilder();
    }

    public ResourcePBImpl(YarnProtos.ResourceProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.ResourceProto getProto() {
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ResourceProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public int getMemory() {
        return (int)this.getMemorySize();
    }

    @Override
    public long getMemorySize() {
        YarnProtos.ResourceProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getMemory();
    }

    @Override
    public void setMemory(int memory) {
        this.setMemorySize(memory);
    }

    @Override
    public void setMemorySize(long memory) {
        this.maybeInitBuilder();
        this.builder.setMemory(memory);
    }

    @Override
    public int getVirtualCores() {
        YarnProtos.ResourceProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getVirtualCores();
    }

    @Override
    public void setVirtualCores(int vCores) {
        this.maybeInitBuilder();
        this.builder.setVirtualCores(vCores);
    }

    @Override
    public int compareTo(Resource other) {
        long diff = this.getMemorySize() - other.getMemorySize();
        if (diff == 0L) {
            diff = this.getVirtualCores() - other.getVirtualCores();
        }
        return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
    }
}

