/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.server.namenode.FSDirSnapshotOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.util.ChunkedArrayList;
import org.apache.hadoop.util.Time;

class FSDirDeleteOp {
    FSDirDeleteOp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long delete(FSDirectory fsd, INodesInPath iip, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, List<Long> removedUCFiles, long mtime) throws IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.delete: " + iip.getPath());
        }
        long filesRemoved = -1L;
        FSNamesystem fsn = fsd.getFSNamesystem();
        fsd.writeLock();
        try {
            if (FSDirDeleteOp.deleteAllowed(iip)) {
                ArrayList<INodeDirectory> snapshottableDirs = new ArrayList<INodeDirectory>();
                FSDirSnapshotOp.checkSnapshot(fsd, iip, snapshottableDirs);
                INode.ReclaimContext context = new INode.ReclaimContext(fsd.getBlockStoragePolicySuite(), collectedBlocks, removedINodes, removedUCFiles);
                if (FSDirDeleteOp.unprotectedDelete(fsd, iip, context, mtime)) {
                    filesRemoved = context.quotaDelta().getNsDelta();
                }
                fsd.updateReplicationFactor(context.collectedBlocks().toUpdateReplicationInfo());
                fsn.removeSnapshottableDirs(snapshottableDirs);
                fsd.updateCount(iip, context.quotaDelta(), false);
            }
        }
        finally {
            fsd.writeUnlock();
        }
        return filesRemoved;
    }

    static INode.BlocksMapUpdateInfo delete(FSNamesystem fsn, FSPermissionChecker pc, String src, boolean recursive, boolean logRetryCache) throws IOException {
        FSDirectory fsd = fsn.getFSDirectory();
        if (FSDirectory.isExactReservedName(src)) {
            throw new InvalidPathException(src);
        }
        INodesInPath iip = fsd.resolvePath(pc, src, FSDirectory.DirOp.WRITE_LINK);
        if (fsd.isPermissionEnabled()) {
            fsd.checkPermission(pc, iip, false, null, FsAction.WRITE, null, FsAction.ALL, true);
        }
        if (fsd.isNonEmptyDirectory(iip)) {
            if (!recursive) {
                throw new PathIsNotEmptyDirectoryException(iip.getPath() + " is non empty");
            }
            FSDirDeleteOp.checkProtectedDescendants(fsd, iip);
        }
        return FSDirDeleteOp.deleteInternal(fsn, iip, logRetryCache);
    }

    static void deleteForEditLog(FSDirectory fsd, INodesInPath iip, long mtime) throws IOException {
        assert (fsd.hasWriteLock());
        FSNamesystem fsn = fsd.getFSNamesystem();
        INode.BlocksMapUpdateInfo collectedBlocks = new INode.BlocksMapUpdateInfo();
        ChunkedArrayList removedINodes = new ChunkedArrayList();
        ChunkedArrayList removedUCFiles = new ChunkedArrayList();
        if (!FSDirDeleteOp.deleteAllowed(iip)) {
            return;
        }
        ArrayList<INodeDirectory> snapshottableDirs = new ArrayList<INodeDirectory>();
        FSDirSnapshotOp.checkSnapshot(fsd, iip, snapshottableDirs);
        boolean filesRemoved = FSDirDeleteOp.unprotectedDelete(fsd, iip, new INode.ReclaimContext(fsd.getBlockStoragePolicySuite(), collectedBlocks, (List<INode>)removedINodes, (List<Long>)removedUCFiles), mtime);
        fsn.removeSnapshottableDirs(snapshottableDirs);
        if (filesRemoved) {
            fsn.removeLeasesAndINodes((List<Long>)removedUCFiles, (List<INode>)removedINodes, false);
            fsn.getBlockManager().removeBlocksAndUpdateSafemodeTotal(collectedBlocks);
        }
    }

    static INode.BlocksMapUpdateInfo deleteInternal(FSNamesystem fsn, INodesInPath iip, boolean logRetryCache) throws IOException {
        long mtime;
        ChunkedArrayList removedUCFiles;
        ChunkedArrayList removedINodes;
        INode.BlocksMapUpdateInfo collectedBlocks;
        FSDirectory fsd;
        long filesRemoved;
        assert (fsn.hasWriteLock());
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* NameSystem.delete: " + iip.getPath());
        }
        if ((filesRemoved = FSDirDeleteOp.delete(fsd = fsn.getFSDirectory(), iip, collectedBlocks = new INode.BlocksMapUpdateInfo(), (List<INode>)(removedINodes = new ChunkedArrayList()), (List<Long>)(removedUCFiles = new ChunkedArrayList()), mtime = Time.now())) < 0L) {
            return null;
        }
        fsd.getEditLog().logDelete(iip.getPath(), mtime, logRetryCache);
        FSDirDeleteOp.incrDeletedFileCount(filesRemoved);
        fsn.removeLeasesAndINodes((List<Long>)removedUCFiles, (List<INode>)removedINodes, true);
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* Namesystem.delete: " + iip.getPath() + " is removed");
        }
        return collectedBlocks;
    }

    static void incrDeletedFileCount(long count) {
        NameNode.getNameNodeMetrics().incrFilesDeleted(count);
    }

    private static boolean deleteAllowed(INodesInPath iip) {
        if (iip.length() < 1 || iip.getLastINode() == null) {
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedDelete: failed to remove " + iip.getPath() + " because it does not exist");
            }
            return false;
        }
        if (iip.length() == 1) {
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedDelete: failed to remove " + iip.getPath() + " because the root is not allowed to be deleted");
            return false;
        }
        return true;
    }

    private static boolean unprotectedDelete(FSDirectory fsd, INodesInPath iip, INode.ReclaimContext reclaimContext, long mtime) {
        assert (fsd.hasWriteLock());
        INode targetNode = iip.getLastINode();
        if (targetNode == null) {
            return false;
        }
        int latestSnapshot = iip.getLatestSnapshotId();
        targetNode.recordModification(latestSnapshot);
        long removed = fsd.removeLastINode(iip);
        if (removed == -1L) {
            return false;
        }
        INodeDirectory parent = targetNode.getParent();
        parent.updateModificationTime(mtime, latestSnapshot);
        if (!targetNode.isInLatestSnapshot(latestSnapshot)) {
            targetNode.destroyAndCollectBlocks(reclaimContext);
        } else {
            targetNode.cleanSubtree(reclaimContext, 0x7FFFFFFE, latestSnapshot);
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedDelete: " + iip.getPath() + " is removed");
        }
        return true;
    }

    private static void checkProtectedDescendants(FSDirectory fsd, INodesInPath iip) throws AccessControlException, UnresolvedLinkException, ParentNotDirectoryException {
        SortedSet<String> protectedDirs = fsd.getProtectedDirectories();
        if (protectedDirs.isEmpty()) {
            return;
        }
        String src = iip.getPath();
        if (protectedDirs.contains(src)) {
            throw new AccessControlException("Cannot delete non-empty protected directory " + src);
        }
        for (String descendant : protectedDirs.subSet(src + "/", src + "0")) {
            INodesInPath subdirIIP = fsd.getINodesInPath(descendant, FSDirectory.DirOp.WRITE);
            if (!fsd.isNonEmptyDirectory(subdirIIP)) continue;
            throw new AccessControlException("Cannot delete non-empty protected subdirectory " + descendant);
        }
    }
}

