/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.ptf;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ptf.PTFExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;

@Explain(displayName="window function definition")
public class WindowFunctionDef
extends WindowExpressionDef {
    String name;
    boolean isStar;
    boolean isDistinct;
    List<PTFExpressionDef> args;
    WindowFrameDef windowFrame;
    GenericUDAFEvaluator wFnEval;
    boolean pivotResult;
    boolean respectNulls = true;

    @Explain(displayName="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Explain(displayName="isStar", displayOnlyOnTrue=true)
    public boolean isStar() {
        return this.isStar;
    }

    public void setStar(boolean isStar) {
        this.isStar = isStar;
    }

    @Explain(displayName="isDistinct", displayOnlyOnTrue=true)
    public boolean isDistinct() {
        return this.isDistinct;
    }

    public void setDistinct(boolean isDistinct) {
        this.isDistinct = isDistinct;
    }

    public List<PTFExpressionDef> getArgs() {
        return this.args;
    }

    public void setArgs(List<PTFExpressionDef> args) {
        this.args = args;
    }

    public void addArg(PTFExpressionDef arg) {
        this.args = this.args == null ? new ArrayList() : this.args;
        this.args.add(arg);
    }

    @Explain(displayName="arguments")
    public String getArgsExplain() {
        if (this.args == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (PTFExpressionDef expression : this.args) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(expression.getExprNode().getExprString());
        }
        return builder.toString();
    }

    public WindowFrameDef getWindowFrame() {
        return this.windowFrame;
    }

    public void setWindowFrame(WindowFrameDef windowFrame) {
        this.windowFrame = windowFrame;
    }

    @Explain(displayName="window frame")
    public String getWindowFrameExplain() {
        return this.windowFrame == null ? null : this.windowFrame.toString();
    }

    public GenericUDAFEvaluator getWFnEval() {
        return this.wFnEval;
    }

    public void setWFnEval(GenericUDAFEvaluator wFnEval) {
        this.wFnEval = wFnEval;
    }

    @Explain(displayName="window function")
    public String getWFnEvalExplain() {
        return this.wFnEval == null ? null : this.wFnEval.getClass().getSimpleName();
    }

    @Explain(displayName="isPivotResult", displayOnlyOnTrue=true)
    public boolean isPivotResult() {
        return this.pivotResult;
    }

    public void setPivotResult(boolean pivotResult) {
        this.pivotResult = pivotResult;
    }

    public boolean respectNulls() {
        return this.respectNulls;
    }

    public void setRespectNulls(boolean respectNulls) {
        this.respectNulls = respectNulls;
    }
}

