/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.io.StorageFormatDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageFormatFactory {
    private static final Logger LOG = LoggerFactory.getLogger(StorageFormatFactory.class);
    private final Map<String, StorageFormatDescriptor> storageFormats;

    public StorageFormatFactory() {
        HashMap<String, StorageFormatDescriptor> localStorageFormats = new HashMap<String, StorageFormatDescriptor>();
        for (StorageFormatDescriptor descriptor : ServiceLoader.load(StorageFormatDescriptor.class)) {
            for (String name : descriptor.getNames()) {
                StorageFormatDescriptor oldDescriptor = localStorageFormats.put(name = name.trim().toUpperCase(), descriptor);
                if (oldDescriptor == null) continue;
                String msg = "Storage Format Descriptor conflict at name '" + name + "', the descriptor " + String.valueOf(descriptor) + " is overriding " + String.valueOf(oldDescriptor);
                LOG.warn(msg);
            }
        }
        this.storageFormats = ImmutableMap.copyOf(localStorageFormats);
    }

    @Nullable
    public StorageFormatDescriptor get(String name) {
        name = name.trim().toUpperCase();
        return this.storageFormats.get(name);
    }
}

