/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class VectorElt
extends VectorExpression {
    private static final long serialVersionUID = 1L;

    public VectorElt(int[] inputColumns, int outputColumnNum) {
        super(inputColumns, outputColumnNum);
    }

    public VectorElt() {
        this.inputColumnNum = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        int[] sel = batch.selected;
        int n = batch.size;
        BytesColumnVector outputVector = (BytesColumnVector)batch.cols[this.outputColumnNum];
        if (n <= 0) {
            return;
        }
        outputVector.init();
        outputVector.isRepeating = false;
        int limit = this.inputColumnNum.length;
        LongColumnVector inputIndexVector = (LongColumnVector)batch.cols[this.inputColumnNum[0]];
        boolean[] inputIndexIsNull = inputIndexVector.isNull;
        long[] indexVector = inputIndexVector.vector;
        if (inputIndexVector.isRepeating) {
            if (inputIndexVector.noNulls || !inputIndexIsNull[0]) {
                int repeatedIndex = (int)indexVector[0];
                if (repeatedIndex > 0 && repeatedIndex < limit) {
                    BytesColumnVector cv = (BytesColumnVector)batch.cols[this.inputColumnNum[repeatedIndex]];
                    if (cv.isRepeating) {
                        outputVector.isNull[0] = false;
                        outputVector.setElement(0, 0, (ColumnVector)cv);
                        outputVector.isRepeating = true;
                    } else if (cv.noNulls) {
                        if (batch.selectedInUse) {
                            for (int j = 0; j != n; ++j) {
                                int i = sel[j];
                                outputVector.isNull[i] = false;
                                outputVector.setVal(i, cv.vector[i], cv.start[i], cv.length[i]);
                            }
                        } else {
                            for (int i = 0; i != n; ++i) {
                                outputVector.isNull[i] = false;
                                outputVector.setVal(i, cv.vector[i], cv.start[i], cv.length[i]);
                            }
                        }
                    } else if (batch.selectedInUse) {
                        for (int j = 0; j != n; ++j) {
                            int i = sel[j];
                            if (!cv.isNull[i]) {
                                outputVector.isNull[i] = false;
                                outputVector.setVal(i, cv.vector[i], cv.start[i], cv.length[i]);
                                continue;
                            }
                            outputVector.isNull[i] = true;
                            outputVector.noNulls = false;
                        }
                    } else {
                        for (int i = 0; i != n; ++i) {
                            if (!cv.isNull[i]) {
                                outputVector.isNull[i] = false;
                                outputVector.setVal(i, cv.vector[i], cv.start[i], cv.length[i]);
                                continue;
                            }
                            outputVector.isNull[i] = true;
                            outputVector.noNulls = false;
                        }
                    }
                } else {
                    outputVector.isNull[0] = true;
                    outputVector.noNulls = false;
                    outputVector.isRepeating = true;
                }
            } else {
                outputVector.isNull[0] = true;
                outputVector.noNulls = false;
                outputVector.isRepeating = true;
            }
            return;
        }
        if (inputIndexVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    int index = (int)indexVector[i];
                    if (index > 0 && index < limit) {
                        int adjusted;
                        BytesColumnVector cv = (BytesColumnVector)batch.cols[this.inputColumnNum[index]];
                        int n2 = adjusted = cv.isRepeating ? 0 : i;
                        if (!cv.isNull[adjusted]) {
                            outputVector.isNull[i] = false;
                            outputVector.setVal(i, cv.vector[adjusted], cv.start[adjusted], cv.length[adjusted]);
                            continue;
                        }
                        outputVector.isNull[i] = true;
                        outputVector.noNulls = false;
                        continue;
                    }
                    outputVector.isNull[i] = true;
                    outputVector.noNulls = false;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    int index = (int)indexVector[i];
                    if (index > 0 && index < limit) {
                        int adjusted;
                        BytesColumnVector cv = (BytesColumnVector)batch.cols[this.inputColumnNum[index]];
                        int n3 = adjusted = cv.isRepeating ? 0 : i;
                        if (!cv.isNull[adjusted]) {
                            outputVector.isNull[i] = false;
                            outputVector.setVal(i, cv.vector[adjusted], cv.start[adjusted], cv.length[adjusted]);
                            continue;
                        }
                        outputVector.isNull[i] = true;
                        outputVector.noNulls = false;
                        continue;
                    }
                    outputVector.isNull[i] = true;
                    outputVector.noNulls = false;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!inputIndexVector.isNull[i]) {
                    int index = (int)indexVector[i];
                    if (index > 0 && index < limit) {
                        int adjusted;
                        BytesColumnVector cv = (BytesColumnVector)batch.cols[this.inputColumnNum[index]];
                        int n4 = adjusted = cv.isRepeating ? 0 : i;
                        if (cv.noNulls || !cv.isNull[adjusted]) {
                            outputVector.isNull[i] = false;
                            outputVector.setVal(i, cv.vector[adjusted], cv.start[adjusted], cv.length[adjusted]);
                            continue;
                        }
                        outputVector.isNull[i] = true;
                        outputVector.noNulls = false;
                        continue;
                    }
                    outputVector.isNull[i] = true;
                    outputVector.noNulls = false;
                    continue;
                }
                outputVector.isNull[i] = true;
                outputVector.noNulls = false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!inputIndexVector.isNull[i]) {
                    int index = (int)indexVector[i];
                    if (index > 0 && index < limit) {
                        int adjusted;
                        BytesColumnVector cv = (BytesColumnVector)batch.cols[this.inputColumnNum[index]];
                        int n5 = adjusted = cv.isRepeating ? 0 : i;
                        if (cv.noNulls || !cv.isNull[adjusted]) {
                            outputVector.isNull[i] = false;
                            outputVector.setVal(i, cv.vector[adjusted], cv.start[adjusted], cv.length[adjusted]);
                            continue;
                        }
                        outputVector.isNull[i] = true;
                        outputVector.noNulls = false;
                        continue;
                    }
                    outputVector.isNull[i] = true;
                    outputVector.noNulls = false;
                    continue;
                }
                outputVector.isNull[i] = true;
                outputVector.noNulls = false;
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return "columns " + Arrays.toString(this.inputColumnNum);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        throw new UnsupportedOperationException("Undefined descriptor");
    }
}

