/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.function.drop;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.function.AbstractFunctionAnalyzer;
import org.apache.hadoop.hive.ql.ddl.function.drop.DropFunctionDesc;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1007})
public class DropFunctionAnalyzer
extends AbstractFunctionAnalyzer {
    public DropFunctionAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        String functionName = root.getChild(0).getText();
        boolean ifExists = root.getFirstChildWithType(1054) != null;
        boolean throwException = !ifExists && !HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.DROP_IGNORES_NON_EXISTENT);
        boolean isTemporary = root.getFirstChildWithType(1285) != null;
        FunctionInfo info = FunctionRegistry.getFunctionInfo(functionName);
        if (info == null) {
            if (throwException) {
                throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg(functionName));
            }
            return;
        }
        if (info.isBuiltIn()) {
            throw new SemanticException(ErrorMsg.DROP_NATIVE_FUNCTION.getMsg(functionName));
        }
        DropFunctionDesc desc = new DropFunctionDesc(functionName, isTemporary, null);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        this.addEntities(functionName, info.getClassName(), isTemporary, null);
    }
}

