/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.streaming;

import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hive.streaming.HiveStreamingConnection;
import org.apache.hive.streaming.InvalidTransactionState;
import org.apache.hive.streaming.RecordWriter;
import org.apache.hive.streaming.SerializationError;
import org.apache.hive.streaming.StreamingException;
import org.apache.hive.streaming.StreamingTransaction;

abstract class AbstractStreamingTransaction
implements StreamingTransaction {
    protected RecordWriter recordWriter;
    protected List<TxnToWriteId> txnToWriteIds;
    protected final AtomicBoolean isTxnClosed = new AtomicBoolean(false);
    protected int currentTxnIndex = -1;
    protected HiveStreamingConnection.TxnState state;

    AbstractStreamingTransaction() {
    }

    protected void checkIsClosed() throws StreamingException {
        if (this.isTxnClosed.get()) {
            throw new StreamingException("Transaction" + this.toString() + " is closed()");
        }
    }

    protected void beginNextTransactionImpl(String errorMessage) throws StreamingException {
        this.state = HiveStreamingConnection.TxnState.INACTIVE;
        if (this.currentTxnIndex + 1 >= this.txnToWriteIds.size()) {
            throw new InvalidTransactionState(errorMessage);
        }
        ++this.currentTxnIndex;
        this.state = HiveStreamingConnection.TxnState.OPEN;
    }

    @Override
    public void write(byte[] record) throws StreamingException {
        this.checkIsClosed();
        boolean success = false;
        try {
            this.recordWriter.write(this.getCurrentWriteId(), record);
            success = true;
        }
        catch (SerializationError ex) {
            success = true;
            throw ex;
        }
        finally {
            this.markDead(success);
        }
    }

    @Override
    public void write(InputStream inputStream) throws StreamingException {
        this.checkIsClosed();
        boolean success = false;
        try {
            this.recordWriter.write(this.getCurrentWriteId(), inputStream);
            success = true;
        }
        catch (SerializationError ex) {
            success = true;
            throw ex;
        }
        finally {
            this.markDead(success);
        }
    }

    protected void markDead(boolean success) throws StreamingException {
        if (success) {
            return;
        }
        this.close();
    }

    @Override
    public long getCurrentWriteId() {
        if (this.currentTxnIndex >= 0) {
            return this.txnToWriteIds.get(this.currentTxnIndex).getWriteId();
        }
        return -1L;
    }

    @Override
    public int remainingTransactions() {
        if (this.currentTxnIndex >= 0) {
            return this.txnToWriteIds.size() - this.currentTxnIndex - 1;
        }
        return this.txnToWriteIds.size();
    }

    @Override
    public boolean isClosed() {
        return this.isTxnClosed.get();
    }

    @Override
    public HiveStreamingConnection.TxnState getCurrentTransactionState() {
        return this.state;
    }

    @Override
    public long getCurrentTxnId() {
        if (this.currentTxnIndex >= 0) {
            return this.txnToWriteIds.get(this.currentTxnIndex).getTxnId();
        }
        return -1L;
    }

    @Override
    public List<TxnToWriteId> getTxnToWriteIds() {
        return this.txnToWriteIds;
    }

    @Override
    public void commit() throws StreamingException {
        this.commit(null);
    }

    @Override
    public void commit(Set<String> partitions) throws StreamingException {
        this.commit(partitions, null, null);
    }
}

