/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hive.org.apache.commons.lang3.StringUtils;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.exception.ClassAlreadyExistsException;
import org.jsonschema2pojo.exception.GenerationException;
import org.jsonschema2pojo.model.EnumDefinition;
import org.jsonschema2pojo.model.EnumDefinitionExtensionType;
import org.jsonschema2pojo.model.EnumValueDefinition;
import org.jsonschema2pojo.rules.DefaultRule;
import org.jsonschema2pojo.rules.PrimitiveTypes;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;
import org.jsonschema2pojo.util.TypeUtil;

public class EnumRule
implements Rule<JClassContainer, JType> {
    private static final String VALUE_FIELD_NAME = "value";
    private final RuleFactory ruleFactory;

    protected EnumRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JType apply(String nodeName, JsonNode node, JsonNode parent, JClassContainer container, Schema schema) {
        JDefinedClass _enum;
        try {
            _enum = this.createEnum(node, nodeName, container);
        }
        catch (ClassAlreadyExistsException e) {
            return e.getExistingClass();
        }
        schema.setJavaTypeIfEmpty(_enum);
        if (node.has("title")) {
            this.ruleFactory.getTitleRule().apply(nodeName, node.get("title"), node, _enum, schema);
        }
        if (node.has("description")) {
            this.ruleFactory.getDescriptionRule().apply(nodeName, node.get("description"), node, _enum, schema);
        }
        if (node.has("javaInterfaces")) {
            this.addInterfaces(_enum, node.get("javaInterfaces"));
        }
        ObjectNode typeNode = (ObjectNode)node.deepCopy();
        typeNode.remove("javaType");
        JClass backingType = node.has("type") ? this.ruleFactory.getTypeRule().apply(nodeName, (JsonNode)typeNode, parent, container, schema) : container.owner().ref(String.class);
        EnumDefinition enumDefinition = this.buildEnumDefinition(nodeName, node, backingType);
        JFieldVar valueField = this.addConstructorAndFields(enumDefinition, _enum);
        if (this.isString(backingType)) {
            this.addToString(_enum, valueField);
        }
        this.addFieldAccessors(_enum, valueField);
        this.addEnumConstants(enumDefinition, _enum, schema);
        this.addFactoryMethod(enumDefinition, _enum);
        this.applyCustomizations(enumDefinition, _enum);
        return _enum;
    }

    protected void addEnumConstants(EnumDefinition enumDefinition, JDefinedClass _enum, Schema schema) {
        JType type = enumDefinition.getBackingType();
        String nodeName = enumDefinition.getNodeName();
        JsonNode parentNode = enumDefinition.getEnumNode();
        for (EnumValueDefinition enumValueDefinition : enumDefinition.values()) {
            JEnumConstant constant = _enum.enumConstant(enumValueDefinition.getName());
            String value = enumValueDefinition.getValue();
            constant.arg(DefaultRule.getDefaultValue(type, value));
            Annotator annotator = this.ruleFactory.getAnnotator();
            annotator.enumConstant(_enum, constant, value);
            String enumNodeName = nodeName + "#" + value;
            if (enumValueDefinition.hasTitle()) {
                JsonNode titleNode = enumValueDefinition.getTitleNode();
                this.ruleFactory.getTitleRule().apply(enumNodeName, titleNode, parentNode, constant, schema);
            }
            if (!enumValueDefinition.hasDescription()) continue;
            JsonNode descriptionNode = enumValueDefinition.getDescriptionNode();
            this.ruleFactory.getDescriptionRule().apply(enumNodeName, descriptionNode, parentNode, constant, schema);
        }
    }

    protected void applyCustomizations(EnumDefinition enumDefinition, JDefinedClass _enum) {
    }

    protected EnumDefinition buildEnumDefinition(String nodeName, JsonNode node, JType backingType) {
        JsonNode enums = node.path("enum");
        JsonNode javaEnumNames = node.path("javaEnumNames");
        JsonNode javaEnums = node.path("javaEnums");
        if (!javaEnums.isMissingNode() && !javaEnumNames.isMissingNode()) {
            System.err.println("Both javaEnums and javaEnumNames provided; the property javaEnumNames will be ignored when both javaEnums and javaEnumNames are provided.");
        }
        if (!javaEnumNames.isMissingNode()) {
            System.err.println("javaEnumNames is deprecated; please migrate to javaEnums.");
        }
        EnumDefinition enumDefinition = !javaEnums.isMissingNode() ? this.buildEnumDefinitionWithJavaEnumsExtension(nodeName, node, enums, javaEnums, backingType) : (!javaEnumNames.isMissingNode() ? this.buildEnumDefinitionWithJavaEnumNamesExtension(nodeName, node, enums, javaEnumNames, backingType) : this.buildEnumDefinitionWithNoExtensions(nodeName, node, enums, backingType));
        return enumDefinition;
    }

    protected EnumDefinition buildEnumDefinitionWithNoExtensions(String nodeName, JsonNode parentNode, JsonNode enums, JType backingType) {
        ArrayList<EnumValueDefinition> enumValues = new ArrayList<EnumValueDefinition>();
        ArrayList<String> existingConstantNames = new ArrayList<String>();
        for (int i = 0; i < enums.size(); ++i) {
            JsonNode value = enums.path(i);
            if (value.isNull()) continue;
            String constantName = this.getConstantName(value.asText(), null);
            constantName = this.makeUnique(constantName, existingConstantNames);
            existingConstantNames.add(constantName);
            enumValues.add(new EnumValueDefinition(constantName, value.asText()));
        }
        return new EnumDefinition(nodeName, parentNode, backingType, enumValues, EnumDefinitionExtensionType.NONE);
    }

    protected EnumDefinition buildEnumDefinitionWithJavaEnumNamesExtension(String nodeName, JsonNode parentNode, JsonNode enums, JsonNode javaEnumNames, JType backingType) {
        ArrayList<EnumValueDefinition> enumValues = new ArrayList<EnumValueDefinition>();
        ArrayList<String> existingConstantNames = new ArrayList<String>();
        for (int i = 0; i < enums.size(); ++i) {
            JsonNode value = enums.path(i);
            if (value.isNull()) continue;
            String constantName = this.getConstantName(value.asText(), javaEnumNames.path(i).asText());
            constantName = this.makeUnique(constantName, existingConstantNames);
            existingConstantNames.add(constantName);
            enumValues.add(new EnumValueDefinition(constantName, value.asText(), javaEnumNames));
        }
        return new EnumDefinition(nodeName, parentNode, backingType, enumValues, EnumDefinitionExtensionType.JAVA_ENUM_NAMES);
    }

    protected EnumDefinition buildEnumDefinitionWithJavaEnumsExtension(String nodeName, JsonNode enumNode, JsonNode enums, JsonNode javaEnums, JType type) {
        ArrayList<EnumValueDefinition> enumValues = new ArrayList<EnumValueDefinition>();
        ArrayList<String> existingConstantNames = new ArrayList<String>();
        for (int i = 0; i < enums.size(); ++i) {
            JsonNode value = enums.path(i);
            if (value.isNull()) continue;
            JsonNode javaEnumNode = javaEnums.path(i);
            if (javaEnumNode.isMissingNode()) {
                System.err.println("javaEnum entry for " + value.asText() + " was not found.");
            }
            String constantName = this.getConstantName(value.asText(), javaEnumNode.path("name").asText());
            constantName = this.makeUnique(constantName, existingConstantNames);
            existingConstantNames.add(constantName);
            JsonNode titleNode = javaEnumNode.path("title");
            JsonNode descriptionNode = javaEnumNode.path("description");
            enumValues.add(new EnumValueDefinition(constantName, value.asText(), javaEnumNode, titleNode, descriptionNode));
        }
        return new EnumDefinition(nodeName, enumNode, type, enumValues, EnumDefinitionExtensionType.JAVA_ENUMS);
    }

    /*
     * Loose catch block
     */
    protected JDefinedClass createEnum(JsonNode node, String nodeName, JClassContainer container) throws ClassAlreadyExistsException {
        block8: {
            if (!node.has("javaType")) break block8;
            String fqn = node.get("javaType").asText();
            if (PrimitiveTypes.isPrimitive(fqn, container.owner())) {
                throw new GenerationException("Primitive type '" + fqn + "' cannot be used as an enum.");
            }
            try {
                Class<?> existingClass = Thread.currentThread().getContextClassLoader().loadClass(fqn);
                throw new ClassAlreadyExistsException(container.owner().ref(existingClass));
            }
            catch (ClassNotFoundException e) {
                return container.owner()._class(fqn, ClassType.ENUM);
            }
            {
                catch (JClassAlreadyExistsException e) {
                    throw new ClassAlreadyExistsException(e.getExistingClass());
                }
            }
        }
        try {
            return container._class(1, this.getEnumName(nodeName, node, container), ClassType.ENUM);
        }
        catch (JClassAlreadyExistsException e) {
            throw new GenerationException(e);
        }
    }

    protected JFieldVar addConstructorAndFields(EnumDefinition enumDefinition, JDefinedClass _enum) {
        JType backingType = enumDefinition.getBackingType();
        JFieldVar valueField = _enum.field(12, backingType, VALUE_FIELD_NAME);
        JMethod constructor = _enum.constructor(4);
        JVar valueParam = constructor.param(backingType, VALUE_FIELD_NAME);
        JBlock body = constructor.body();
        body.assign(JExpr._this().ref(valueField), valueParam);
        return valueField;
    }

    protected void addFactoryMethod(EnumDefinition enumDefinition, JDefinedClass _enum) {
        JType backingType = enumDefinition.getBackingType();
        JFieldVar quickLookupMap = this.addQuickLookupMap(enumDefinition, _enum);
        JMethod fromValue = _enum.method(17, _enum, "fromValue");
        JVar valueParam = fromValue.param(backingType, VALUE_FIELD_NAME);
        JBlock body = fromValue.body();
        JVar constant = body.decl(_enum, "constant");
        constant.init(quickLookupMap.invoke("get").arg(valueParam));
        JConditional _if = body._if(constant.eq(JExpr._null()));
        JInvocation illegalArgumentException = JExpr._new(_enum.owner().ref(IllegalArgumentException.class));
        JExpression expr = valueParam;
        if (!this.isString(backingType)) {
            expr = expr.plus(JExpr.lit(""));
        }
        illegalArgumentException.arg(expr);
        _if._then()._throw(illegalArgumentException);
        _if._else()._return(constant);
        this.ruleFactory.getAnnotator().enumCreatorMethod(_enum, fromValue);
    }

    protected void addFieldAccessors(JDefinedClass _enum, JFieldVar valueField) {
        JMethod fromValue = _enum.method(1, valueField.type(), VALUE_FIELD_NAME);
        JBlock body = fromValue.body();
        body._return(JExpr._this().ref(valueField));
        this.ruleFactory.getAnnotator().enumValueMethod(_enum, fromValue);
    }

    protected JFieldVar addQuickLookupMap(EnumDefinition enumDefinition, JDefinedClass _enum) {
        JType backingType = enumDefinition.getBackingType();
        JClass lookupType = _enum.owner().ref(Map.class).narrow(backingType.boxify(), _enum);
        JFieldVar lookupMap = _enum.field(28, lookupType, "CONSTANTS");
        JClass lookupImplType = _enum.owner().ref(HashMap.class).narrow(backingType.boxify(), _enum);
        lookupMap.init(JExpr._new(lookupImplType));
        JForEach forEach = _enum.init().forEach(_enum, "c", JExpr.invoke("values"));
        JInvocation put = forEach.body().invoke((JExpression)lookupMap, "put");
        put.arg(forEach.var().ref(VALUE_FIELD_NAME));
        put.arg(forEach.var());
        return lookupMap;
    }

    protected void addToString(JDefinedClass _enum, JFieldVar valueField) {
        JMethod toString = _enum.method(1, String.class, "toString");
        JBlock body = toString.body();
        JExpression toReturn = JExpr._this().ref(valueField);
        if (!this.isString(valueField.type())) {
            toReturn = toReturn.plus(JExpr.lit(""));
        }
        body._return(toReturn);
        toString.annotate(Override.class);
    }

    protected boolean isString(JType type) {
        return type.fullName().equals(String.class.getName());
    }

    protected String getEnumName(String nodeName, JsonNode node, JClassContainer container) {
        String fieldName = this.ruleFactory.getNameHelper().getClassName(nodeName, node);
        String className = this.ruleFactory.getNameHelper().replaceIllegalCharacters(StringUtils.capitalize(fieldName));
        String normalizedName = this.ruleFactory.getNameHelper().normalizeName(className);
        ArrayList<String> existingClassNames = new ArrayList<String>();
        Iterator<JDefinedClass> classes = container.classes();
        while (classes.hasNext()) {
            existingClassNames.add(classes.next().name());
        }
        return this.makeUnique(normalizedName, existingClassNames);
    }

    protected String makeUnique(String name, Collection<String> existingNames) {
        boolean found = false;
        for (String existingName : existingNames) {
            if (!name.equalsIgnoreCase(existingName)) continue;
            found = true;
            break;
        }
        if (found) {
            String newName = this.makeUnique(name + "_", existingNames);
            System.err.println("Enum name " + name + " already used; trying to replace it with " + newName);
            return newName;
        }
        return name;
    }

    protected String getConstantName(String nodeName, String customName) {
        if (StringUtils.isNotBlank(customName)) {
            return customName;
        }
        ArrayList<String> enumNameGroups = new ArrayList<String>(Arrays.asList(StringUtils.splitByCharacterTypeCamelCase(nodeName)));
        String enumName = "";
        Iterator iter = enumNameGroups.iterator();
        while (iter.hasNext()) {
            if (!StringUtils.containsOnly((CharSequence)this.ruleFactory.getNameHelper().replaceIllegalCharacters((String)iter.next()), "_")) continue;
            iter.remove();
        }
        enumName = StringUtils.upperCase(StringUtils.join(enumNameGroups, "_"));
        if (StringUtils.isEmpty(enumName)) {
            enumName = "__EMPTY__";
        } else if (Character.isDigit(enumName.charAt(0))) {
            enumName = "_" + enumName;
        }
        return enumName;
    }

    protected void addInterfaces(JDefinedClass jclass, JsonNode javaInterfaces) {
        for (JsonNode i : javaInterfaces) {
            jclass._implements(TypeUtil.resolveType(jclass._package(), i.asText()));
        }
    }
}

