/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.manager;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.Objects;
import org.apache.hertzbeat.common.constants.PluginType;
import org.apache.hertzbeat.common.entity.manager.PluginMetadata;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_plugin_item")
@Schema(description="PluginItem Entity")
@EntityListeners(value={AuditingEntityListener.class})
public class PluginItem {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="Plugin Primary key index ID", example="87584674384", accessMode=Schema.AccessMode.READ_ONLY)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="metadata_id")
    @JsonIgnore
    private PluginMetadata pluginMetadata;
    @Schema(title="Plugin implementation class full path", example="org.apache.hertzbeat.plugin.impl.DemoPluginImpl", accessMode=Schema.AccessMode.READ_WRITE)
    private String classIdentifier;
    @Schema(title="Plugin type", example="POST_ALERT", accessMode=Schema.AccessMode.READ_WRITE)
    @Enumerated(value=EnumType.STRING)
    private PluginType type;

    public PluginItem(String classIdentifier, PluginType type) {
        this.classIdentifier = classIdentifier;
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginItem that = (PluginItem)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.classIdentifier, that.classIdentifier) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.classIdentifier, this.type});
    }

    public static PluginItemBuilder builder() {
        return new PluginItemBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public PluginMetadata getPluginMetadata() {
        return this.pluginMetadata;
    }

    public String getClassIdentifier() {
        return this.classIdentifier;
    }

    public PluginType getType() {
        return this.type;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setPluginMetadata(PluginMetadata pluginMetadata) {
        this.pluginMetadata = pluginMetadata;
    }

    public void setClassIdentifier(String classIdentifier) {
        this.classIdentifier = classIdentifier;
    }

    public void setType(PluginType type) {
        this.type = type;
    }

    public String toString() {
        return "PluginItem(id=" + this.getId() + ", pluginMetadata=" + this.getPluginMetadata() + ", classIdentifier=" + this.getClassIdentifier() + ", type=" + this.getType() + ")";
    }

    public PluginItem(Long id, PluginMetadata pluginMetadata, String classIdentifier, PluginType type) {
        this.id = id;
        this.pluginMetadata = pluginMetadata;
        this.classIdentifier = classIdentifier;
        this.type = type;
    }

    public PluginItem() {
    }

    public static class PluginItemBuilder {
        private Long id;
        private PluginMetadata pluginMetadata;
        private String classIdentifier;
        private PluginType type;

        PluginItemBuilder() {
        }

        public PluginItemBuilder id(Long id) {
            this.id = id;
            return this;
        }

        @JsonIgnore
        public PluginItemBuilder pluginMetadata(PluginMetadata pluginMetadata) {
            this.pluginMetadata = pluginMetadata;
            return this;
        }

        public PluginItemBuilder classIdentifier(String classIdentifier) {
            this.classIdentifier = classIdentifier;
            return this;
        }

        public PluginItemBuilder type(PluginType type) {
            this.type = type;
            return this;
        }

        public PluginItem build() {
            return new PluginItem(this.id, this.pluginMetadata, this.classIdentifier, this.type);
        }

        public String toString() {
            return "PluginItem.PluginItemBuilder(id=" + this.id + ", pluginMetadata=" + this.pluginMetadata + ", classIdentifier=" + this.classIdentifier + ", type=" + this.type + ")";
        }
    }
}

