/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.capi;

import com.mongodb.AwsCredential;
import com.mongodb.Block;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientException;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoConfigurationException;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.crypt.capi.MongoCryptOptions;
import com.mongodb.internal.authentication.AwsCredentialHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.Encoder;

public final class MongoCryptHelper {
    public static MongoCryptOptions createMongoCryptOptions(Map<String, Map<String, Object>> kmsProviders, Map<String, BsonDocument> namespaceToLocalSchemaDocumentMap) {
        MongoCryptOptions.Builder mongoCryptOptionsBuilder = MongoCryptOptions.builder();
        BsonDocument bsonKmsProviders = MongoCryptHelper.getKmsProvidersAsBsonDocument(kmsProviders);
        mongoCryptOptionsBuilder.kmsProviderOptions(bsonKmsProviders);
        mongoCryptOptionsBuilder.localSchemaMap(namespaceToLocalSchemaDocumentMap);
        mongoCryptOptionsBuilder.needsKmsCredentialsStateEnabled(true);
        return mongoCryptOptionsBuilder.build();
    }

    public static BsonDocument fetchCredentials(Map<String, Map<String, Object>> kmsProviders, Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers) {
        AwsCredential awsCredential;
        BsonDocument kmsProvidersDocument = MongoCryptHelper.getKmsProvidersAsBsonDocument(kmsProviders);
        for (Map.Entry<String, Supplier<Map<String, Object>>> entry : kmsProviderPropertySuppliers.entrySet()) {
            Map<String, Object> kmsProviderCredential;
            String kmsProviderName = entry.getKey();
            if (!kmsProvidersDocument.get((Object)kmsProviderName).asDocument().isEmpty()) continue;
            try {
                kmsProviderCredential = entry.getValue().get();
            }
            catch (Exception e) {
                throw new MongoConfigurationException(String.format("Exception getting credential for kms provider %s from configured Supplier.", kmsProviderName), e);
            }
            if (kmsProviderCredential == null || kmsProviderCredential.isEmpty()) {
                throw new MongoConfigurationException(String.format("Exception getting credential for kms provider %s from configured Supplier. The returned value is %s.", kmsProviderName, kmsProviderCredential == null ? "null" : "empty"));
            }
            MongoCryptHelper.addToKmsProviderDocument(kmsProvidersDocument, kmsProviderName, kmsProviderCredential);
        }
        if (kmsProvidersDocument.containsKey((Object)"aws") && kmsProvidersDocument.get((Object)"aws").asDocument().isEmpty() && (awsCredential = AwsCredentialHelper.obtainFromEnvironment()) != null) {
            BsonDocument awsCredentialDocument = new BsonDocument();
            awsCredentialDocument.put("accessKeyId", (BsonValue)new BsonString(awsCredential.getAccessKeyId()));
            awsCredentialDocument.put("secretAccessKey", (BsonValue)new BsonString(awsCredential.getSecretAccessKey()));
            if (awsCredential.getSessionToken() != null) {
                awsCredentialDocument.put("sessionToken", (BsonValue)new BsonString(awsCredential.getSessionToken()));
            }
            kmsProvidersDocument.put("aws", (BsonValue)awsCredentialDocument);
        }
        return kmsProvidersDocument;
    }

    private static BsonDocument getKmsProvidersAsBsonDocument(Map<String, Map<String, Object>> kmsProviders) {
        BsonDocument bsonKmsProviders = new BsonDocument();
        for (Map.Entry<String, Map<String, Object>> entry : kmsProviders.entrySet()) {
            MongoCryptHelper.addToKmsProviderDocument(bsonKmsProviders, entry.getKey(), entry.getValue());
        }
        return bsonKmsProviders;
    }

    private static void addToKmsProviderDocument(BsonDocument kmsProvidersDocument, String kmsProvider, Map<String, Object> kmsProviderCredential) {
        kmsProvidersDocument.put(kmsProvider, (BsonValue)new BsonDocumentWrapper((Object)new Document(kmsProviderCredential), (Encoder)new DocumentCodec()));
    }

    public static List<String> createMongocryptdSpawnArgs(Map<String, Object> options) {
        ArrayList<String> spawnArgs = new ArrayList<String>();
        String path = options.containsKey("mongocryptdSpawnPath") ? (String)options.get("mongocryptdSpawnPath") : "mongocryptd";
        spawnArgs.add(path);
        if (options.containsKey("mongocryptdSpawnArgs")) {
            spawnArgs.addAll((List)options.get("mongocryptdSpawnArgs"));
        }
        if (!spawnArgs.contains("--idleShutdownTimeoutSecs")) {
            spawnArgs.add("--idleShutdownTimeoutSecs");
            spawnArgs.add("60");
        }
        return spawnArgs;
    }

    public static MongoClientSettings createMongocryptdClientSettings(String connectionString) {
        return MongoClientSettings.builder().applyToClusterSettings(new Block<ClusterSettings.Builder>(){

            @Override
            public void apply(ClusterSettings.Builder builder) {
                builder.serverSelectionTimeout(10L, TimeUnit.SECONDS);
            }
        }).applyToSocketSettings(new Block<SocketSettings.Builder>(){

            @Override
            public void apply(SocketSettings.Builder builder) {
                builder.readTimeout(10, TimeUnit.SECONDS);
                builder.connectTimeout(10, TimeUnit.SECONDS);
            }
        }).applyConnectionString(new ConnectionString(connectionString != null ? connectionString : "mongodb://localhost:27020")).build();
    }

    public static ProcessBuilder createProcessBuilder(Map<String, Object> options) {
        return new ProcessBuilder(MongoCryptHelper.createMongocryptdSpawnArgs(options));
    }

    public static void startProcess(ProcessBuilder processBuilder) {
        try {
            processBuilder.redirectErrorStream(true);
            processBuilder.redirectOutput(new File(System.getProperty("os.name").startsWith("Windows") ? "NUL" : "/dev/null"));
            processBuilder.start();
        }
        catch (Throwable t) {
            throw new MongoClientException("Exception starting mongocryptd process. Is `mongocryptd` on the system path?", t);
        }
    }

    private MongoCryptHelper() {
    }
}

