/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.Value;
import com.vesoft.nebula.meta.ConfigMode;
import com.vesoft.nebula.meta.ConfigModule;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ConfigItem
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("ConfigItem");
    private static final TField MODULE_FIELD_DESC = new TField("module", 8, 1);
    private static final TField NAME_FIELD_DESC = new TField("name", 11, 2);
    private static final TField MODE_FIELD_DESC = new TField("mode", 8, 3);
    private static final TField VALUE_FIELD_DESC = new TField("value", 12, 4);
    public ConfigModule module;
    public byte[] name;
    public ConfigMode mode;
    public Value value;
    public static final int MODULE = 1;
    public static final int NAME = 2;
    public static final int MODE = 3;
    public static final int VALUE = 4;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public ConfigItem() {
    }

    public ConfigItem(ConfigModule module, byte[] name, ConfigMode mode, Value value) {
        this();
        this.module = module;
        this.name = name;
        this.mode = mode;
        this.value = value;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ConfigItem(ConfigItem other) {
        if (other.isSetModule()) {
            this.module = TBaseHelper.deepCopy(other.module);
        }
        if (other.isSetName()) {
            this.name = TBaseHelper.deepCopy(other.name);
        }
        if (other.isSetMode()) {
            this.mode = TBaseHelper.deepCopy(other.mode);
        }
        if (other.isSetValue()) {
            this.value = TBaseHelper.deepCopy(other.value);
        }
    }

    @Override
    public ConfigItem deepCopy() {
        return new ConfigItem(this);
    }

    public ConfigModule getModule() {
        return this.module;
    }

    public ConfigItem setModule(ConfigModule module) {
        this.module = module;
        return this;
    }

    public void unsetModule() {
        this.module = null;
    }

    public boolean isSetModule() {
        return this.module != null;
    }

    public void setModuleIsSet(boolean __value) {
        if (!__value) {
            this.module = null;
        }
    }

    public byte[] getName() {
        return this.name;
    }

    public ConfigItem setName(byte[] name) {
        this.name = name;
        return this;
    }

    public void unsetName() {
        this.name = null;
    }

    public boolean isSetName() {
        return this.name != null;
    }

    public void setNameIsSet(boolean __value) {
        if (!__value) {
            this.name = null;
        }
    }

    public ConfigMode getMode() {
        return this.mode;
    }

    public ConfigItem setMode(ConfigMode mode) {
        this.mode = mode;
        return this;
    }

    public void unsetMode() {
        this.mode = null;
    }

    public boolean isSetMode() {
        return this.mode != null;
    }

    public void setModeIsSet(boolean __value) {
        if (!__value) {
            this.mode = null;
        }
    }

    public Value getValue() {
        return this.value;
    }

    public ConfigItem setValue(Value value) {
        this.value = value;
        return this;
    }

    public void unsetValue() {
        this.value = null;
    }

    public boolean isSetValue() {
        return this.value != null;
    }

    public void setValueIsSet(boolean __value) {
        if (!__value) {
            this.value = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetModule();
                    break;
                }
                this.setModule((ConfigModule)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetName();
                    break;
                }
                this.setName((byte[])__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetMode();
                    break;
                }
                this.setMode((ConfigMode)__value);
                break;
            }
            case 4: {
                if (__value == null) {
                    this.unsetValue();
                    break;
                }
                this.setValue((Value)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getModule();
            }
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.getMode();
            }
            case 4: {
                return this.getValue();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof ConfigItem)) {
            return false;
        }
        ConfigItem that = (ConfigItem)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetModule(), that.isSetModule(), this.module, that.module)) {
            return false;
        }
        if (!TBaseHelper.equalsSlow(this.isSetName(), that.isSetName(), this.name, that.name)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetMode(), that.isSetMode(), this.mode, that.mode)) {
            return false;
        }
        return TBaseHelper.equalsNobinary(this.isSetValue(), that.isSetValue(), this.value, that.value);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.module, this.name, this.mode, this.value});
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 8) {
                        this.module = ConfigModule.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 11) {
                        this.name = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 8) {
                        this.mode = ConfigMode.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 4: {
                    if (__field.type == 12) {
                        this.value = new Value();
                        this.value.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.module != null) {
            oprot.writeFieldBegin(MODULE_FIELD_DESC);
            oprot.writeI32(this.module == null ? 0 : this.module.getValue());
            oprot.writeFieldEnd();
        }
        if (this.name != null) {
            oprot.writeFieldBegin(NAME_FIELD_DESC);
            oprot.writeBinary(this.name);
            oprot.writeFieldEnd();
        }
        if (this.mode != null) {
            oprot.writeFieldBegin(MODE_FIELD_DESC);
            oprot.writeI32(this.mode == null ? 0 : this.mode.getValue());
            oprot.writeFieldEnd();
        }
        if (this.value != null) {
            oprot.writeFieldBegin(VALUE_FIELD_DESC);
            this.value.write(oprot);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("ConfigItem");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("module");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getModule() == null) {
            sb.append("null");
        } else {
            String module_name;
            String string = module_name = this.getModule() == null ? "null" : this.getModule().name();
            if (module_name != null) {
                sb.append(module_name);
                sb.append(" (");
            }
            sb.append(this.getModule());
            if (module_name != null) {
                sb.append(")");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("name");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getName() == null) {
            sb.append("null");
        } else {
            int __name_size = Math.min(this.getName().length, 128);
            for (int i = 0; i < __name_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getName()[i]).length() > 1 ? Integer.toHexString(this.getName()[i]).substring(Integer.toHexString(this.getName()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getName()[i]).toUpperCase());
            }
            if (this.getName().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("mode");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getMode() == null) {
            sb.append("null");
        } else {
            String mode_name;
            String string = mode_name = this.getMode() == null ? "null" : this.getMode().name();
            if (mode_name != null) {
                sb.append(mode_name);
                sb.append(" (");
            }
            sb.append(this.getMode());
            if (mode_name != null) {
                sb.append(")");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("value");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getValue() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getValue(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("module", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("name", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(3, new FieldMetaData("mode", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(4, new FieldMetaData("value", 3, new StructMetaData(12, Value.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(ConfigItem.class, metaDataMap);
    }

    public static class Builder {
        private ConfigModule module;
        private byte[] name;
        private ConfigMode mode;
        private Value value;

        public Builder setModule(ConfigModule module) {
            this.module = module;
            return this;
        }

        public Builder setName(byte[] name) {
            this.name = name;
            return this;
        }

        public Builder setMode(ConfigMode mode) {
            this.mode = mode;
            return this;
        }

        public Builder setValue(Value value) {
            this.value = value;
            return this;
        }

        public ConfigItem build() {
            ConfigItem result = new ConfigItem();
            result.setModule(this.module);
            result.setName(this.name);
            result.setMode(this.mode);
            result.setValue(this.value);
            return result;
        }
    }
}

