/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.tracing;

import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.tracing.TraceContext;
import io.lettuce.core.tracing.TraceContextProvider;
import io.lettuce.core.tracing.Tracer;
import io.lettuce.core.tracing.TracerProvider;
import io.lettuce.core.tracing.Tracing;
import java.net.SocketAddress;

enum NoOpTracing implements Tracing,
TraceContextProvider,
TracerProvider
{
    INSTANCE;

    private final Tracing.Endpoint NOOP_ENDPOINT = new Tracing.Endpoint(){};

    @Override
    public TraceContext getTraceContext() {
        return TraceContext.EMPTY;
    }

    @Override
    public Tracer getTracer() {
        return NoOpTracer.INSTANCE;
    }

    @Override
    public TracerProvider getTracerProvider() {
        return this;
    }

    @Override
    public TraceContextProvider initialTraceContextProvider() {
        return this;
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    @Override
    public boolean includeCommandArgsInSpanTags() {
        return false;
    }

    @Override
    public Tracing.Endpoint createEndpoint(SocketAddress socketAddress) {
        return this.NOOP_ENDPOINT;
    }

    public static class NoOpSpan
    extends Tracer.Span {
        static final NoOpSpan INSTANCE = new NoOpSpan();

        @Override
        public Tracer.Span start(RedisCommand<?, ?, ?> command) {
            return this;
        }

        @Override
        public Tracer.Span name(String name) {
            return this;
        }

        @Override
        public Tracer.Span annotate(String value) {
            return this;
        }

        @Override
        public Tracer.Span tag(String key, String value) {
            return this;
        }

        @Override
        public Tracer.Span error(Throwable throwable) {
            return this;
        }

        @Override
        public Tracer.Span remoteEndpoint(Tracing.Endpoint endpoint) {
            return this;
        }

        @Override
        public void finish() {
        }
    }

    static class NoOpTracer
    extends Tracer {
        static final Tracer INSTANCE = new NoOpTracer();

        NoOpTracer() {
        }

        @Override
        public Tracer.Span nextSpan(TraceContext traceContext) {
            return NoOpSpan.INSTANCE;
        }

        @Override
        public Tracer.Span nextSpan() {
            return NoOpSpan.INSTANCE;
        }
    }
}

