/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.data.redis;

import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.data.redis.RedisReactiveHealthContributorAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthContributorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.data.redis.RedisHealthIndicator;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@AutoConfiguration(after={RedisAutoConfiguration.class, RedisReactiveHealthContributorAutoConfiguration.class})
@ConditionalOnClass(value={RedisConnectionFactory.class})
@ConditionalOnBean(value={RedisConnectionFactory.class})
@ConditionalOnEnabledHealthIndicator(value="redis")
public class RedisHealthContributorAutoConfiguration
extends CompositeHealthContributorConfiguration<RedisHealthIndicator, RedisConnectionFactory> {
    RedisHealthContributorAutoConfiguration() {
        super(RedisHealthIndicator::new);
    }

    @Bean
    @ConditionalOnMissingBean(name={"redisHealthIndicator", "redisHealthContributor"})
    public HealthContributor redisHealthContributor(Map<String, RedisConnectionFactory> redisConnectionFactories) {
        return (HealthContributor)this.createContributor(redisConnectionFactories);
    }
}

