/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderWriterArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.utils.Serializable;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcStruct;

public class DefaultPlcReadResponse
implements PlcReadResponse,
Serializable {
    private final PlcReadRequest request;
    private final Map<String, ResponseItem<PlcValue>> values;

    public DefaultPlcReadResponse(PlcReadRequest request, Map<String, ResponseItem<PlcValue>> values) {
        this.request = request;
        this.values = values;
    }

    public PlcReadRequest getRequest() {
        return this.request;
    }

    public PlcValue getAsPlcValue() {
        HashMap<String, PlcValue> structMap = new HashMap<String, PlcValue>();
        for (String tagName : this.request.getTagNames()) {
            PlcValue plcValue = this.getPlcValue(tagName);
            structMap.put(tagName, plcValue);
        }
        return new PlcStruct(structMap);
    }

    public PlcValue getPlcValue(String name) {
        return this.values.getOrDefault(name, new ResponseItem<Object>(null, null)).getValue();
    }

    public int getNumberOfValues(String name) {
        PlcValue tagInternal = this.getTagInternal(name);
        if (tagInternal instanceof PlcList) {
            PlcList plcList = (PlcList)tagInternal;
            return plcList.getLength();
        }
        return 1;
    }

    public Collection<String> getTagNames() {
        return this.request.getTagNames();
    }

    public PlcTag getTag(String name) {
        return this.request.getTag(name);
    }

    public PlcResponseCode getResponseCode(String name) {
        if (this.values.get(name) == null) {
            throw new PlcInvalidTagException(name);
        }
        return this.values.get(name).getCode();
    }

    public Map<String, ResponseItem<PlcValue>> getValues() {
        return this.values;
    }

    public Object getObject(String name) {
        if (this.getTagInternal(name) != null) {
            return this.getTagInternal(name).getObject();
        }
        return null;
    }

    public Object getObject(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        if (tagInternal != null) {
            return tagInternal.getObject();
        }
        return null;
    }

    public Collection<Object> getAllObjects(String name) {
        PlcValue tagInternal = this.getTagInternal(name);
        if (tagInternal instanceof PlcList) {
            PlcList plcList = (PlcList)tagInternal;
            ArrayList<Object> items = new ArrayList<Object>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getObject());
            }
            return items;
        }
        return Collections.singletonList(tagInternal.getObject());
    }

    public boolean isValidBoolean(String name) {
        return this.isValidBoolean(name, 0);
    }

    public boolean isValidBoolean(String name, int index) {
        PlcValue tagInternal = this.getTagInternal(name);
        return tagInternal.isBoolean();
    }

    public Boolean getBoolean(String name) {
        return this.getBoolean(name, 0);
    }

    public Boolean getBoolean(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return tagInternal.getBoolean();
    }

    public Collection<Boolean> getAllBooleans(String name) {
        PlcValue tagInternal = this.getTagInternal(name);
        if (tagInternal instanceof PlcList) {
            PlcList plcList = (PlcList)tagInternal;
            ArrayList<Boolean> items = new ArrayList<Boolean>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getBoolean());
            }
            return items;
        }
        return Collections.singletonList(tagInternal.getBoolean());
    }

    public boolean isValidByte(String name) {
        return this.isValidByte(name, 0);
    }

    public boolean isValidByte(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return tagInternal.isByte();
    }

    public Byte getByte(String name) {
        return this.getByte(name, 0);
    }

    public Byte getByte(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return tagInternal.getByte();
    }

    public Collection<Byte> getAllBytes(String name) {
        PlcValue tagInternal = this.getTagInternal(name);
        if (tagInternal instanceof PlcList) {
            PlcList plcList = (PlcList)tagInternal;
            ArrayList<Byte> items = new ArrayList<Byte>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getByte());
            }
            return items;
        }
        return Collections.singletonList(tagInternal.getByte());
    }

    public boolean isValidShort(String name) {
        return this.isValidShort(name, 0);
    }

    public boolean isValidShort(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return tagInternal.isShort();
    }

    public Short getShort(String name) {
        return this.getShort(name, 0);
    }

    public Short getShort(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return tagInternal.getShort();
    }

    public Collection<Short> getAllShorts(String name) {
        PlcValue tagInternal = this.getTagInternal(name);
        if (tagInternal instanceof PlcList) {
            PlcList plcList = (PlcList)tagInternal;
            ArrayList<Short> items = new ArrayList<Short>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getShort());
            }
            return items;
        }
        return Collections.singletonList(tagInternal.getShort());
    }

    public boolean isValidInteger(String name) {
        return this.isValidInteger(name, 0);
    }

    public boolean isValidInteger(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return tagInternal.isInteger();
    }

    public Integer getInteger(String name) {
        return this.getInteger(name, 0);
    }

    public Integer getInteger(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return tagInternal.getInteger();
    }

    public Collection<Integer> getAllIntegers(String name) {
        PlcValue tagInternal = this.getTagInternal(name);
        if (tagInternal instanceof PlcList) {
            PlcList plcList = (PlcList)tagInternal;
            ArrayList<Integer> items = new ArrayList<Integer>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getInteger());
            }
            return items;
        }
        return Collections.singletonList(tagInternal.getInteger());
    }

    public boolean isValidBigInteger(String name) {
        return this.isValidBigInteger(name, 0);
    }

    public boolean isValidBigInteger(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return tagInternal.isBigInteger();
    }

    public BigInteger getBigInteger(String name) {
        return this.getBigInteger(name, 0);
    }

    public BigInteger getBigInteger(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return tagInternal.getBigInteger();
    }

    public Collection<BigInteger> getAllBigIntegers(String name) {
        PlcValue tagInternal = this.getTagInternal(name);
        if (tagInternal instanceof PlcList) {
            PlcList plcList = (PlcList)tagInternal;
            ArrayList<BigInteger> items = new ArrayList<BigInteger>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getBigInteger());
            }
            return items;
        }
        return Collections.singletonList(tagInternal.getBigInteger());
    }

    public boolean isValidLong(String name) {
        return this.isValidLong(name, 0);
    }

    public boolean isValidLong(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return tagInternal.isLong();
    }

    public Long getLong(String name) {
        return this.getLong(name, 0);
    }

    public Long getLong(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return tagInternal.getLong();
    }

    public Collection<Long> getAllLongs(String name) {
        PlcValue tagInternal = this.getTagInternal(name);
        if (tagInternal instanceof PlcList) {
            PlcList plcList = (PlcList)tagInternal;
            ArrayList<Long> items = new ArrayList<Long>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getLong());
            }
            return items;
        }
        return Collections.singletonList(tagInternal.getLong());
    }

    public boolean isValidFloat(String name) {
        return this.isValidFloat(name, 0);
    }

    public boolean isValidFloat(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return tagInternal.isFloat();
    }

    public Float getFloat(String name) {
        return this.getFloat(name, 0);
    }

    public Float getFloat(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return Float.valueOf(tagInternal.getFloat());
    }

    public Collection<Float> getAllFloats(String name) {
        PlcValue tagInternal = this.getTagInternal(name);
        if (tagInternal instanceof PlcList) {
            PlcList plcList = (PlcList)tagInternal;
            ArrayList<Float> items = new ArrayList<Float>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(Float.valueOf(plcValue.getFloat()));
            }
            return items;
        }
        return Collections.singletonList(Float.valueOf(tagInternal.getFloat()));
    }

    public boolean isValidDouble(String name) {
        return this.isValidDouble(name, 0);
    }

    public boolean isValidDouble(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return tagInternal.isDouble();
    }

    public Double getDouble(String name) {
        return this.getDouble(name, 0);
    }

    public Double getDouble(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return tagInternal.getDouble();
    }

    public Collection<Double> getAllDoubles(String name) {
        PlcValue tagInternal = this.getTagInternal(name);
        if (tagInternal instanceof PlcList) {
            PlcList plcList = (PlcList)tagInternal;
            ArrayList<Double> items = new ArrayList<Double>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getDouble());
            }
            return items;
        }
        return Collections.singletonList(tagInternal.getDouble());
    }

    public boolean isValidBigDecimal(String name) {
        return this.isValidBigDecimal(name, 0);
    }

    public boolean isValidBigDecimal(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return tagInternal.isBigDecimal();
    }

    public BigDecimal getBigDecimal(String name) {
        return this.getBigDecimal(name, 0);
    }

    public BigDecimal getBigDecimal(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return tagInternal.getBigDecimal();
    }

    public Collection<BigDecimal> getAllBigDecimals(String name) {
        PlcValue tagInternal = this.getTagInternal(name);
        if (tagInternal instanceof PlcList) {
            PlcList plcList = (PlcList)tagInternal;
            ArrayList<BigDecimal> items = new ArrayList<BigDecimal>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getBigDecimal());
            }
            return items;
        }
        return Collections.singletonList(tagInternal.getBigDecimal());
    }

    public boolean isValidString(String name) {
        return this.isValidString(name, 0);
    }

    public boolean isValidString(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return tagInternal.isString();
    }

    public String getString(String name) {
        return this.getString(name, 0);
    }

    public String getString(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return tagInternal.getString();
    }

    public Collection<String> getAllStrings(String name) {
        PlcValue tagInternal = this.getTagInternal(name);
        if (tagInternal instanceof PlcList) {
            PlcList plcList = (PlcList)tagInternal;
            ArrayList<String> items = new ArrayList<String>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getString());
            }
            return items;
        }
        return Collections.singletonList(tagInternal.getString());
    }

    public boolean isValidTime(String name) {
        return this.isValidTime(name, 0);
    }

    public boolean isValidTime(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return tagInternal.isTime();
    }

    public LocalTime getTime(String name) {
        return this.getTime(name, 0);
    }

    public LocalTime getTime(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return tagInternal.getTime();
    }

    public Collection<LocalTime> getAllTimes(String name) {
        PlcValue tagInternal = this.getTagInternal(name);
        if (tagInternal instanceof PlcList) {
            PlcList plcList = (PlcList)tagInternal;
            ArrayList<LocalTime> items = new ArrayList<LocalTime>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getTime());
            }
            return items;
        }
        return Collections.singletonList(tagInternal.getTime());
    }

    public boolean isValidDate(String name) {
        return this.isValidDate(name, 0);
    }

    public boolean isValidDate(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return tagInternal.isDate();
    }

    public LocalDate getDate(String name) {
        return this.getDate(name, 0);
    }

    public LocalDate getDate(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return tagInternal.getDate();
    }

    public Collection<LocalDate> getAllDates(String name) {
        PlcValue tagInternal = this.getTagInternal(name);
        if (tagInternal instanceof PlcList) {
            PlcList plcList = (PlcList)tagInternal;
            ArrayList<LocalDate> items = new ArrayList<LocalDate>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getDate());
            }
            return items;
        }
        return Collections.singletonList(tagInternal.getDate());
    }

    public boolean isValidDateTime(String name) {
        return this.isValidDateTime(name, 0);
    }

    public boolean isValidDateTime(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return tagInternal.isDateTime();
    }

    public LocalDateTime getDateTime(String name) {
        return this.getDateTime(name, 0);
    }

    public LocalDateTime getDateTime(String name, int index) {
        PlcValue tagInternal = this.getTagIndexInternal(name, index);
        return tagInternal.getDateTime();
    }

    public Collection<LocalDateTime> getAllDateTimes(String name) {
        PlcValue tagInternal = this.getTagInternal(name);
        if (tagInternal instanceof PlcList) {
            PlcList plcList = (PlcList)tagInternal;
            ArrayList<LocalDateTime> items = new ArrayList<LocalDateTime>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getDateTime());
            }
            return items;
        }
        return Collections.singletonList(tagInternal.getDateTime());
    }

    public void add(String key, ResponseItem<PlcValue> value) {
        this.values.put(key, value);
    }

    public Map<String, ResponseItem<PlcValue>> getMap() {
        return this.values;
    }

    protected PlcValue getTagInternal(String name) {
        Objects.requireNonNull(name, "Name argument required");
        if (this.values.get(name) == null) {
            throw new PlcInvalidTagException(name);
        }
        if (this.values.get(name).getCode() != PlcResponseCode.OK) {
            throw new PlcRuntimeException("Tag '" + name + "' could not be fetched, response was " + this.values.get(name).getCode());
        }
        return this.values.get(name).getValue();
    }

    protected PlcValue getTagIndexInternal(String name, int index) {
        PlcValue values = this.getTagInternal(name);
        if (values instanceof PlcList) {
            PlcList plcList = (PlcList)values;
            if (index > plcList.getLength() - 1) {
                return null;
            }
            return plcList.getIndex(index);
        }
        if (index != 0) {
            return null;
        }
        return values;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext("PlcReadResponse", new WithWriterArgs[0]);
        writeBuffer.pushContext("request", new WithWriterArgs[0]);
        if (this.request instanceof Serializable) {
            ((Serializable)this.request).serialize(writeBuffer);
        }
        writeBuffer.popContext("request", new WithWriterArgs[0]);
        writeBuffer.pushContext("values", WithReaderWriterArgs.WithRenderAsList(true));
        for (Map.Entry<String, ResponseItem<PlcValue>> valueEntry : this.values.entrySet()) {
            String tagName = valueEntry.getKey();
            writeBuffer.pushContext(tagName, new WithWriterArgs[0]);
            ResponseItem<PlcValue> valueResponse = valueEntry.getValue();
            valueResponse.serialize(writeBuffer);
            writeBuffer.popContext(tagName, new WithWriterArgs[0]);
        }
        writeBuffer.popContext("values", new WithWriterArgs[0]);
        writeBuffer.popContext("PlcReadResponse", new WithWriterArgs[0]);
    }
}

