/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.ConvertUtil;
import java.io.InputStream;
import java.sql.SQLException;

public class DmdbInputStream
extends InputStream {
    public static final int BINARY = 1;
    public static final int ASCII = 2;
    public static final int UNICODE = 3;
    private int type = 1;
    public static final int IS_BLOB = 1;
    public static final int IS_CLOB = 2;
    public static final int IS_BYTE = 3;
    private int objType;
    private Object obj = null;
    private int objPos;
    private int objLength;
    private boolean cut;
    private byte[] buf;
    private int bufPos = 0;
    private int avaliable;

    public DmdbInputStream(Object object) {
        this.obj = object;
        this.objPos = 0;
        if (object instanceof DmdbBlob) {
            this.objType = 1;
            this.avaliable = this.objLength = (int)((DmdbBlob)object).do_length();
        } else if (object instanceof DmdbClob) {
            this.objType = 2;
            this.objLength = (int)((DmdbClob)object).do_length();
            this.avaliable = (int)((DmdbClob)object).bytesLength;
        } else if (object instanceof byte[]) {
            this.objType = 3;
            this.avaliable = this.objLength = ((byte[])object).length;
        } else {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        }
    }

    protected DmdbInputStream(DmdbBlob dmdbBlob, long l2, long l3) {
        this(dmdbBlob);
        this.objPos = (int)(l2 - 1L);
        this.objLength = (int)Math.min((long)this.objLength, (long)this.objPos + l3);
        this.cut = this.objPos > 0 || (long)this.objLength < dmdbBlob.do_length();
        this.avaliable = this.objLength - this.objPos;
    }

    public DmdbInputStream(Object object, int n2) {
        this(object);
        this.type = n2;
    }

    public Object useRealObject(long l2) {
        switch (this.objType) {
            case 1: 
            case 2: {
                if (this.objPos != 0 || this.cut || -1L != l2 && l2 < (long)this.objLength) break;
                return this.obj;
            }
        }
        return this;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n3 < 0 || n3 > byArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        if (this.avaliable <= 0) {
            return -1;
        }
        int n4 = 0;
        while (n4 < n3) {
            int n5 = this.bufLeaveLen();
            if (n5 == 0 && (n5 = this.fillBuffer()) <= 0) break;
            int n6 = n3 - n4;
            int n7 = Math.min(n6, n5);
            System.arraycopy(this.buf, this.bufPos, byArray, n2, n7);
            this.bufPos += n7;
            n2 += n7;
            n4 += n7;
        }
        this.avaliable -= n4;
        return n4;
    }

    @Override
    public int read() {
        byte[] byArray = new byte[1];
        int n2 = this.read(byArray);
        if (n2 == -1) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int available() {
        return this.avaliable;
    }

    @Override
    public long skip(long l2) {
        if (this.objType == 2) {
            return super.skip(l2);
        }
        int n2 = (int)Math.min((long)this.avaliable, l2);
        if (n2 <= 0) {
            return 0L;
        }
        int n3 = this.bufLeaveLen();
        if (n2 < n3) {
            this.bufPos += n2;
        } else {
            this.objPos += n2 - n3;
            this.fillBuffer();
        }
        return n2;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int n2) {
        super.mark(n2);
    }

    @Override
    public synchronized void reset() {
        super.reset();
    }

    private int bufLeaveLen() {
        return this.buf == null ? 0 : this.buf.length - this.bufPos;
    }

    private int fillBuffer() {
        switch (this.objType) {
            case 1: {
                return this.readFromBlob(32640);
            }
            case 2: {
                return this.readFromClob(16320);
            }
            case 3: {
                return this.readFromBytes();
            }
        }
        DBError.throwIOException(DBError.ECJDBC_DATA_CONVERTION_ERROR.reason);
        return 0;
    }

    private int readFromBytes() {
        int n2 = this.objLength - this.objPos;
        int n3 = 0;
        if (n2 <= 0) {
            return -1;
        }
        this.buf = (byte[])this.obj;
        n3 = this.buf == null ? 0 : this.buf.length;
        this.objPos += n3;
        this.bufPos = 0;
        return n3;
    }

    private int readFromBlob(int n2) {
        int n3;
        int n4;
        DmdbBlob dmdbBlob;
        block3: {
            dmdbBlob = (DmdbBlob)this.obj;
            n4 = this.objLength - this.objPos;
            n3 = 0;
            if (n4 > 0) break block3;
            return -1;
        }
        try {
            n2 = Math.min(n4, n2);
            this.buf = dmdbBlob.do_getBytes(this.objPos + 1, n2);
            n3 = this.buf == null ? 0 : this.buf.length;
            this.objPos += n3;
            this.bufPos = 0;
        }
        catch (SQLException sQLException) {
            DBError.throwIOException(sQLException.getMessage());
        }
        return n3;
    }

    private int readFromClob(int n2) {
        int n3;
        int n4;
        DmdbClob dmdbClob;
        block3: {
            dmdbClob = (DmdbClob)this.obj;
            n4 = this.objLength - this.objPos;
            n3 = 0;
            if (n4 > 0) break block3;
            return -1;
        }
        try {
            n2 = Math.min(n4, n2);
            String string = dmdbClob.do_getSubString(this.objPos + 1, n2);
            this.buf = this.type == 2 ? (string == null ? new byte[]{} : ConvertUtil.StringToAsciiBytes(string)) : (this.type == 3 ? (string == null ? new byte[]{} : ConvertUtil.StringToUnicodeBytes(string)) : (string == null ? new byte[]{} : ByteUtil.fromString(string, dmdbClob.serverEncoding)));
            n3 = this.buf == null ? 0 : this.buf.length;
            this.objPos += n2;
            this.bufPos = 0;
        }
        catch (SQLException sQLException) {
            DBError.throwIOException(sQLException.getMessage());
        }
        return n3;
    }
}

