/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class DnsRCode
extends NamedNumber<Byte, DnsRCode> {
    private static final long serialVersionUID = -1275148349508319228L;
    public static final DnsRCode NO_ERROR = new DnsRCode((byte)0, "No Error");
    public static final DnsRCode FORM_ERR = new DnsRCode((byte)1, "Format Error");
    public static final DnsRCode SERV_FAIL = new DnsRCode((byte)2, "Server Failure");
    public static final DnsRCode NX_DOMAIN = new DnsRCode((byte)3, "Non-Existent Domain");
    public static final DnsRCode NOT_IMP = new DnsRCode((byte)4, "Not Implemented");
    public static final DnsRCode REFUSED = new DnsRCode((byte)5, "Query Refused");
    public static final DnsRCode YX_DOMAIN = new DnsRCode((byte)6, "Name Exists when it should not");
    public static final DnsRCode YX_RR_SET = new DnsRCode((byte)7, "RR Set Exists when it should not");
    public static final DnsRCode NX_RR_SET = new DnsRCode((byte)8, "RR Set that should exist does not");
    public static final DnsRCode NOT_AUTH = new DnsRCode((byte)9, "Not Authorized");
    public static final DnsRCode NOT_ZONE = new DnsRCode((byte)10, "Name not contained in zone");
    private static final Map<Byte, DnsRCode> registry = new HashMap<Byte, DnsRCode>();

    public DnsRCode(Byte value, String name) {
        super(value, name);
        if ((value & 0xF0) != 0) {
            throw new IllegalArgumentException(value + " is invalid value. DNS RCODE must be between 0 and 15");
        }
    }

    public static DnsRCode getInstance(Byte value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new DnsRCode(value, "unknown");
    }

    public static DnsRCode register(DnsRCode code) {
        return registry.put((Byte)code.value(), code);
    }

    @Override
    public int compareTo(DnsRCode o) {
        return ((Byte)this.value()).compareTo((Byte)o.value());
    }

    static {
        registry.put((Byte)NO_ERROR.value(), NO_ERROR);
        registry.put((Byte)FORM_ERR.value(), FORM_ERR);
        registry.put((Byte)SERV_FAIL.value(), SERV_FAIL);
        registry.put((Byte)NX_DOMAIN.value(), NX_DOMAIN);
        registry.put((Byte)NOT_IMP.value(), NOT_IMP);
        registry.put((Byte)REFUSED.value(), REFUSED);
        registry.put((Byte)YX_DOMAIN.value(), YX_DOMAIN);
        registry.put((Byte)YX_RR_SET.value(), YX_RR_SET);
        registry.put((Byte)NX_RR_SET.value(), NX_RR_SET);
        registry.put((Byte)NOT_AUTH.value(), NOT_AUTH);
        registry.put((Byte)NOT_ZONE.value(), NOT_ZONE);
    }
}

