/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.ITemplateHandler;
import org.thymeleaf.model.ICDATASection;
import org.thymeleaf.model.ICloseElementTag;
import org.thymeleaf.model.IComment;
import org.thymeleaf.model.IDocType;
import org.thymeleaf.model.IOpenElementTag;
import org.thymeleaf.model.IProcessingInstruction;
import org.thymeleaf.model.IStandaloneElementTag;
import org.thymeleaf.model.ITemplateEnd;
import org.thymeleaf.model.ITemplateStart;
import org.thymeleaf.model.IText;
import org.thymeleaf.model.IXMLDeclaration;
import org.thymeleaf.util.Validate;

public abstract class AbstractTemplateHandler
implements ITemplateHandler {
    private ITemplateHandler next = null;
    private ITemplateContext context = null;

    protected AbstractTemplateHandler(ITemplateHandler next) {
        this.next = next;
    }

    protected AbstractTemplateHandler() {
    }

    @Override
    public void setNext(ITemplateHandler next) {
        this.next = next;
    }

    @Override
    public void setContext(ITemplateContext context) {
        Validate.notNull(context, "Context cannot be null");
        this.context = context;
    }

    protected final ITemplateHandler getNext() {
        return this.next;
    }

    protected final ITemplateContext getContext() {
        return this.context;
    }

    @Override
    public void handleTemplateStart(ITemplateStart templateStart) {
        if (this.next == null) {
            return;
        }
        this.next.handleTemplateStart(templateStart);
    }

    @Override
    public void handleTemplateEnd(ITemplateEnd templateEnd) {
        if (this.next == null) {
            return;
        }
        this.next.handleTemplateEnd(templateEnd);
    }

    @Override
    public void handleXMLDeclaration(IXMLDeclaration xmlDeclaration) {
        if (this.next == null) {
            return;
        }
        this.next.handleXMLDeclaration(xmlDeclaration);
    }

    @Override
    public void handleDocType(IDocType docType) {
        if (this.next == null) {
            return;
        }
        this.next.handleDocType(docType);
    }

    @Override
    public void handleCDATASection(ICDATASection cdataSection) {
        if (this.next == null) {
            return;
        }
        this.next.handleCDATASection(cdataSection);
    }

    @Override
    public void handleComment(IComment comment) {
        if (this.next == null) {
            return;
        }
        this.next.handleComment(comment);
    }

    @Override
    public void handleText(IText text) {
        if (this.next == null) {
            return;
        }
        this.next.handleText(text);
    }

    @Override
    public void handleStandaloneElement(IStandaloneElementTag standaloneElementTag) {
        if (this.next == null) {
            return;
        }
        this.next.handleStandaloneElement(standaloneElementTag);
    }

    @Override
    public void handleOpenElement(IOpenElementTag openElementTag) {
        if (this.next == null) {
            return;
        }
        this.next.handleOpenElement(openElementTag);
    }

    @Override
    public void handleCloseElement(ICloseElementTag closeElementTag) {
        if (this.next == null) {
            return;
        }
        this.next.handleCloseElement(closeElementTag);
    }

    @Override
    public void handleProcessingInstruction(IProcessingInstruction processingInstruction) {
        if (this.next == null) {
            return;
        }
        this.next.handleProcessingInstruction(processingInstruction);
    }
}

