/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory.statik;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IllegalTcpOption;
import org.pcap4j.packet.TcpEndOfOptionList;
import org.pcap4j.packet.TcpMaximumSegmentSizeOption;
import org.pcap4j.packet.TcpNoOperationOption;
import org.pcap4j.packet.TcpPacket;
import org.pcap4j.packet.TcpSackOption;
import org.pcap4j.packet.TcpSackPermittedOption;
import org.pcap4j.packet.TcpTimestampsOption;
import org.pcap4j.packet.TcpWindowScaleOption;
import org.pcap4j.packet.UnknownTcpOption;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.TcpOptionKind;

public final class StaticTcpOptionFactory
implements PacketFactory<TcpPacket.TcpOption, TcpOptionKind> {
    private static final StaticTcpOptionFactory INSTANCE = new StaticTcpOptionFactory();
    private final Map<TcpOptionKind, Instantiater> instantiaters = new HashMap<TcpOptionKind, Instantiater>();

    private StaticTcpOptionFactory() {
        this.instantiaters.put(TcpOptionKind.END_OF_OPTION_LIST, new Instantiater(){

            @Override
            public TcpPacket.TcpOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return TcpEndOfOptionList.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<TcpEndOfOptionList> getTargetClass() {
                return TcpEndOfOptionList.class;
            }
        });
        this.instantiaters.put(TcpOptionKind.NO_OPERATION, new Instantiater(){

            @Override
            public TcpPacket.TcpOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return TcpNoOperationOption.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<TcpNoOperationOption> getTargetClass() {
                return TcpNoOperationOption.class;
            }
        });
        this.instantiaters.put(TcpOptionKind.MAXIMUM_SEGMENT_SIZE, new Instantiater(){

            @Override
            public TcpPacket.TcpOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return TcpMaximumSegmentSizeOption.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<TcpMaximumSegmentSizeOption> getTargetClass() {
                return TcpMaximumSegmentSizeOption.class;
            }
        });
        this.instantiaters.put(TcpOptionKind.WINDOW_SCALE, new Instantiater(){

            @Override
            public TcpPacket.TcpOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return TcpWindowScaleOption.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<TcpWindowScaleOption> getTargetClass() {
                return TcpWindowScaleOption.class;
            }
        });
        this.instantiaters.put(TcpOptionKind.SACK_PERMITTED, new Instantiater(){

            @Override
            public TcpPacket.TcpOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return TcpSackPermittedOption.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<TcpSackPermittedOption> getTargetClass() {
                return TcpSackPermittedOption.class;
            }
        });
        this.instantiaters.put(TcpOptionKind.SACK, new Instantiater(){

            @Override
            public TcpPacket.TcpOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return TcpSackOption.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<TcpSackOption> getTargetClass() {
                return TcpSackOption.class;
            }
        });
        this.instantiaters.put(TcpOptionKind.TIMESTAMPS, new Instantiater(){

            @Override
            public TcpPacket.TcpOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return TcpTimestampsOption.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<TcpTimestampsOption> getTargetClass() {
                return TcpTimestampsOption.class;
            }
        });
    }

    public static StaticTcpOptionFactory getInstance() {
        return INSTANCE;
    }

    public TcpPacket.TcpOption newInstance(byte[] rawData, int offset, int length, TcpOptionKind number) {
        if (rawData == null || number == null) {
            StringBuilder sb = new StringBuilder(40);
            sb.append("rawData: ").append(rawData).append(" number: ").append(number);
            throw new NullPointerException(sb.toString());
        }
        try {
            Instantiater instantiater = this.instantiaters.get(number);
            if (instantiater != null) {
                return instantiater.newInstance(rawData, offset, length);
            }
        }
        catch (IllegalRawDataException e) {
            return IllegalTcpOption.newInstance((byte[])rawData, (int)offset, (int)length);
        }
        return this.newInstance(rawData, offset, length);
    }

    public TcpPacket.TcpOption newInstance(byte[] rawData, int offset, int length) {
        try {
            return UnknownTcpOption.newInstance((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalTcpOption.newInstance((byte[])rawData, (int)offset, (int)length);
        }
    }

    public Class<? extends TcpPacket.TcpOption> getTargetClass(TcpOptionKind number) {
        if (number == null) {
            throw new NullPointerException("number must not be null.");
        }
        Instantiater instantiater = this.instantiaters.get(number);
        return instantiater != null ? instantiater.getTargetClass() : this.getTargetClass();
    }

    public Class<? extends TcpPacket.TcpOption> getTargetClass() {
        return UnknownTcpOption.class;
    }

    private static interface Instantiater {
        public TcpPacket.TcpOption newInstance(byte[] var1, int var2, int var3) throws IllegalRawDataException;

        public Class<? extends TcpPacket.TcpOption> getTargetClass();
    }
}

