/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.tag;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.model.PlcTag;

public class S7AckTag
implements PlcTag {
    private static final Pattern EVENT_ALARM_ACK_PATTERN = Pattern.compile("(^ACK:)((,{0,1}(16#[0-9a-fA-F]{8})(;([0-9a-fA-F]{2})))+)");
    private final ArrayList<Integer> ackAlarmIds;
    private final ArrayList<Integer> ackAlarmSigs;

    public S7AckTag(ArrayList<Integer> ackAlarmIds, ArrayList<Integer> ackAlarmSigs) {
        this.ackAlarmIds = ackAlarmIds;
        this.ackAlarmSigs = ackAlarmSigs;
    }

    public ArrayList<Integer> getAlarmIds() {
        return this.ackAlarmIds;
    }

    public ArrayList<Integer> getAlarmSigs() {
        return this.ackAlarmSigs;
    }

    public static boolean matches(String fieldString) {
        return EVENT_ALARM_ACK_PATTERN.matcher(fieldString).matches();
    }

    public static S7AckTag of(String fieldString) {
        Matcher matcher = EVENT_ALARM_ACK_PATTERN.matcher(fieldString);
        if (matcher.matches()) {
            String EventIds = matcher.group(2);
            String[] arrStrEventId = EventIds.split(",");
            ArrayList<Integer> arrAlarmIds = new ArrayList<Integer>();
            ArrayList<Integer> arrAlarmSigs = new ArrayList<Integer>();
            String[] stringArray = arrStrEventId;
            int n = arrStrEventId.length;
            int n2 = 0;
            while (n2 < n) {
                String EventId = stringArray[n2];
                EventId = EventId.replaceAll("16#", "");
                String[] arrIdAndSig = EventId.split(";");
                arrAlarmIds.add(Integer.parseInt(arrIdAndSig[0], 16));
                arrAlarmSigs.add(Integer.parseInt(arrIdAndSig[1], 16));
                ++n2;
            }
            return new S7AckTag(arrAlarmIds, arrAlarmSigs);
        }
        return null;
    }

    public String getAddressString() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

