/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.common.util;

import io.greptime.common.util.LogScheduledThreadPoolExecutor;
import io.greptime.common.util.ThreadPoolMetricRegistry;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class MetricScheduledThreadPoolExecutor
extends LogScheduledThreadPoolExecutor {
    public MetricScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler, String name) {
        super(corePoolSize, threadFactory, handler, name);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        ThreadPoolMetricRegistry.start();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        ThreadPoolMetricRegistry.metricRegistry().timer("scheduled_thread_pool." + this.getName()).update(ThreadPoolMetricRegistry.finish(), TimeUnit.MILLISECONDS);
        super.afterExecute(r, t);
    }
}

