/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.common.util;

import com.codahale.metrics.Timer;
import io.greptime.common.util.Ensures;
import io.greptime.common.util.MetricsUtil;
import java.util.concurrent.Executor;

public class MetricExecutor
implements Executor {
    private final Executor pool;
    private final String name;
    private final Timer executeTimer;

    public MetricExecutor(Executor pool, String name) {
        this.pool = Ensures.ensureNonNull(pool, "null `pool`");
        this.name = name;
        this.executeTimer = MetricsUtil.timer((Object)name);
    }

    @Override
    public void execute(Runnable cmd) {
        this.pool.execute(() -> this.executeTimer.time(cmd));
    }

    public String toString() {
        return "MetricExecutor{pool=" + this.pool + ", name='" + this.name + '\'' + '}';
    }
}

