/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.meta.AlterSchemaOp;
import com.vesoft.nebula.meta.Schema;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AlterSchemaItem
implements TBase,
Serializable,
Cloneable,
Comparable<AlterSchemaItem> {
    private static final TStruct STRUCT_DESC = new TStruct("AlterSchemaItem");
    private static final TField OP_FIELD_DESC = new TField("op", 8, 1);
    private static final TField SCHEMA_FIELD_DESC = new TField("schema", 12, 2);
    public AlterSchemaOp op;
    public Schema schema;
    public static final int OP = 1;
    public static final int SCHEMA = 2;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public AlterSchemaItem() {
    }

    public AlterSchemaItem(AlterSchemaOp op, Schema schema) {
        this();
        this.op = op;
        this.schema = schema;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AlterSchemaItem(AlterSchemaItem other) {
        if (other.isSetOp()) {
            this.op = TBaseHelper.deepCopy(other.op);
        }
        if (other.isSetSchema()) {
            this.schema = TBaseHelper.deepCopy(other.schema);
        }
    }

    @Override
    public AlterSchemaItem deepCopy() {
        return new AlterSchemaItem(this);
    }

    public AlterSchemaOp getOp() {
        return this.op;
    }

    public AlterSchemaItem setOp(AlterSchemaOp op) {
        this.op = op;
        return this;
    }

    public void unsetOp() {
        this.op = null;
    }

    public boolean isSetOp() {
        return this.op != null;
    }

    public void setOpIsSet(boolean __value) {
        if (!__value) {
            this.op = null;
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    public AlterSchemaItem setSchema(Schema schema) {
        this.schema = schema;
        return this;
    }

    public void unsetSchema() {
        this.schema = null;
    }

    public boolean isSetSchema() {
        return this.schema != null;
    }

    public void setSchemaIsSet(boolean __value) {
        if (!__value) {
            this.schema = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetOp();
                    break;
                }
                this.setOp((AlterSchemaOp)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetSchema();
                    break;
                }
                this.setSchema((Schema)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getOp();
            }
            case 2: {
                return this.getSchema();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof AlterSchemaItem)) {
            return false;
        }
        AlterSchemaItem that = (AlterSchemaItem)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetOp(), that.isSetOp(), this.op, that.op)) {
            return false;
        }
        return TBaseHelper.equalsNobinary(this.isSetSchema(), that.isSetSchema(), this.schema, that.schema);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.op, this.schema});
    }

    @Override
    public int compareTo(AlterSchemaItem other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetOp()).compareTo(other.isSetOp());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.op, other.op);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSchema()).compareTo(other.isSetSchema());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.schema, other.schema);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 8) {
                        this.op = AlterSchemaOp.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 12) {
                        this.schema = new Schema();
                        this.schema.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.op != null) {
            oprot.writeFieldBegin(OP_FIELD_DESC);
            oprot.writeI32(this.op == null ? 0 : this.op.getValue());
            oprot.writeFieldEnd();
        }
        if (this.schema != null) {
            oprot.writeFieldBegin(SCHEMA_FIELD_DESC);
            this.schema.write(oprot);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("AlterSchemaItem");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("op");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getOp() == null) {
            sb.append("null");
        } else {
            String op_name;
            String string = op_name = this.getOp() == null ? "null" : this.getOp().name();
            if (op_name != null) {
                sb.append(op_name);
                sb.append(" (");
            }
            sb.append(this.getOp());
            if (op_name != null) {
                sb.append(")");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("schema");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getSchema() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getSchema(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("op", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("schema", 3, new StructMetaData(12, Schema.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(AlterSchemaItem.class, metaDataMap);
    }

    public static class Builder {
        private AlterSchemaOp op;
        private Schema schema;

        public Builder setOp(AlterSchemaOp op) {
            this.op = op;
            return this;
        }

        public Builder setSchema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public AlterSchemaItem build() {
            AlterSchemaItem result = new AlterSchemaItem();
            result.setOp(this.op);
            result.setSchema(this.schema);
            return result;
        }
    }
}

