/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.stream;

import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.stream.AbstractByteBufferInputStream;
import com.clickhouse.data.stream.AdaptiveQueue;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class NonBlockingInputStream
extends AbstractByteBufferInputStream {
    private final AdaptiveQueue<ByteBuffer> queue;
    private final long timeout;

    public NonBlockingInputStream(AdaptiveQueue<ByteBuffer> queue, long timeout, Runnable postCloseAction) {
        super(null, null, postCloseAction);
        this.queue = ClickHouseChecker.nonNull(queue, "Queue");
        this.timeout = timeout < 0L ? 0L : timeout;
    }

    @Override
    protected int updateBuffer() throws IOException {
        ByteBuffer b;
        long startTime;
        AdaptiveQueue<ByteBuffer> q = this.queue;
        long t = this.timeout;
        long l = startTime = t < 1L ? 0L : System.currentTimeMillis();
        while ((b = q.poll()) == null) {
            if (this.closed) {
                throw new IOException("Cannot operate on a closed input stream");
            }
            if (t <= 0L || System.currentTimeMillis() - startTime < t) continue;
            throw new IOException(ClickHouseUtils.format("Read timed out after %d ms", t));
        }
        this.buffer = b;
        int remain = b.remaining();
        if (remain > 0 && this.copyTo != null) {
            int position = b.position();
            if (b.hasArray()) {
                this.copyTo.write(b.array(), position, remain);
            } else {
                byte[] bytes = new byte[remain];
                b.get(bytes);
                this.copyTo.write(bytes);
                ((Buffer)b).position(position);
            }
        }
        return remain;
    }
}

