/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.codegen.fields;

import java.util.Objects;
import org.apache.plc4x.java.spi.codegen.FieldCommons;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldReaderChecksum<T>
implements FieldCommons {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldReaderChecksum.class);

    public T readChecksumField(String logicalName, DataReader<T> dataReader, T referenceValue, WithReaderArgs ... readerArgs) throws ParseException {
        LOGGER.debug("reading field {}", (Object)logicalName);
        Object checksumValue = this.switchParseByteOrderIfNecessary(() -> dataReader.read(logicalName, readerArgs), dataReader, this.extractByteOrder(readerArgs).orElse(null));
        if (!Objects.equals(checksumValue, referenceValue)) {
            throw new ParseException("Checksum value '" + checksumValue + "' doesn't match expected '" + referenceValue + "'");
        }
        return (T)checksumValue;
    }
}

