/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.notice.impl;

import java.util.ResourceBundle;
import org.apache.hertzbeat.alert.notice.AlertNoticeException;
import org.apache.hertzbeat.alert.notice.impl.AbstractAlertNotifyHandlerImpl;
import org.apache.hertzbeat.alert.service.SmsClient;
import org.apache.hertzbeat.alert.service.SmsClientFactory;
import org.apache.hertzbeat.common.entity.alerter.GroupAlert;
import org.apache.hertzbeat.common.entity.alerter.NoticeReceiver;
import org.apache.hertzbeat.common.entity.alerter.NoticeTemplate;
import org.apache.hertzbeat.common.util.ResourceBundleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
final class SmsAlertNotifyHandlerImpl
extends AbstractAlertNotifyHandlerImpl {
    private static final Logger log = LoggerFactory.getLogger(SmsAlertNotifyHandlerImpl.class);
    private final SmsClientFactory smsFactory;
    private final ResourceBundle bundle = ResourceBundleUtil.getBundle((String)"alerter");

    @Override
    public void send(NoticeReceiver receiver, NoticeTemplate noticeTemplate, GroupAlert alert) {
        try {
            SmsClient smsClient = this.smsFactory.getSmsClient();
            if (smsClient == null) {
                throw new AlertNoticeException("No SMS Service available, please check the configuration");
            }
            if (!smsClient.checkConfig()) {
                throw new AlertNoticeException(smsClient.getType() + " SMS Service configuration is invalid, please check the configuration");
            }
            smsClient.sendMessage(receiver, noticeTemplate, alert);
        }
        catch (Exception e) {
            throw new AlertNoticeException("[Sms Notify Error] " + e.getMessage());
        }
    }

    @Override
    public byte type() {
        return 0;
    }

    public SmsAlertNotifyHandlerImpl(SmsClientFactory smsFactory) {
        this.smsFactory = smsFactory;
    }
}

