/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.List;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.MatrixVariable;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolverSupport;
import org.springframework.web.reactive.result.method.SyncHandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;

public class MatrixVariableMapMethodArgumentResolver
extends HandlerMethodArgumentResolverSupport
implements SyncHandlerMethodArgumentResolver {
    public MatrixVariableMapMethodArgumentResolver(ReactiveAdapterRegistry registry) {
        super(registry);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return this.checkAnnotatedParamNoReactiveWrapper(parameter, MatrixVariable.class, (ann, type) -> Map.class.isAssignableFrom((Class<?>)type) && !StringUtils.hasText((String)ann.name()));
    }

    @Override
    @Nullable
    public Object resolveArgumentValue(MethodParameter parameter, BindingContext bindingContext, ServerWebExchange exchange2) {
        Map matrixVariables = (Map)exchange2.getAttribute(HandlerMapping.MATRIX_VARIABLES_ATTRIBUTE);
        MultiValueMap<String, String> map = this.mapMatrixVariables(parameter, matrixVariables);
        return this.isSingleValueMap(parameter) ? map.toSingleValueMap() : map;
    }

    private MultiValueMap<String, String> mapMatrixVariables(MethodParameter parameter, @Nullable Map<String, MultiValueMap<String, String>> matrixVariables) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        if (CollectionUtils.isEmpty(matrixVariables)) {
            return map;
        }
        MatrixVariable annotation = (MatrixVariable)parameter.getParameterAnnotation(MatrixVariable.class);
        Assert.state((annotation != null ? 1 : 0) != 0, (String)"No MatrixVariable annotation");
        String pathVariable = annotation.pathVar();
        if (!pathVariable.equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n")) {
            MultiValueMap<String, String> mapForPathVariable = matrixVariables.get(pathVariable);
            if (mapForPathVariable == null) {
                return map;
            }
            map.putAll(mapForPathVariable);
        } else {
            for (MultiValueMap<String, String> vars : matrixVariables.values()) {
                vars.forEach((arg_0, arg_1) -> MatrixVariableMapMethodArgumentResolver.lambda$mapMatrixVariables$1((MultiValueMap)map, arg_0, arg_1));
            }
        }
        return map;
    }

    private boolean isSingleValueMap(MethodParameter parameter) {
        ResolvableType[] genericTypes;
        if (!MultiValueMap.class.isAssignableFrom(parameter.getParameterType()) && (genericTypes = ResolvableType.forMethodParameter((MethodParameter)parameter).getGenerics()).length == 2) {
            return !List.class.isAssignableFrom(genericTypes[1].toClass());
        }
        return false;
    }

    private static /* synthetic */ void lambda$mapMatrixVariables$1(MultiValueMap map, String name, List values) {
        for (String value : values) {
            map.add((Object)name, (Object)value);
        }
    }
}

