/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.config;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hertzbeat.common.constants.ManagerEventTypeEnum;
import org.apache.hertzbeat.common.entity.dto.ImportTaskMessage;
import org.apache.hertzbeat.common.entity.dto.ManagerMessage;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Component
public class ManagerSseManager {
    private static final Logger log = LoggerFactory.getLogger(ManagerSseManager.class);
    private final Map<Long, SseEmitter> emitters = new ConcurrentHashMap<Long, SseEmitter>();

    public SseEmitter createEmitter(Long clientId) {
        SseEmitter emitter = new SseEmitter(Long.valueOf(Long.MAX_VALUE));
        emitter.onCompletion(() -> this.removeEmitter(clientId));
        emitter.onTimeout(() -> this.removeEmitter(clientId));
        this.emitters.put(clientId, emitter);
        return emitter;
    }

    @Async
    public void broadcast(String eventName, String data) {
        this.emitters.forEach((clientId, emitter) -> {
            try {
                emitter.send(SseEmitter.event().id(String.valueOf(System.currentTimeMillis())).name(eventName).data((Object)data));
            }
            catch (IOException | IllegalStateException e) {
                emitter.complete();
                this.removeEmitter((Long)clientId);
            }
            catch (Exception exception) {
                log.error("Failed to broadcast manager message data to client: {}", (Object)exception.getMessage());
                emitter.complete();
                this.removeEmitter((Long)clientId);
            }
        });
    }

    public void broadcastImportTaskInProgress(String taskName, Integer progress) {
        ManagerMessage managerMessage = ImportTaskMessage.createInProgressMessage(taskName, progress);
        this.broadcast(ManagerEventTypeEnum.IMPORT_TASK_EVENT.getValue(), JsonUtil.toJson(managerMessage));
    }

    public void broadcastImportTaskSuccess(String taskName) {
        ManagerMessage managerMessage = ImportTaskMessage.createCompletedMessage(taskName);
        this.broadcast(ManagerEventTypeEnum.IMPORT_TASK_EVENT.getValue(), JsonUtil.toJson(managerMessage));
    }

    public void broadcastImportTaskFail(String taskName, String errMsg) {
        ManagerMessage managerMessage = ImportTaskMessage.createFailedMessage(taskName, errMsg);
        this.broadcast(ManagerEventTypeEnum.IMPORT_TASK_EVENT.getValue(), JsonUtil.toJson(managerMessage));
    }

    private void removeEmitter(Long clientId) {
        this.emitters.remove(clientId);
    }
}

