/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.memory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.ai.chat.memory.ChatMemoryRepository;
import org.springframework.ai.chat.messages.Message;
import org.springframework.util.Assert;

public final class InMemoryChatMemoryRepository
implements ChatMemoryRepository {
    Map<String, List<Message>> chatMemoryStore = new ConcurrentHashMap<String, List<Message>>();

    @Override
    public List<String> findConversationIds() {
        return new ArrayList<String>(this.chatMemoryStore.keySet());
    }

    @Override
    public List<Message> findByConversationId(String conversationId) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        List<Message> messages = this.chatMemoryStore.get(conversationId);
        return messages != null ? new ArrayList<Message>(messages) : List.of();
    }

    @Override
    public void saveAll(String conversationId, List<Message> messages) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        Assert.notNull(messages, (String)"messages cannot be null");
        Assert.noNullElements(messages, (String)"messages cannot contain null elements");
        this.chatMemoryStore.put(conversationId, messages);
    }

    @Override
    public void deleteByConversationId(String conversationId) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        this.chatMemoryStore.remove(conversationId);
    }
}

