/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.RegionStateStore;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HBCKServerCrashProcedure
extends ServerCrashProcedure {
    private static final Logger LOG = LoggerFactory.getLogger(HBCKServerCrashProcedure.class);

    public HBCKServerCrashProcedure(MasterProcedureEnv env, ServerName serverName, boolean shouldSplitWal, boolean carryingMeta) {
        super(env, serverName, shouldSplitWal, carryingMeta);
    }

    public HBCKServerCrashProcedure() {
    }

    @Override
    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_EXCEPTION"}, justification="FindBugs seems confused on ps in below.")
    List<RegionInfo> getRegionsOnCrashedServer(MasterProcedureEnv env) {
        List<RegionInfo> ris = super.getRegionsOnCrashedServer(env);
        if (!ris.isEmpty()) {
            return ris;
        }
        UnknownServerVisitor visitor = new UnknownServerVisitor(env.getMasterServices().getConnection(), this.getServerName());
        try {
            MetaTableAccessor.scanMetaForTableRegions(env.getMasterServices().getConnection(), visitor, null);
        }
        catch (IOException ioe) {
            LOG.warn("Failed scan of hbase:meta for 'Unknown Servers'", (Throwable)ioe);
            return ris;
        }
        env.getAssignmentManager().getRegionStates().createServer(this.getServerName());
        LOG.info("Found {} mentions of {} in hbase:meta of OPEN/OPENING Regions: {}", new Object[]{visitor.getReassigns().size(), this.getServerName(), visitor.getReassigns().stream().map(RegionInfo::getEncodedName).collect(Collectors.joining(","))});
        return visitor.getReassigns();
    }

    @Override
    protected boolean isMatchingRegionLocation(RegionStateNode rsn) {
        return super.isMatchingRegionLocation(rsn) || rsn.getRegionLocation() == null;
    }

    private static class UnknownServerVisitor
    implements MetaTableAccessor.Visitor {
        private final List<RegionInfo> reassigns = new ArrayList<RegionInfo>();
        private final ServerName unknownServerName;
        private final Connection connection;

        private UnknownServerVisitor(Connection connection, ServerName unknownServerName) {
            this.connection = connection;
            this.unknownServerName = unknownServerName;
        }

        @Override
        public boolean visit(Result result) throws IOException {
            RegionLocations rls = MetaTableAccessor.getRegionLocations(result);
            if (rls == null) {
                return true;
            }
            for (HRegionLocation hrl : rls.getRegionLocations()) {
                if (hrl == null || hrl.getRegion() == null || hrl.getServerName() == null || !hrl.getServerName().equals(this.unknownServerName)) continue;
                RegionState.State state = RegionStateStore.getRegionState(result, hrl.getRegion());
                RegionState rs = new RegionState(hrl.getRegion(), state, hrl.getServerName());
                if (rs.isClosing()) {
                    LOG.info("Moving {} from CLOSING to CLOSED in hbase:meta", (Object)hrl.getRegion().getRegionNameAsString());
                    try {
                        MetaTableAccessor.updateRegionState(this.connection, hrl.getRegion(), RegionState.State.CLOSED);
                    }
                    catch (IOException ioe) {
                        LOG.warn("Failed moving {} from CLOSING to CLOSED", (Object)hrl.getRegion().getRegionNameAsString(), (Object)ioe);
                    }
                    continue;
                }
                if (rs.isOpening() || rs.isOpened()) {
                    this.reassigns.add(hrl.getRegion());
                    continue;
                }
                LOG.info("Passing {}", (Object)rs);
            }
            return true;
        }

        private List<RegionInfo> getReassigns() {
            return this.reassigns;
        }
    }
}

