/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.crypto.random.CryptoRandom;
import org.apache.commons.crypto.random.CryptoRandomFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.VersionInfoUtil;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.io.ByteBufferOutputStream;
import org.apache.hadoop.hbase.io.crypto.aes.CryptoAES;
import org.apache.hadoop.hbase.ipc.BadAuthException;
import org.apache.hadoop.hbase.ipc.BufferChain;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.EmptyServiceNameException;
import org.apache.hadoop.hbase.ipc.FatalConnectionException;
import org.apache.hadoop.hbase.ipc.RPCTInfoGetter;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcResponse;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.SecurityNotEnabledException;
import org.apache.hadoop.hbase.ipc.ServerCall;
import org.apache.hadoop.hbase.ipc.UnknownServiceException;
import org.apache.hadoop.hbase.ipc.UnsupportedCellCodecException;
import org.apache.hadoop.hbase.ipc.UnsupportedCompressionCodecException;
import org.apache.hadoop.hbase.ipc.UnsupportedCryptoException;
import org.apache.hadoop.hbase.ipc.WrongVersionException;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerAbortedException;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.HBaseSaslRpcServer;
import org.apache.hadoop.hbase.security.SaslStatus;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.provider.SaslServerAuthenticationProvider;
import org.apache.hadoop.hbase.security.provider.SaslServerAuthenticationProviders;
import org.apache.hadoop.hbase.security.provider.SimpleSaslServerAuthenticationProvider;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegistryProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.TracingProtos;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingService;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteInput;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedInputStream;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.MessageOrBuilder;
import org.apache.hbase.thirdparty.com.google.protobuf.TextFormat;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
@SuppressWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="False positive according to http://sourceforge.net/p/findbugs/bugs/1032/")
abstract class ServerRpcConnection
implements Closeable {
    private static final TextMapGetter<TracingProtos.RPCTInfo> getter = new RPCTInfoGetter();
    protected final RpcServer rpcServer;
    protected boolean connectionHeaderRead = false;
    protected RpcServer.CallCleanup callCleanup;
    protected String hostAddress;
    protected int remotePort;
    protected InetAddress addr;
    protected RPCProtos.ConnectionHeader connectionHeader;
    protected Map<String, byte[]> connectionAttributes;
    protected Codec codec;
    protected CompressionCodec compressionCodec;
    protected BlockingService service;
    protected SaslServerAuthenticationProvider provider;
    protected boolean skipInitialSaslHandshake;
    protected boolean useSasl;
    protected HBaseSaslRpcServer saslServer;
    protected boolean authenticatedWithFallback;
    protected boolean retryImmediatelySupported = false;
    protected User user = null;
    protected UserGroupInformation ugi = null;
    protected SaslServerAuthenticationProviders saslProviders = null;
    protected X509Certificate[] clientCertificateChain = null;

    public ServerRpcConnection(RpcServer rpcServer) {
        this.rpcServer = rpcServer;
        this.callCleanup = null;
        this.saslProviders = SaslServerAuthenticationProviders.getInstance(rpcServer.getConf());
    }

    public String toString() {
        return this.getHostAddress() + ":" + this.remotePort;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public InetAddress getHostInetAddress() {
        return this.addr;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public HBaseProtos.VersionInfo getVersionInfo() {
        if (this.connectionHeader != null && this.connectionHeader.hasVersionInfo()) {
            return this.connectionHeader.getVersionInfo();
        }
        return null;
    }

    private String getFatalConnectionString(int version, byte authByte) {
        return "serverVersion=0, clientVersion=" + version + ", authMethod=" + authByte + ", authName=" + (this.provider == null ? "unknown" : this.provider.getSaslAuthMethod().getName()) + " from " + this.toString();
    }

    private void setupCellBlockCodecs() throws FatalConnectionException {
        if (!this.connectionHeader.hasCellBlockCodecClass()) {
            return;
        }
        String className = this.connectionHeader.getCellBlockCodecClass();
        if (className == null || className.length() == 0) {
            return;
        }
        try {
            this.codec = (Codec)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new UnsupportedCellCodecException(className, (Throwable)e);
        }
        if (!this.connectionHeader.hasCellBlockCompressorClass()) {
            return;
        }
        className = this.connectionHeader.getCellBlockCompressorClass();
        try {
            this.compressionCodec = (CompressionCodec)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new UnsupportedCompressionCodecException(className, (Throwable)e);
        }
    }

    private Pair<RPCProtos.ConnectionHeaderResponse, CryptoAES> setupCryptoCipher() throws FatalConnectionException {
        CryptoAES cryptoAES;
        boolean isCryptoAesEncryption;
        if (this.saslServer == null) {
            return null;
        }
        String qop = this.saslServer.getNegotiatedQop();
        boolean isEncryption = SaslUtil.QualityOfProtection.PRIVACY.getSaslQop().equalsIgnoreCase(qop);
        boolean bl = isCryptoAesEncryption = isEncryption && this.rpcServer.conf.getBoolean("hbase.rpc.crypto.encryption.aes.enabled", false);
        if (!isCryptoAesEncryption) {
            return null;
        }
        if (!this.connectionHeader.hasRpcCryptoCipherTransformation()) {
            return null;
        }
        String transformation = this.connectionHeader.getRpcCryptoCipherTransformation();
        if (transformation == null || transformation.length() == 0) {
            return null;
        }
        Properties properties = new Properties();
        properties.setProperty("commons.crypto.secure.random.classes", this.rpcServer.conf.get("hbase.crypto.sasl.encryption.aes.crypto.random", "org.apache.commons.crypto.random.JavaCryptoRandom"));
        properties.setProperty("commons.crypto.cipher.classes", this.rpcServer.conf.get("hbase.rpc.crypto.encryption.aes.cipher.class", "org.apache.commons.crypto.cipher.JceCipher"));
        int cipherKeyBits = this.rpcServer.conf.getInt("hbase.rpc.crypto.encryption.aes.cipher.keySizeBits", 128);
        if (cipherKeyBits % 8 != 0) {
            throw new IllegalArgumentException("The AES cipher key size in bits should be a multiple of byte");
        }
        int len = cipherKeyBits / 8;
        byte[] inKey = new byte[len];
        byte[] outKey = new byte[len];
        byte[] inIv = new byte[len];
        byte[] outIv = new byte[len];
        try {
            CryptoRandom secureRandom = CryptoRandomFactory.getCryptoRandom((Properties)properties);
            secureRandom.nextBytes(inKey);
            secureRandom.nextBytes(outKey);
            secureRandom.nextBytes(inIv);
            secureRandom.nextBytes(outIv);
            cryptoAES = new CryptoAES(transformation, properties, inKey, outKey, inIv, outIv);
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new UnsupportedCryptoException(ex.getMessage(), (Throwable)ex);
        }
        RPCProtos.CryptoCipherMeta.Builder ccmBuilder = RPCProtos.CryptoCipherMeta.newBuilder();
        ccmBuilder.setTransformation(transformation);
        ccmBuilder.setInIv(this.getByteString(outIv));
        ccmBuilder.setInKey(this.getByteString(outKey));
        ccmBuilder.setOutIv(this.getByteString(inIv));
        ccmBuilder.setOutKey(this.getByteString(inKey));
        RPCProtos.ConnectionHeaderResponse resp = RPCProtos.ConnectionHeaderResponse.newBuilder().setCryptoCipherMeta(ccmBuilder).build();
        return Pair.newPair((Object)resp, (Object)cryptoAES);
    }

    private ByteString getByteString(byte[] bytes) {
        return bytes.length == 0 ? ByteString.EMPTY : ByteString.copyFrom((byte[])bytes);
    }

    private UserGroupInformation createUser(RPCProtos.ConnectionHeader head) {
        UserGroupInformation ugi = null;
        if (!head.hasUserInfo()) {
            return null;
        }
        RPCProtos.UserInformation userInfoProto = head.getUserInfo();
        String effectiveUser = null;
        if (userInfoProto.hasEffectiveUser()) {
            effectiveUser = userInfoProto.getEffectiveUser();
        }
        String realUser = null;
        if (userInfoProto.hasRealUser()) {
            realUser = userInfoProto.getRealUser();
        }
        if (effectiveUser != null) {
            if (realUser != null) {
                UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)realUser);
                ugi = UserGroupInformation.createProxyUser((String)effectiveUser, (UserGroupInformation)realUserUgi);
            } else {
                ugi = UserGroupInformation.createRemoteUser((String)effectiveUser);
            }
        }
        return ugi;
    }

    protected final void disposeSasl() {
        if (this.saslServer != null) {
            this.saslServer.dispose();
            this.saslServer = null;
        }
    }

    protected final void doRawSaslReply(SaslStatus status, Writable rv, String errorClass, String error) throws IOException {
        BufferChain bc;
        try (ByteBufferOutputStream saslResponse = new ByteBufferOutputStream(256);
             DataOutputStream out = new DataOutputStream((OutputStream)saslResponse);){
            out.writeInt(status.state);
            if (status == SaslStatus.SUCCESS) {
                rv.write((DataOutput)out);
            } else {
                WritableUtils.writeString((DataOutput)out, (String)errorClass);
                WritableUtils.writeString((DataOutput)out, (String)error);
            }
            bc = new BufferChain(saslResponse.getByteBuffer());
        }
        this.doRespond(() -> bc);
    }

    HBaseSaslRpcServer getOrCreateSaslServer() throws IOException {
        if (this.saslServer == null) {
            this.saslServer = new HBaseSaslRpcServer(this.provider, this.rpcServer.saslProps, this.rpcServer.secretManager);
        }
        return this.saslServer;
    }

    void finishSaslNegotiation() throws IOException {
        String negotiatedQop = this.saslServer.getNegotiatedQop();
        SaslUtil.verifyNegotiatedQop((String)this.saslServer.getRequestedQop(), (String)negotiatedQop);
        this.ugi = this.provider.getAuthorizedUgi(this.saslServer.getAuthorizationID(), this.rpcServer.secretManager);
        RpcServer.LOG.debug("SASL server context established. Authenticated client: {}. Negotiated QoP is {}", (Object)this.ugi, (Object)negotiatedQop);
        this.rpcServer.metrics.authenticationSuccess();
        RpcServer.AUDITLOG.info("Auth successful for " + this.ugi);
    }

    public void processOneRpc(ByteBuff buf) throws IOException, InterruptedException {
        if (this.connectionHeaderRead) {
            this.processRequest(buf);
        } else {
            this.processConnectionHeader(buf);
            this.callCleanupIfNeeded();
            this.connectionHeaderRead = true;
            if (this.rpcServer.needAuthorization() && !this.authorizeConnection()) {
                throw new AccessDeniedException("Connection from " + this + " for service " + this.connectionHeader.getServiceName() + " is unauthorized for user: " + this.ugi);
            }
            this.user = this.rpcServer.userProvider.create(this.ugi);
        }
    }

    private boolean authorizeConnection() throws IOException {
        try {
            if (this.ugi != null && this.ugi.getRealUser() != null && this.provider.supportsProtocolAuthentication()) {
                ProxyUsers.authorize((UserGroupInformation)this.ugi, (String)this.getHostAddress(), (Configuration)this.rpcServer.conf);
            }
            this.rpcServer.authorize(this.ugi, this.connectionHeader, this.getHostInetAddress());
            this.rpcServer.metrics.authorizationSuccess();
        }
        catch (AuthorizationException ae) {
            if (RpcServer.LOG.isDebugEnabled()) {
                RpcServer.LOG.debug("Connection authorization failed: " + ae.getMessage(), (Throwable)ae);
            }
            this.rpcServer.metrics.authorizationFailure();
            this.doRespond(this.getErrorResponse(ae.getMessage(), (Exception)new AccessDeniedException((Throwable)ae)));
            return false;
        }
        return true;
    }

    private CodedInputStream createCis(ByteBuff buf) {
        CodedInputStream cis = buf.hasArray() ? UnsafeByteOperations.unsafeWrap((byte[])buf.array(), (int)(buf.arrayOffset() + buf.position()), (int)buf.limit()).newCodedInput() : UnsafeByteOperations.unsafeWrap((ByteInput)new ByteBuffByteInput(buf, buf.limit()), (int)0, (int)buf.limit()).newCodedInput();
        cis.enableAliasing(true);
        return cis;
    }

    private void processConnectionHeader(ByteBuff buf) throws IOException {
        String version;
        this.connectionHeader = RPCProtos.ConnectionHeader.parseFrom((CodedInputStream)this.createCis(buf));
        if (this.connectionHeader.getAttributeList().isEmpty()) {
            this.connectionAttributes = Collections.emptyMap();
        } else {
            this.connectionAttributes = Maps.newHashMapWithExpectedSize((int)this.connectionHeader.getAttributeList().size());
            for (HBaseProtos.NameBytesPair nameBytesPair : this.connectionHeader.getAttributeList()) {
                this.connectionAttributes.put(nameBytesPair.getName(), nameBytesPair.getValue().toByteArray());
            }
        }
        String serviceName = this.connectionHeader.getServiceName();
        if (serviceName == null) {
            throw new EmptyServiceNameException();
        }
        this.service = RpcServer.getService(this.rpcServer.services, serviceName);
        if (this.service == null) {
            throw new UnknownServiceException(serviceName);
        }
        this.setupCellBlockCodecs();
        this.sendConnectionHeaderResponseIfNeeded();
        UserGroupInformation protocolUser = this.createUser(this.connectionHeader);
        if (!this.useSasl) {
            this.ugi = protocolUser;
            if (this.ugi != null) {
                this.ugi.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.SIMPLE);
            }
            if (this.authenticatedWithFallback) {
                RpcServer.LOG.warn("Allowed fallback to SIMPLE auth for {} connecting from {}", (Object)this.ugi, (Object)this.getHostAddress());
            }
        } else {
            this.ugi.setAuthenticationMethod(this.provider.getSaslAuthMethod().getAuthMethod());
            if (protocolUser != null && !protocolUser.getUserName().equals(this.ugi.getUserName())) {
                if (!this.provider.supportsProtocolAuthentication()) {
                    throw new AccessDeniedException("Authenticated user (" + this.ugi + ") doesn't match what the client claims to be (" + protocolUser + ")");
                }
                UserGroupInformation realUser = this.ugi;
                this.ugi = UserGroupInformation.createProxyUser((String)protocolUser.getUserName(), (UserGroupInformation)realUser);
                this.ugi.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.PROXY);
            }
        }
        if (this.connectionHeader.hasVersionInfo()) {
            this.retryImmediatelySupported = VersionInfoUtil.hasMinimumVersion(this.getVersionInfo(), 1, 2);
            version = this.connectionHeader.getVersionInfo().getVersion();
        } else {
            version = "UNKNOWN";
        }
        RpcServer.AUDITLOG.info("Connection from {}:{}, version={}, sasl={}, ugi={}, service={}", new Object[]{this.hostAddress, this.remotePort, version, this.useSasl, this.ugi, serviceName});
    }

    private void sendConnectionHeaderResponseIfNeeded() throws FatalConnectionException {
        final Pair<RPCProtos.ConnectionHeaderResponse, CryptoAES> pair = this.setupCryptoCipher();
        if (pair == null) {
            return;
        }
        try {
            BufferChain bc;
            int size = ((RPCProtos.ConnectionHeaderResponse)pair.getFirst()).getSerializedSize();
            try (ByteBufferOutputStream bbOut = new ByteBufferOutputStream(4 + size);
                 DataOutputStream out = new DataOutputStream((OutputStream)bbOut);){
                out.writeInt(size);
                ((RPCProtos.ConnectionHeaderResponse)pair.getFirst()).writeTo((OutputStream)out);
                bc = new BufferChain(bbOut.getByteBuffer());
            }
            this.doRespond(new RpcResponse(){

                @Override
                public BufferChain getResponse() {
                    return bc;
                }

                @Override
                public void done() {
                    ServerRpcConnection.this.saslServer.switchToCryptoAES((CryptoAES)pair.getSecond());
                }
            });
        }
        catch (IOException ex) {
            throw new UnsupportedCryptoException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected abstract void doRespond(RpcResponse var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processRequest(ByteBuff buf) throws IOException, InterruptedException {
        long totalRequestSize = buf.limit();
        int offset = 0;
        CodedInputStream cis = this.createCis(buf);
        int headerSize = cis.readRawVarint32();
        offset = cis.getTotalBytesRead();
        RPCProtos.RequestHeader.Builder builder = RPCProtos.RequestHeader.newBuilder();
        ProtobufUtil.mergeFrom((Message.Builder)builder, (CodedInputStream)cis, (int)headerSize);
        RPCProtos.RequestHeader header = (RPCProtos.RequestHeader)builder.build();
        offset += headerSize;
        Context traceCtx = GlobalOpenTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), (Object)header.getTraceInfo(), getter);
        Span span = TraceUtil.createRemoteSpan((String)"RpcServer.process", (Context)traceCtx);
        try (Scope ignored = span.makeCurrent();){
            ServerCall<?> call;
            CellScanner cellScanner;
            Message param;
            Descriptors.MethodDescriptor md;
            int id;
            block42: {
                id = header.getCallId();
                if (this.rpcServer.server != null && this.rpcServer.server.isAborted()) {
                    RegionServerAbortedException serverIsAborted = new RegionServerAbortedException("Server " + this.rpcServer.server.getServerName() + " aborting");
                    this.rpcServer.metrics.exception((Throwable)serverIsAborted);
                    this.sendErrorResponseForCall(id, totalRequestSize, span, serverIsAborted.getMessage(), (Throwable)serverIsAborted);
                    return;
                }
                if (RpcServer.LOG.isTraceEnabled()) {
                    RpcServer.LOG.trace("RequestHeader " + TextFormat.shortDebugString((MessageOrBuilder)header) + " totalRequestSize: " + totalRequestSize + " bytes");
                }
                if (totalRequestSize + this.rpcServer.callQueueSizeInBytes.sum() > this.rpcServer.maxQueueSizeInBytes) {
                    this.rpcServer.metrics.exception((Throwable)RpcServer.CALL_QUEUE_TOO_BIG_EXCEPTION);
                    this.sendErrorResponseForCall(id, totalRequestSize, span, "Call queue is full on " + this.rpcServer.server.getServerName() + ", is hbase.ipc.server.max.callqueue.size too small?", (Throwable)RpcServer.CALL_QUEUE_TOO_BIG_EXCEPTION);
                    return;
                }
                md = null;
                param = null;
                cellScanner = null;
                try {
                    if (header.hasRequestParam() && header.getRequestParam()) {
                        md = this.service.getDescriptorForType().findMethodByName(header.getMethodName());
                        if (md == null) {
                            throw new UnsupportedOperationException(header.getMethodName());
                        }
                        builder = this.service.getRequestPrototype(md).newBuilderForType();
                        cis.resetSizeCounter();
                        int paramSize = cis.readRawVarint32();
                        offset += cis.getTotalBytesRead();
                        if (builder != null) {
                            ProtobufUtil.mergeFrom((Message.Builder)builder, (CodedInputStream)cis, (int)paramSize);
                            param = builder.build();
                        }
                        offset += paramSize;
                        if (!header.hasCellBlockMeta()) break block42;
                    } else {
                        String msg = "Invalid request header: " + TextFormat.shortDebugString((MessageOrBuilder)header) + ", should have param set in it";
                        RpcServer.LOG.warn(msg);
                        throw new DoNotRetryIOException(msg);
                    }
                    buf.position(offset);
                    ByteBuff dup = buf.duplicate();
                    dup.limit(offset + header.getCellBlockMeta().getLength());
                    cellScanner = this.rpcServer.cellBlockBuilder.createCellScannerReusingBuffers(this.codec, this.compressionCodec, dup);
                }
                catch (Throwable thrown) {
                    InetSocketAddress address = this.rpcServer.getListenerAddress();
                    String msg = (address != null ? address : "(channel closed)") + " is unable to read call parameter from client " + this.getHostAddress();
                    RpcServer.LOG.warn(msg, thrown);
                    this.rpcServer.metrics.exception(thrown);
                    Throwable responseThrowable = thrown instanceof LinkageError ? new DoNotRetryIOException(thrown) : (thrown instanceof UnsupportedOperationException ? new DoNotRetryIOException(thrown) : thrown);
                    this.sendErrorResponseForCall(id, totalRequestSize, span, msg + "; " + responseThrowable.getMessage(), responseThrowable);
                    if (ignored != null) {
                        if (var12_11 != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable) {
                                var12_11.addSuppressed(throwable);
                            }
                        } else {
                            ignored.close();
                        }
                    }
                    if (span == null) return;
                    span.end();
                    return;
                }
            }
            int timeout = 0;
            if (header.hasTimeout() && header.getTimeout() > 0) {
                timeout = Math.max(this.rpcServer.minClientRequestTimeout, header.getTimeout());
            }
            if (this.rpcServer.scheduler.dispatch(new CallRunner(this.rpcServer, call = this.createCall(id, this.service, md, header, param, cellScanner, totalRequestSize, this.addr, timeout, this.callCleanup)))) {
                span = null;
                return;
            }
            this.rpcServer.callQueueSizeInBytes.add(-1L * call.getSize());
            this.rpcServer.metrics.exception((Throwable)RpcServer.CALL_QUEUE_TOO_BIG_EXCEPTION);
            call.setResponse(null, null, (Throwable)RpcServer.CALL_QUEUE_TOO_BIG_EXCEPTION, "Call queue is full on " + this.rpcServer.server.getServerName() + ", too many items queued ?");
            TraceUtil.setError((Span)span, (Throwable)RpcServer.CALL_QUEUE_TOO_BIG_EXCEPTION);
            call.sendResponseIfReady();
            return;
        }
        finally {
            if (span != null) {
                span.end();
            }
        }
    }

    private void sendErrorResponseForCall(int id, long totalRequestSize, Span span, String msg, Throwable responseThrowable) throws IOException {
        ServerCall<?> failedcall = this.createCall(id, this.service, null, null, null, null, totalRequestSize, null, 0, this.callCleanup);
        failedcall.setResponse(null, null, responseThrowable, msg);
        TraceUtil.setError((Span)span, (Throwable)responseThrowable);
        failedcall.sendResponseIfReady();
    }

    protected final RpcResponse getErrorResponse(String msg, Exception e) throws IOException {
        RPCProtos.ResponseHeader.Builder headerBuilder = RPCProtos.ResponseHeader.newBuilder().setCallId(-1);
        ServerCall.setExceptionResponse(e, msg, headerBuilder);
        ByteBuffer headerBuf = ServerCall.createHeaderAndMessageBytes(null, (Message)headerBuilder.build(), 0, null);
        BufferChain buf = new BufferChain(headerBuf);
        return () -> buf;
    }

    private void doBadPreambleHandling(String msg) throws IOException {
        this.doBadPreambleHandling(msg, (Exception)new FatalConnectionException(msg));
    }

    private void doBadPreambleHandling(String msg, Exception e) throws IOException {
        RpcServer.LOG.warn(msg, (Throwable)e);
        this.doRespond(this.getErrorResponse(msg, e));
    }

    private void doPreambleResponse(Message resp) throws IOException {
        RPCProtos.ResponseHeader header = RPCProtos.ResponseHeader.newBuilder().setCallId(-1).build();
        ByteBuffer buf = ServerCall.createHeaderAndMessageBytes(resp, (Message)header, 0, null);
        BufferChain bufChain = new BufferChain(buf);
        this.doRespond(() -> bufChain);
    }

    private boolean doConnectionRegistryResponse() throws IOException {
        if (!(this.rpcServer.server instanceof HRegionServer)) {
            return false;
        }
        String clusterId = ((HRegionServer)this.rpcServer.server).getClusterId();
        RpcServer.LOG.debug("Response connection registry, clusterId = '{}'", (Object)clusterId);
        if (clusterId == null) {
            return false;
        }
        RegistryProtos.GetConnectionRegistryResponse resp = RegistryProtos.GetConnectionRegistryResponse.newBuilder().setClusterId(clusterId).build();
        this.doPreambleResponse((Message)resp);
        return true;
    }

    private void doSecurityPreambleResponse() throws IOException {
        if (this.rpcServer.isSecurityEnabled) {
            RPCProtos.SecurityPreamableResponse resp = RPCProtos.SecurityPreamableResponse.newBuilder().setServerPrincipal(this.rpcServer.serverPrincipal).build();
            this.doPreambleResponse((Message)resp);
        } else {
            this.doRespond(this.getErrorResponse("security is not enabled", (Exception)new SecurityNotEnabledException()));
        }
    }

    protected final void callCleanupIfNeeded() {
        if (this.callCleanup != null) {
            this.callCleanup.run();
            this.callCleanup = null;
        }
    }

    protected final PreambleResponse processPreamble(ByteBuffer preambleBuffer) throws IOException {
        assert (preambleBuffer.remaining() == 6);
        if (ByteBufferUtils.equals((ByteBuffer)preambleBuffer, (int)preambleBuffer.position(), (int)6, (byte[])RpcClient.REGISTRY_PREAMBLE_HEADER, (int)0, (int)6) && this.doConnectionRegistryResponse()) {
            return PreambleResponse.CLOSE;
        }
        if (ByteBufferUtils.equals((ByteBuffer)preambleBuffer, (int)preambleBuffer.position(), (int)6, (byte[])RpcClient.SECURITY_PREAMBLE_HEADER, (int)0, (int)6)) {
            this.doSecurityPreambleResponse();
            return PreambleResponse.CONTINUE;
        }
        if (!ByteBufferUtils.equals((ByteBuffer)preambleBuffer, (int)preambleBuffer.position(), (int)4, (byte[])HConstants.RPC_HEADER, (int)0, (int)4)) {
            this.doBadPreambleHandling("Expected HEADER=" + Bytes.toStringBinary((byte[])HConstants.RPC_HEADER) + " but received HEADER=" + Bytes.toStringBinary((byte[])ByteBufferUtils.toBytes((ByteBuffer)preambleBuffer, (int)preambleBuffer.position(), (int)HConstants.RPC_HEADER.length), (int)0, (int)HConstants.RPC_HEADER.length) + " from " + this.toString());
            return PreambleResponse.CLOSE;
        }
        int version = preambleBuffer.get(preambleBuffer.position() + 4) & 0xFF;
        byte authByte = preambleBuffer.get(preambleBuffer.position() + 5);
        if (version != 0) {
            String msg = this.getFatalConnectionString(version, authByte);
            this.doBadPreambleHandling(msg, (Exception)new WrongVersionException(msg));
            return PreambleResponse.CLOSE;
        }
        this.provider = this.saslProviders.selectProvider(authByte);
        if (this.provider == null) {
            String msg = this.getFatalConnectionString(version, authByte);
            this.doBadPreambleHandling(msg, (Exception)new BadAuthException(msg));
            return PreambleResponse.CLOSE;
        }
        if (this.rpcServer.isSecurityEnabled && this.isSimpleAuthentication()) {
            if (this.rpcServer.allowFallbackToSimpleAuth) {
                this.rpcServer.metrics.authenticationFallback();
                this.authenticatedWithFallback = true;
            } else {
                AccessDeniedException ae = new AccessDeniedException("Authentication is required");
                this.doRespond(this.getErrorResponse(ae.getMessage(), (Exception)ae));
                return PreambleResponse.CLOSE;
            }
        }
        if (!this.rpcServer.isSecurityEnabled && !this.isSimpleAuthentication()) {
            this.doRawSaslReply(SaslStatus.SUCCESS, (Writable)new IntWritable(-88), null, null);
            this.provider = this.saslProviders.getSimpleProvider();
            this.skipInitialSaslHandshake = true;
        }
        this.useSasl = !(this.provider instanceof SimpleSaslServerAuthenticationProvider);
        return PreambleResponse.SUCCEED;
    }

    boolean isSimpleAuthentication() {
        return Objects.requireNonNull(this.provider) instanceof SimpleSaslServerAuthenticationProvider;
    }

    public abstract boolean isConnectionOpen();

    public abstract ServerCall<?> createCall(int var1, BlockingService var2, Descriptors.MethodDescriptor var3, RPCProtos.RequestHeader var4, Message var5, CellScanner var6, long var7, InetAddress var9, int var10, RpcServer.CallCleanup var11);

    private static class ByteBuffByteInput
    extends ByteInput {
        private ByteBuff buf;
        private int length;

        ByteBuffByteInput(ByteBuff buf, int length) {
            this.buf = buf;
            this.length = length;
        }

        public byte read(int offset) {
            return this.buf.get(offset);
        }

        public int read(int offset, byte[] out, int outOffset, int len) {
            this.buf.get(offset, out, outOffset, len);
            return len;
        }

        public int read(int offset, ByteBuffer out) {
            int len = out.remaining();
            this.buf.get(out, offset, len);
            return len;
        }

        public int size() {
            return this.length;
        }
    }

    protected static enum PreambleResponse {
        SUCCEED,
        CONTINUE,
        CLOSE;

    }
}

