/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup;

import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.BackupProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class BackupTableInfo {
    private TableName table;
    private String snapshotName = null;

    public BackupTableInfo() {
    }

    public BackupTableInfo(TableName table, String targetRootDir, String backupId) {
        this.table = table;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public TableName getTable() {
        return this.table;
    }

    public static BackupTableInfo convert(BackupProtos.BackupTableInfo proto) {
        BackupTableInfo bs = new BackupTableInfo();
        bs.table = ProtobufUtil.toTableName((HBaseProtos.TableName)proto.getTableName());
        if (proto.hasSnapshotName()) {
            bs.snapshotName = proto.getSnapshotName();
        }
        return bs;
    }

    public BackupProtos.BackupTableInfo toProto() {
        BackupProtos.BackupTableInfo.Builder builder = BackupProtos.BackupTableInfo.newBuilder();
        if (this.snapshotName != null) {
            builder.setSnapshotName(this.snapshotName);
        }
        builder.setTableName(ProtobufUtil.toProtoTableName((TableName)this.table));
        return builder.build();
    }
}

