/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.state;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class Graph {
    private String name;
    private Graph parent;
    private Set<Node> nodes = new HashSet<Node>();
    private Set<Graph> subgraphs = new HashSet<Graph>();

    public Graph(String name, Graph parent) {
        this.name = name;
        this.parent = parent;
    }

    public Graph(String name) {
        this(name, null);
    }

    public Graph() {
        this("graph", null);
    }

    public String getName() {
        return this.name;
    }

    public Graph getParent() {
        return this.parent;
    }

    private Node newNode(String id) {
        Node ret = new Node(id);
        this.nodes.add(ret);
        return ret;
    }

    public Node getNode(String id) {
        for (Node node : this.nodes) {
            if (!node.id.equals(id)) continue;
            return node;
        }
        return this.newNode(id);
    }

    public Graph newSubGraph(String name) {
        Graph ret = new Graph(name, this);
        this.subgraphs.add(ret);
        return ret;
    }

    public void addSubGraph(Graph graph) {
        this.subgraphs.add(graph);
        graph.parent = this;
    }

    private static String wrapSafeString(String label) {
        if (label.indexOf(44) >= 0 && label.length() > 14) {
            label = label.replaceAll(",", ",\n");
        }
        label = "\"" + StringEscapeUtils.escapeJava((String)label) + "\"";
        return label;
    }

    public String generateGraphViz(String indent) {
        StringBuilder sb = new StringBuilder();
        if (this.parent == null) {
            sb.append("digraph " + this.name + " {\n").append(String.format("graph [ label=%s, fontsize=24, fontname=Helvetica];%n", Graph.wrapSafeString(this.name))).append("node [fontsize=12, fontname=Helvetica];\n").append("edge [fontsize=9, fontcolor=blue, fontname=Arial];\n");
        } else {
            sb.append("subgraph cluster_" + this.name + " {\nlabel=\"" + this.name + "\"\n");
        }
        for (Graph g : this.subgraphs) {
            String ginfo = g.generateGraphViz(indent + "  ");
            sb.append(ginfo).append("\n");
        }
        for (Node n : this.nodes) {
            sb.append(String.format("%s%s [ label = %s ];%n", indent, Graph.wrapSafeString(n.getUniqueId()), n.id));
            List<Edge> combinedOuts = Graph.combineEdges(n.outs);
            for (Edge e : combinedOuts) {
                sb.append(String.format("%s%s -> %s [ label = %s ];%n", indent, Graph.wrapSafeString(e.from.getUniqueId()), Graph.wrapSafeString(e.to.getUniqueId()), Graph.wrapSafeString(e.label)));
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    public String generateGraphViz() {
        return this.generateGraphViz("");
    }

    public void save(String filepath) throws IOException {
        try (OutputStreamWriter fout = new OutputStreamWriter((OutputStream)new FileOutputStream(filepath), StandardCharsets.UTF_8);){
            fout.write(this.generateGraphViz());
        }
    }

    public static List<Edge> combineEdges(List<Edge> edges) {
        ArrayList<Edge> ret = new ArrayList<Edge>();
        for (Edge edge : edges) {
            boolean found = false;
            for (int i = 0; i < ret.size(); ++i) {
                Edge current = (Edge)ret.get(i);
                if (!edge.sameAs(current)) continue;
                ret.set(i, current.combine(edge));
                found = true;
                break;
            }
            if (found) continue;
            ret.add(edge);
        }
        return ret;
    }

    public class Node {
        Graph parent;
        String id;
        List<Edge> ins;
        List<Edge> outs;

        public Node(String id) {
            this.id = id;
            this.parent = Graph.this;
            this.ins = new ArrayList<Edge>();
            this.outs = new ArrayList<Edge>();
        }

        public Graph getParent() {
            return this.parent;
        }

        public Node addEdge(Node to, String info) {
            Edge e = new Edge(this, to, info);
            this.outs.add(e);
            to.ins.add(e);
            return this;
        }

        public String getUniqueId() {
            return Graph.this.name + "." + this.id;
        }
    }

    public class Edge {
        Node from;
        Node to;
        String label;

        public Edge(Node from, Node to, String info) {
            this.from = from;
            this.to = to;
            this.label = info;
        }

        public boolean sameAs(Edge rhs) {
            return this.from == rhs.from && this.to == rhs.to;
        }

        public Edge combine(Edge rhs) {
            String newlabel = this.label + "," + rhs.label;
            return new Edge(this.from, this.to, newlabel);
        }
    }
}

