/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.hdfs.tools.GetGroups;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.DefaultImpersonationProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.tools.GetUserMappingsProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRouterUserMappings {
    private static final Logger LOG = LoggerFactory.getLogger(TestRouterUserMappings.class);
    private MiniRouterDFSCluster cluster;
    private Router router;
    private Configuration conf;
    private static final long GROUP_REFRESH_TIMEOUT_SEC = 1L;
    private static final String ROUTER_NS = "rbfns";
    private static final String HDFS_SCHEMA = "hdfs://";
    private static final String LOOPBACK_ADDRESS = "127.0.0.1";
    private String tempResource = null;

    @Before
    public void setUp() {
        this.conf = new Configuration(false);
        this.conf.setClass("hadoop.security.group.mapping", MockUnixGroupsMapping.class, GroupMappingServiceProvider.class);
        this.conf.setLong("hadoop.security.groups.cache.secs", 1L);
        this.conf = new RouterConfigBuilder(this.conf).rpc().admin().build();
        Groups.getUserToGroupsMappingService((Configuration)this.conf);
    }

    private String setUpMultiRoutersAndReturnDefaultFs() throws Exception {
        this.cluster = new MiniRouterDFSCluster(true, 2);
        this.cluster.addRouterOverrides(this.conf);
        this.cluster.startRouters();
        this.conf.set("dfs.internal.nameservices", "ns0,ns1");
        this.conf.set("dfs.nameservices", "ns0,ns1,rbfns");
        this.conf.set("dfs.client.failover.proxy.provider.rbfns", ConfiguredFailoverProxyProvider.class.getCanonicalName());
        this.conf.set("fs.defaultFS", "hdfs://rbfns");
        this.conf.set("dfs.ha.namenodes.rbfns", "r1,r2");
        List<MiniRouterDFSCluster.RouterContext> routers = this.cluster.getRouters();
        for (int i = 0; i < routers.size(); ++i) {
            MiniRouterDFSCluster.RouterContext context = routers.get(i);
            this.conf.set("dfs.namenode.rpc-address.rbfns.r" + (i + 1), "127.0.0.1:" + context.getRouter().getRpcServerAddress().getPort());
        }
        return "hdfs://rbfns";
    }

    @Test
    public void testRefreshSuperUserGroupsConfiguration() throws Exception {
        this.testRefreshSuperUserGroupsConfigurationInternal(this.setUpMultiRoutersAndReturnDefaultFs());
    }

    @Test
    public void testGroupMappingRefresh() throws Exception {
        this.testGroupMappingRefreshInternal(this.setUpMultiRoutersAndReturnDefaultFs());
    }

    private void testRefreshSuperUserGroupsConfigurationInternal(String defaultFs) throws Exception {
        String superUser = "super_user";
        ArrayList<String> groupNames1 = new ArrayList<String>();
        groupNames1.add("gr1");
        groupNames1.add("gr2");
        ArrayList<String> groupNames2 = new ArrayList<String>();
        groupNames2.add("gr3");
        groupNames2.add("gr4");
        LinkedHashSet<String> groupNamesSet1 = new LinkedHashSet<String>();
        groupNamesSet1.addAll(groupNames1);
        LinkedHashSet<String> groupNamesSet2 = new LinkedHashSet<String>();
        groupNamesSet2.addAll(groupNames2);
        String userKeyGroups = DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey("super_user");
        String userKeyHosts = DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey("super_user");
        this.conf.set(userKeyGroups, "gr3,gr4,gr5");
        this.conf.set(userKeyHosts, LOOPBACK_ADDRESS);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)this.conf);
        UserGroupInformation ugi1 = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        UserGroupInformation ugi2 = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        UserGroupInformation suUgi = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        Mockito.when((Object)ugi1.getRealUser()).thenReturn((Object)suUgi);
        Mockito.when((Object)ugi2.getRealUser()).thenReturn((Object)suUgi);
        Mockito.when((Object)suUgi.getShortUserName()).thenReturn((Object)"super_user");
        Mockito.when((Object)suUgi.getUserName()).thenReturn((Object)"super_userL");
        Mockito.when((Object)ugi1.getShortUserName()).thenReturn((Object)"user1");
        Mockito.when((Object)ugi2.getShortUserName()).thenReturn((Object)"user2");
        Mockito.when((Object)ugi1.getUserName()).thenReturn((Object)"userL1");
        Mockito.when((Object)ugi2.getUserName()).thenReturn((Object)"userL2");
        Mockito.when((Object)ugi1.getGroups()).thenReturn(groupNames1);
        Mockito.when((Object)ugi2.getGroups()).thenReturn(groupNames2);
        Mockito.when((Object)ugi1.getGroupsSet()).thenReturn(groupNamesSet1);
        Mockito.when((Object)ugi2.getGroupsSet()).thenReturn(groupNamesSet2);
        LambdaTestUtils.intercept(AuthorizationException.class, () -> ProxyUsers.authorize((UserGroupInformation)ugi1, (String)LOOPBACK_ADDRESS));
        try {
            ProxyUsers.authorize((UserGroupInformation)ugi2, (String)LOOPBACK_ADDRESS);
            LOG.info("auth for {} succeeded", (Object)ugi2.getUserName());
        }
        catch (AuthorizationException e) {
            Assert.fail((String)("first auth for " + ugi2.getShortUserName() + " should've succeeded: " + e.getLocalizedMessage()));
        }
        String rsrc = "testGroupMappingRefresh_rsrc.xml";
        this.tempResource = TestRouterUserMappings.addNewConfigResource(rsrc, userKeyGroups, "gr2", userKeyHosts, LOOPBACK_ADDRESS);
        this.conf.set("fs.defaultFS", defaultFs);
        DFSAdmin admin = new DFSAdmin(this.conf);
        String[] args = new String[]{"-refreshSuperUserGroupsConfiguration"};
        admin.run(args);
        LambdaTestUtils.intercept(AuthorizationException.class, () -> ProxyUsers.authorize((UserGroupInformation)ugi2, (String)LOOPBACK_ADDRESS));
        try {
            ProxyUsers.authorize((UserGroupInformation)ugi1, (String)LOOPBACK_ADDRESS);
            LOG.info("auth for {} succeeded", (Object)ugi1.getUserName());
        }
        catch (AuthorizationException e) {
            Assert.fail((String)("second auth for " + ugi1.getShortUserName() + " should've succeeded: " + e.getLocalizedMessage()));
        }
        this.testGroupsForUserCLI(this.conf, "user");
        this.testGroupsForUserProtocol(this.conf, "user");
    }

    private void testGroupsForUserCLI(Configuration config, String username) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream oldOut = System.out;
        System.setOut(new PrintStream(out));
        new GetGroups(config).run(new String[]{username});
        Assert.assertTrue((String)("Wrong output: " + out), (boolean)out.toString().startsWith(username + " : " + username));
        out.reset();
        System.setOut(oldOut);
    }

    private void testGroupsForUserProtocol(Configuration config, String username) throws IOException {
        GetUserMappingsProtocol proto = (GetUserMappingsProtocol)NameNodeProxies.createProxy((Configuration)config, (URI)FileSystem.getDefaultUri((Configuration)config), GetUserMappingsProtocol.class).getProxy();
        Object[] groups = proto.getGroupsForUser(username);
        Assert.assertArrayEquals((Object[])new String[]{"user1", "user2"}, (Object[])groups);
    }

    private void testGroupMappingRefreshInternal(String defaultFs) throws Exception {
        Groups groups = Groups.getUserToGroupsMappingService((Configuration)this.conf);
        String user = "test_user123";
        LOG.info("First attempt:");
        List g1 = groups.getGroups(user);
        LOG.info("Group 1 :{}", (Object)g1);
        LOG.info("Second attempt, should be the same:");
        List g2 = groups.getGroups(user);
        LOG.info("Group 2 :{}", (Object)g2);
        for (int i = 0; i < g2.size(); ++i) {
            Assert.assertEquals((String)"Should be same group ", g1.get(i), g2.get(i));
        }
        this.conf.set("fs.defaultFS", defaultFs);
        DFSAdmin admin = new DFSAdmin(this.conf);
        String[] args = new String[]{"-refreshUserToGroupsMappings"};
        admin.run(args);
        LOG.info("Third attempt(after refresh command), should be different:");
        List g3 = groups.getGroups(user);
        LOG.info("Group 3:{}", (Object)g3);
        for (int i = 0; i < g3.size(); ++i) {
            Assert.assertNotEquals((String)("Should be different group: " + (String)g1.get(i) + " and " + (String)g3.get(i)), g1.get(i), g3.get(i));
        }
        LOG.info("Fourth attempt(after timeout), should be different:");
        GenericTestUtils.waitFor(() -> {
            List g4;
            try {
                g4 = groups.getGroups(user);
            }
            catch (IOException e) {
                LOG.debug("Failed to get groups for user:{}", (Object)user);
                return false;
            }
            LOG.info("Group 4 : {}", (Object)g4);
            return !g3.equals(g4);
        }, (long)50L, (long)Math.toIntExact(TimeUnit.SECONDS.toMillis(30L)));
    }

    public static String addNewConfigResource(String rsrcName, String keyGroup, String groups, String keyHosts, String hosts) throws FileNotFoundException, UnsupportedEncodingException {
        Configuration conf = new Configuration();
        URL url = conf.getResource("hdfs-site.xml");
        String urlPath = URLDecoder.decode(url.getPath(), "UTF-8");
        Path p = new Path(urlPath);
        Path dir = p.getParent();
        String tmp = dir.toString() + "/" + rsrcName;
        StringBuilder newResource = new StringBuilder().append("<configuration>").append("<property>").append("<name>").append(keyGroup).append("</name>").append("<value>").append(groups).append("</value>").append("</property>").append("<property>").append("<name>").append(keyHosts).append("</name>").append("<value>").append(hosts).append("</value>").append("</property>").append("</configuration>");
        PrintWriter writer = new PrintWriter(new FileOutputStream(tmp));
        writer.println(newResource.toString());
        writer.close();
        Configuration.addDefaultResource((String)rsrcName);
        return tmp;
    }

    @After
    public void tearDown() {
        if (this.router != null) {
            this.router.shutDown();
            this.router = null;
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
        if (this.tempResource != null) {
            File f = new File(this.tempResource);
            f.delete();
            this.tempResource = null;
        }
    }

    public static class MockUnixGroupsMapping
    implements GroupMappingServiceProvider {
        private static int i = 0;

        public List<String> getGroups(String user) throws IOException {
            LOG.info("Getting groups in MockUnixGroupsMapping");
            String g1 = user + (10 * i + 1);
            String g2 = user + (10 * i + 2);
            ArrayList<String> l = new ArrayList<String>(2);
            l.add(g1);
            l.add(g2);
            ++i;
            return l;
        }

        public void cacheGroupsRefresh() throws IOException {
            LOG.info("Refreshing groups in MockUnixGroupsMapping");
        }

        public void cacheGroupsAdd(List<String> groups) throws IOException {
        }

        public Set<String> getGroupsSet(String user) throws IOException {
            LOG.info("Getting groups in MockUnixGroupsMapping");
            String g1 = user + (10 * i + 1);
            String g2 = user + (10 * i + 2);
            HashSet<String> s = new HashSet<String>(Arrays.asList(g1, g2));
            ++i;
            return s;
        }
    }
}

