/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.tools.rumen.DeepCompare;
import org.apache.hadoop.tools.rumen.DeepInequalityException;
import org.apache.hadoop.tools.rumen.Histogram;
import org.apache.hadoop.tools.rumen.LoggedSingleRelativeRanking;
import org.apache.hadoop.tools.rumen.TreePath;

public class LoggedDiscreteCDF
implements DeepCompare {
    long numberValues = -1L;
    long minimum = Long.MIN_VALUE;
    List<LoggedSingleRelativeRanking> rankings = new ArrayList<LoggedSingleRelativeRanking>();
    long maximum = Long.MAX_VALUE;

    void setCDF(Histogram data, int[] steps, int modulus) {
        this.numberValues = data.getTotalCount();
        long[] CDF = data.getCDF(modulus, steps);
        if (CDF != null) {
            this.minimum = CDF[0];
            this.maximum = CDF[CDF.length - 1];
            this.rankings = new ArrayList<LoggedSingleRelativeRanking>();
            for (int i = 1; i < CDF.length - 1; ++i) {
                LoggedSingleRelativeRanking srr = new LoggedSingleRelativeRanking();
                srr.setRelativeRanking((double)steps[i - 1] / (double)modulus);
                srr.setDatum(CDF[i]);
                this.rankings.add(srr);
            }
        }
    }

    public long getMinimum() {
        return this.minimum;
    }

    void setMinimum(long minimum) {
        this.minimum = minimum;
    }

    public List<LoggedSingleRelativeRanking> getRankings() {
        return this.rankings;
    }

    void setRankings(List<LoggedSingleRelativeRanking> rankings) {
        this.rankings = rankings;
    }

    public long getMaximum() {
        return this.maximum;
    }

    void setMaximum(long maximum) {
        this.maximum = maximum;
    }

    public long getNumberValues() {
        return this.numberValues;
    }

    void setNumberValues(long numberValues) {
        this.numberValues = numberValues;
    }

    private void compare1(long c1, long c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 != c2) {
            throw new DeepInequalityException(eltname + " miscompared", new TreePath(loc, eltname));
        }
    }

    private void compare1(List<LoggedSingleRelativeRanking> c1, List<LoggedSingleRelativeRanking> c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 == null && c2 == null) {
            return;
        }
        if (c1 == null || c2 == null || c1.size() != c2.size()) {
            throw new DeepInequalityException(eltname + " miscompared", new TreePath(loc, eltname));
        }
        for (int i = 0; i < c1.size(); ++i) {
            c1.get(i).deepCompare(c2.get(i), new TreePath(loc, eltname, i));
        }
    }

    @Override
    public void deepCompare(DeepCompare comparand, TreePath loc) throws DeepInequalityException {
        if (!(comparand instanceof LoggedDiscreteCDF)) {
            throw new DeepInequalityException("comparand has wrong type", loc);
        }
        LoggedDiscreteCDF other = (LoggedDiscreteCDF)comparand;
        this.compare1(this.numberValues, other.numberValues, loc, "numberValues");
        this.compare1(this.minimum, other.minimum, loc, "minimum");
        this.compare1(this.maximum, other.maximum, loc, "maximum");
        this.compare1(this.rankings, other.rankings, loc, "rankings");
    }
}

