/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener.api.event;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.gravitino.annotation.DeveloperApi;
import org.apache.gravitino.listener.api.event.OperationType;
import org.apache.gravitino.listener.api.event.UserEvent;
import org.apache.gravitino.listener.api.info.UserInfo;
import org.apache.gravitino.utils.NameIdentifierUtil;

@DeveloperApi
public class GrantUserRolesEvent
extends UserEvent {
    private final UserInfo grantUserInfo;
    private final List<String> roles;

    public GrantUserRolesEvent(String initiator, String metalake, UserInfo grantUserInfo, List<String> roles) {
        super(initiator, NameIdentifierUtil.ofUser(metalake, grantUserInfo.name()));
        this.grantUserInfo = grantUserInfo;
        this.roles = roles == null ? ImmutableList.of() : ImmutableList.copyOf(roles);
    }

    public UserInfo grantUserInfo() {
        return this.grantUserInfo;
    }

    public List<String> roles() {
        return this.roles;
    }

    @Override
    public OperationType operationType() {
        return OperationType.GRANT_USER_ROLES;
    }
}

