/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.meta;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.gravitino.Auditable;
import org.apache.gravitino.Entity;
import org.apache.gravitino.Field;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.Metalake;
import org.apache.gravitino.connector.PropertiesMetadata;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.SchemaVersion;
import org.apache.gravitino.metalake.MetalakePropertiesMetadata;

public class BaseMetalake
implements Metalake,
Entity,
Auditable,
HasIdentifier {
    public static final Field ID = Field.required("id", Long.class, "The metalake's unique identifier");
    public static final Field NAME = Field.required("name", String.class, "The metalake's name");
    public static final Field COMMENT = Field.optional("comment", String.class, "The metalake's comment or description");
    public static final Field PROPERTIES = Field.optional("properties", Map.class, "The properties associated with the metalake");
    public static final Field AUDIT_INFO = Field.required("audit_info", AuditInfo.class, "The audit details of the metalake");
    public static final Field SCHEMA_VERSION = Field.required("version", SchemaVersion.class, "The version of the schema for the metalake");
    public static final PropertiesMetadata PROPERTIES_METADATA = new MetalakePropertiesMetadata();
    private Long id;
    private String name;
    @Nullable
    private String comment;
    @Nullable
    private Map<String, String> properties;
    private AuditInfo auditInfo;
    SchemaVersion version;

    private BaseMetalake() {
    }

    @Override
    public Map<Field, Object> fields() {
        HashMap<Field, Object> fields = new HashMap<Field, Object>();
        fields.put(ID, this.id);
        fields.put(NAME, this.name);
        fields.put(COMMENT, this.comment);
        fields.put(PROPERTIES, this.properties);
        fields.put(AUDIT_INFO, this.auditInfo);
        fields.put(SCHEMA_VERSION, (Object)this.version);
        return Collections.unmodifiableMap(fields);
    }

    public AuditInfo auditInfo() {
        return this.auditInfo;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Long id() {
        return this.id;
    }

    public String comment() {
        return this.comment;
    }

    @Override
    public Entity.EntityType type() {
        return Entity.EntityType.METALAKE;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public PropertiesMetadata propertiesMetadata() {
        return PROPERTIES_METADATA;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseMetalake)) {
            return false;
        }
        BaseMetalake other = (BaseMetalake)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.id;
        Long other$id = other.id;
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$comment = this.comment;
        String other$comment = other.comment;
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Map<String, String> this$properties = this.properties;
        Map<String, String> other$properties = other.properties;
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        AuditInfo this$auditInfo = this.auditInfo;
        AuditInfo other$auditInfo = other.auditInfo;
        if (this$auditInfo == null ? other$auditInfo != null : !((Object)this$auditInfo).equals(other$auditInfo)) {
            return false;
        }
        SchemaVersion this$version = this.getVersion();
        SchemaVersion other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !((Object)((Object)this$version)).equals((Object)other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseMetalake;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.id;
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $comment = this.comment;
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Map<String, String> $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        AuditInfo $auditInfo = this.auditInfo;
        result = result * 59 + ($auditInfo == null ? 43 : ((Object)$auditInfo).hashCode());
        SchemaVersion $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)((Object)$version)).hashCode());
        return result;
    }

    public String toString() {
        return "BaseMetalake(id=" + this.id + ", name=" + this.name + ", comment=" + this.comment + ", properties=" + String.valueOf(this.properties) + ", auditInfo=" + String.valueOf(this.auditInfo) + ", version=" + String.valueOf((Object)this.getVersion()) + ")";
    }

    public SchemaVersion getVersion() {
        return this.version;
    }

    public static class Builder {
        private final BaseMetalake metalake = new BaseMetalake();

        private Builder() {
        }

        public Builder withId(Long id) {
            this.metalake.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.metalake.name = name;
            return this;
        }

        public Builder withComment(String comment) {
            this.metalake.comment = comment;
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            this.metalake.properties = properties;
            return this;
        }

        public Builder withAuditInfo(AuditInfo auditInfo) {
            this.metalake.auditInfo = auditInfo;
            return this;
        }

        public Builder withVersion(SchemaVersion version) {
            this.metalake.version = version;
            return this;
        }

        public BaseMetalake build() {
            this.metalake.validate();
            return this.metalake;
        }
    }
}

