/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.base;

import org.apache.gravitino.storage.relational.po.PolicyVersionPO;
import org.apache.ibatis.annotations.Param;

public class PolicyVersionBaseSQLProvider {
    public String insertPolicyVersionOnDuplicateKeyUpdate(@Param(value="policyVersion") PolicyVersionPO policyVersion) {
        return "INSERT INTO policy_version_info (metalake_id, policy_id, version, policy_comment, enabled, content, deleted_at) VALUES (#{policyVersion.metalakeId}, #{policyVersion.policyId}, #{policyVersion.version}, #{policyVersion.policyComment}, #{policyVersion.enabled}, #{policyVersion.content}, #{policyVersion.deletedAt}) ON DUPLICATE KEY UPDATE metalake_id = #{policyVersion.metalakeId}, policy_id = #{policyVersion.policyId}, version = #{policyVersion.version}, policy_comment = #{policyVersion.policyComment}, enabled = #{policyVersion.enabled}, content = #{policyVersion.content}, deleted_at = #{policyVersion.deletedAt}";
    }

    public String insertPolicyVersion(@Param(value="policyVersion") PolicyVersionPO policyVersion) {
        return "INSERT INTO policy_version_info (metalake_id, policy_id, version, policy_comment, enabled, content, deleted_at) VALUES (#{policyVersion.metalakeId}, #{policyVersion.policyId}, #{policyVersion.version}, #{policyVersion.policyComment}, #{policyVersion.enabled}, #{policyVersion.content}, #{policyVersion.deletedAt})";
    }

    public String softDeletePolicyVersionByMetalakeAndPolicyName(@Param(value="metalakeName") String metalakeName, @Param(value="policyName") String policyName) {
        return "UPDATE policy_version_info pv SET pv.deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE pv.metalake_id IN ( SELECT mm.metalake_id FROM metalake_meta mm WHERE mm.metalake_name = #{metalakeName} AND mm.deleted_at = 0) AND pv.policy_id IN ( SELECT pm.policy_id FROM policy_meta pm WHERE pm.policy_name = #{policyName} AND pm.deleted_at = 0 AND pm.metalake_id IN ( SELECT mm.metalake_id FROM metalake_meta mm WHERE mm.metalake_name = #{metalakeName} AND mm.deleted_at = 0)) AND pv.deleted_at = 0";
    }

    public String deletePolicyVersionsByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM policy_version_info WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}";
    }

    public String selectPolicyVersionsByRetentionCount(@Param(value="versionRetentionCount") Long versionRetentionCount) {
        return "SELECT policy_id as policyId, Max(version) as version FROM policy_version_info WHERE version > #{versionRetentionCount} AND deleted_at = 0 GROUP BY policy_id";
    }

    public String softDeletePolicyVersionsByRetentionLine(@Param(value="policyId") Long policyId, @Param(value="versionRetentionLine") long versionRetentionLine, @Param(value="limit") int limit) {
        return "UPDATE policy_version_info SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE policy_id = #{policyId} AND version <= #{versionRetentionLine} AND deleted_at = 0 LIMIT #{limit}";
    }

    public String softDeletePolicyVersionsByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return "UPDATE policy_version_info SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }
}

