/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.po;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.apache.gravitino.storage.relational.po.PolicyVersionPO;

public class PolicyPO {
    private Long policyId;
    private String policyName;
    private String policyType;
    private Long metalakeId;
    private String auditInfo;
    private Long currentVersion;
    private Long lastVersion;
    private Long deletedAt;
    private PolicyVersionPO policyVersionPO;

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PolicyPO)) {
            return false;
        }
        PolicyPO policyPO = (PolicyPO)o;
        return Objects.equal((Object)this.policyId, (Object)policyPO.policyId) && Objects.equal((Object)this.policyName, (Object)policyPO.policyName) && Objects.equal((Object)this.policyType, (Object)policyPO.policyType) && Objects.equal((Object)this.metalakeId, (Object)policyPO.metalakeId) && Objects.equal((Object)this.auditInfo, (Object)policyPO.auditInfo) && Objects.equal((Object)this.currentVersion, (Object)policyPO.currentVersion) && Objects.equal((Object)this.lastVersion, (Object)policyPO.lastVersion) && Objects.equal((Object)this.policyVersionPO, (Object)policyPO.policyVersionPO) && Objects.equal((Object)this.deletedAt, (Object)policyPO.deletedAt);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.policyId, this.policyName, this.policyType, this.metalakeId, this.auditInfo, this.currentVersion, this.lastVersion, this.policyVersionPO, this.deletedAt});
    }

    public Long getPolicyId() {
        return this.policyId;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public Long getMetalakeId() {
        return this.metalakeId;
    }

    public String getAuditInfo() {
        return this.auditInfo;
    }

    public Long getCurrentVersion() {
        return this.currentVersion;
    }

    public Long getLastVersion() {
        return this.lastVersion;
    }

    public Long getDeletedAt() {
        return this.deletedAt;
    }

    public PolicyVersionPO getPolicyVersionPO() {
        return this.policyVersionPO;
    }

    public static class Builder {
        private Long policyId;
        private String policyName;
        private String policyType;
        private Long metalakeId;
        private String auditInfo;
        private Long currentVersion;
        private Long lastVersion;
        private Long deletedAt;
        private PolicyVersionPO policyVersionPO;

        public Builder withPolicyId(Long policyId) {
            this.policyId = policyId;
            return this;
        }

        public Builder withPolicyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public Builder withMetalakeId(Long metalakeId) {
            this.metalakeId = metalakeId;
            return this;
        }

        public Builder withPolicyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        public Builder withAuditInfo(String auditInfo) {
            this.auditInfo = auditInfo;
            return this;
        }

        public Builder withCurrentVersion(Long currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public Builder withLastVersion(Long lastVersion) {
            this.lastVersion = lastVersion;
            return this;
        }

        public Builder withDeletedAt(Long deletedAt) {
            this.deletedAt = deletedAt;
            return this;
        }

        public Builder withPolicyVersionPO(PolicyVersionPO policyVersionPO) {
            this.policyVersionPO = policyVersionPO;
            return this;
        }

        public Long getMetalakeId() {
            Preconditions.checkArgument((this.metalakeId != null ? 1 : 0) != 0, (Object)"Metalake id is required");
            return this.metalakeId;
        }

        public PolicyPO build() {
            this.validate();
            PolicyPO policyPO = new PolicyPO();
            policyPO.policyId = this.policyId;
            policyPO.policyName = this.policyName;
            policyPO.metalakeId = this.metalakeId;
            policyPO.policyType = this.policyType;
            policyPO.auditInfo = this.auditInfo;
            policyPO.currentVersion = this.currentVersion;
            policyPO.lastVersion = this.lastVersion;
            policyPO.deletedAt = this.deletedAt;
            policyPO.policyVersionPO = this.policyVersionPO;
            return policyPO;
        }

        private void validate() {
            Preconditions.checkArgument((this.policyId != null ? 1 : 0) != 0, (Object)"Policy id is required");
            Preconditions.checkArgument((this.policyName != null ? 1 : 0) != 0, (Object)"Policy name is required");
            Preconditions.checkArgument((this.metalakeId != null ? 1 : 0) != 0, (Object)"Metalake id is required");
            Preconditions.checkArgument((this.policyType != null ? 1 : 0) != 0, (Object)"Policy type is required");
            Preconditions.checkArgument((this.currentVersion != null ? 1 : 0) != 0, (Object)"Current version is required");
            Preconditions.checkArgument((this.lastVersion != null ? 1 : 0) != 0, (Object)"Last version is required");
            Preconditions.checkArgument((this.deletedAt != null ? 1 : 0) != 0, (Object)"Deleted at is required");
            Preconditions.checkArgument((this.auditInfo != null ? 1 : 0) != 0, (Object)"Audit info is required");
            Preconditions.checkArgument((this.policyVersionPO != null ? 1 : 0) != 0, (Object)"Policy version is required");
        }
    }
}

