/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.parquet.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.apache.paimon.shade.org.apache.parquet.io.InputFile;
import org.apache.paimon.shade.org.apache.parquet.io.SeekableInputStream;

public class LocalInputFile
implements InputFile {
    private final Path path;
    private long length = -1L;

    public LocalInputFile(Path file) {
        this.path = file;
    }

    @Override
    public long getLength() throws IOException {
        if (this.length == -1L) {
            try (RandomAccessFile file = new RandomAccessFile(this.path.toFile(), "r");){
                this.length = file.length();
            }
        }
        return this.length;
    }

    @Override
    public SeekableInputStream newStream() throws IOException {
        return new SeekableInputStream(){
            private final RandomAccessFile randomAccessFile;
            {
                this.randomAccessFile = new RandomAccessFile(LocalInputFile.this.path.toFile(), "r");
            }

            @Override
            public int read() throws IOException {
                return this.randomAccessFile.read();
            }

            @Override
            public long getPos() throws IOException {
                return this.randomAccessFile.getFilePointer();
            }

            @Override
            public void seek(long newPos) throws IOException {
                this.randomAccessFile.seek(newPos);
            }

            @Override
            public void readFully(byte[] bytes) throws IOException {
                this.randomAccessFile.readFully(bytes);
            }

            @Override
            public void readFully(byte[] bytes, int start, int len) throws IOException {
                this.randomAccessFile.readFully(bytes, start, len);
            }

            @Override
            public int read(ByteBuffer buf) throws IOException {
                byte[] buffer = new byte[buf.remaining()];
                int code = this.read(buffer);
                buf.put(buffer, buf.position() + buf.arrayOffset(), buf.remaining());
                return code;
            }

            @Override
            public void readFully(ByteBuffer buf) throws IOException {
                byte[] buffer = new byte[buf.remaining()];
                this.readFully(buffer);
                buf.put(buffer, buf.position() + buf.arrayOffset(), buf.remaining());
            }

            @Override
            public void close() throws IOException {
                this.randomAccessFile.close();
            }
        };
    }
}

