/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog;

import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.session.PropertyMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.gravitino.trino.connector.metadata.GravitinoColumn;
import org.apache.gravitino.trino.connector.metadata.GravitinoSchema;
import org.apache.gravitino.trino.connector.metadata.GravitinoTable;
import org.apache.gravitino.trino.connector.util.GeneralDataTypeTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogConnectorMetadataAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogConnectorMetadataAdapter.class);
    protected final List<PropertyMetadata<?>> schemaProperties;
    protected final List<PropertyMetadata<?>> tableProperties;
    protected final List<PropertyMetadata<?>> columnProperties;
    protected final GeneralDataTypeTransformer dataTypeTransformer;

    protected CatalogConnectorMetadataAdapter(List<PropertyMetadata<?>> schemaProperties, List<PropertyMetadata<?>> tableProperties, List<PropertyMetadata<?>> columnProperties, GeneralDataTypeTransformer dataTypeTransformer) {
        this.schemaProperties = schemaProperties;
        this.tableProperties = tableProperties;
        this.columnProperties = columnProperties;
        this.dataTypeTransformer = dataTypeTransformer;
    }

    public Map<String, Object> getSchemaProperties(GravitinoSchema schema) {
        return this.toTrinoSchemaProperties(schema.getProperties());
    }

    public GeneralDataTypeTransformer getDataTypeTransformer() {
        return this.dataTypeTransformer;
    }

    public ConnectorTableMetadata getTableMetadata(GravitinoTable gravitinoTable) {
        SchemaTableName schemaTableName = new SchemaTableName(gravitinoTable.getSchemaName(), gravitinoTable.getName());
        ArrayList<ColumnMetadata> columnMetadataList = new ArrayList<ColumnMetadata>();
        for (GravitinoColumn column : gravitinoTable.getColumns()) {
            columnMetadataList.add(this.getColumnMetadata(column));
        }
        Map<String, Object> properties = this.toTrinoTableProperties(gravitinoTable.getProperties());
        return new ConnectorTableMetadata(schemaTableName, columnMetadataList, properties, Optional.ofNullable(gravitinoTable.getComment()));
    }

    public GravitinoTable createTable(ConnectorTableMetadata tableMetadata) {
        String tableName = tableMetadata.getTableSchema().getTable().getTableName();
        String schemaName = tableMetadata.getTableSchema().getTable().getSchemaName();
        String comment = tableMetadata.getComment().orElse("");
        Map<String, String> properties = this.toGravitinoTableProperties(tableMetadata.getProperties());
        ArrayList<GravitinoColumn> columns = new ArrayList<GravitinoColumn>();
        for (int i = 0; i < tableMetadata.getColumns().size(); ++i) {
            ColumnMetadata column = (ColumnMetadata)tableMetadata.getColumns().get(i);
            columns.add(new GravitinoColumn(column.getName(), this.dataTypeTransformer.getGravitinoType(column.getType()), i, column.getComment(), column.isNullable(), false, column.getProperties()));
        }
        return new GravitinoTable(schemaName, tableName, columns, comment, properties);
    }

    protected Map<String, Object> removeKeys(Map<String, Object> properties, Set<String> keyToDelete) {
        return properties.entrySet().stream().filter(entry -> !keyToDelete.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public GravitinoSchema createSchema(String schemaName, Map<String, Object> properties) {
        return new GravitinoSchema(schemaName, this.toGravitinoSchemaProperties(properties), "");
    }

    public ColumnMetadata getColumnMetadata(GravitinoColumn column) {
        return ColumnMetadata.builder().setName(column.getName()).setType(this.dataTypeTransformer.getTrinoType(column.getType())).setComment(Optional.ofNullable(column.getComment())).setNullable(column.isNullable()).setHidden(column.isHidden()).setProperties(column.getProperties()).build();
    }

    public ConnectorTableProperties getTableProperties(GravitinoTable table) {
        throw new NotImplementedException();
    }

    private Map<String, Object> normalizeProperties(Map<String, String> properties, List<PropertyMetadata<?>> propertyTemplate) {
        HashMap<String, Object> validProperties = new HashMap<String, Object>();
        for (PropertyMetadata<?> propertyMetadata : propertyTemplate) {
            String name = propertyMetadata.getName();
            if (properties.containsKey(name)) {
                validProperties.put(name, properties.get(name));
                continue;
            }
            LOG.warn("Property {} is not defined in Trino, we will ignore it", (Object)name);
        }
        return validProperties;
    }

    public Map<String, Object> toTrinoTableProperties(Map<String, String> properties) {
        return this.normalizeProperties(properties, this.tableProperties);
    }

    public Map<String, Object> toTrinoSchemaProperties(Map<String, String> properties) {
        return this.normalizeProperties(properties, this.schemaProperties);
    }

    public Map<String, String> toGravitinoTableProperties(Map<String, Object> properties) {
        return this.removeUnsetProperties(properties);
    }

    public Map<String, String> toGravitinoSchemaProperties(Map<String, Object> properties) {
        return this.removeUnsetProperties(properties);
    }

    private Map<String, String> removeUnsetProperties(Map<String, Object> properties) {
        return properties.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
    }

    public GravitinoColumn createColumn(ColumnMetadata column) {
        return new GravitinoColumn(column.getName(), this.dataTypeTransformer.getGravitinoType(column.getType()), -1, column.getComment(), column.isNullable(), false, column.getProperties());
    }
}

